/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.internationalization.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openswing.swing.internationalization.java.Resources;
import org.openswing.swing.internationalization.java.ResourcesFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLResourcesFactory
extends ResourcesFactory {
    private Hashtable allResources = new Hashtable();
    private Resources resources = null;
    private boolean showResourceNotFoundWarning = true;
    private Hashtable xmlFiles = null;

    public XMLResourcesFactory(Hashtable xmlFiles, boolean showResourceNotFoundWarning) {
        this.xmlFiles = xmlFiles;
        this.showResourceNotFoundWarning = showResourceNotFoundWarning;
    }

    public final Resources getResources(String langId) throws UnsupportedOperationException {
        Resources resources = (Resources)this.allResources.get(langId);
        if (resources != null) {
            return resources;
        }
        String xmlFile = (String)this.xmlFiles.get(langId);
        if (xmlFile == null) {
            throw new UnsupportedOperationException("Language unknown '" + langId + "'");
        }
        try {
            InputStream in = null;
            try {
                in = this.getClass().getClassLoader().getResourceAsStream(xmlFile.replaceAll("%20", " "));
                if (in == null) {
                    in = new FileInputStream(xmlFile.replaceAll("%20", " "));
                }
            }
            catch (Exception ex1) {
                in = new FileInputStream(xmlFile.replaceAll("%20", " "));
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(in);
            NodeList nodes = doc.getElementsByTagName("object");
            Properties p = new Properties();
            int i = 0;
            while (i < nodes.getLength()) {
                p.setProperty(((Element)nodes.item(i)).getAttribute("key"), ((Element)nodes.item(i)).getAttribute("value"));
                ++i;
            }
            nodes = doc.getElementsByTagName("currencySymbol");
            String currencySymbol = nodes.item(0).getChildNodes().item(0).getNodeValue();
            nodes = doc.getElementsByTagName("decimalSymbol");
            char decimalSymbol = nodes.item(0).getChildNodes().item(0).getNodeValue().charAt(0);
            nodes = doc.getElementsByTagName("groupingSymbol");
            char groupingSymbol = nodes.item(0).getChildNodes().item(0).getNodeValue().charAt(0);
            nodes = doc.getElementsByTagName("dateFormat");
            String dateFormatStr = nodes.item(0).getChildNodes().item(0).getNodeValue();
            int dateFormat = -1;
            if (dateFormatStr.equals("DMY")) {
                dateFormat = 1;
            } else if (dateFormatStr.equals("MDY")) {
                dateFormat = 2;
            } else if (dateFormatStr.equals("YDM")) {
                dateFormat = 3;
            } else if (dateFormatStr.equals("YMD")) {
                dateFormat = 0;
            }
            nodes = doc.getElementsByTagName("showCenturyInDateFormat");
            boolean showCenturyInDateFormat = nodes.item(0).getChildNodes().item(0).getNodeValue().toLowerCase().equals("true");
            nodes = doc.getElementsByTagName("dateFormatSeparator");
            char dateFormatSeparator = nodes.item(0).getChildNodes().item(0).getNodeValue().charAt(0);
            nodes = doc.getElementsByTagName("timeFormat");
            String timeFormat = nodes.item(0).getChildNodes().item(0).getNodeValue();
            in.close();
            resources = new Resources(p, currencySymbol, decimalSymbol, groupingSymbol, dateFormat, showCenturyInDateFormat, dateFormatSeparator, timeFormat, langId, this.showResourceNotFoundWarning);
            this.allResources.put(langId, resources);
            return resources;
        }
        catch (Throwable ex) {
            String msg = "Error while loading internationalization settings for language '" + langId + "'" + "\nin file: " + new File(xmlFile).getAbsolutePath();
            System.err.println(msg);
            ex.printStackTrace();
            return this.resources;
        }
    }

    public final Resources getResources() {
        return this.resources;
    }

    public final void setLanguage(String langId) throws UnsupportedOperationException {
        this.resources = this.getResources(langId);
    }
}

