/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.logger.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.log4j.Logger;
import org.openswing.swing.logger.server.LoggerMethods;

public class Log4JLogger
implements LoggerMethods {
    private Logger logger = null;

    public Log4JLogger(String id) {
        this.logger = Logger.getLogger((String)id);
    }

    public Log4JLogger() {
        this.logger = this.logger = Logger.getRootLogger();
    }

    public final void debug(String username, String className, String methodName, String debugMessage) {
        this.logger.debug((Object)("\n------------------------\n" + (username != null ? "[" + username + "] " : "[UNDEFINED] ") + new Date() + " [DEBUG]\n" + "in " + className + "." + methodName + "():\n" + debugMessage + "\n" + "------------------------"));
    }

    public final void error(String username, String className, String methodName, String errorMessage, Throwable exception) {
        this.logger.error((Object)("\n------------------------\n" + (username != null ? "[" + username + "] " : "[UNDEFINED] ") + new Date() + " [ERROR]\n" + "in " + className + "." + methodName + "():\n" + errorMessage + "\n" + "------------------------"), exception);
    }

    public final void info(String username, String className, String methodName, String infoMessage) {
        this.logger.info((Object)("\n------------------------\n" + (username != null ? "[" + username + "] " : "[UNDEFINED] ") + new Date() + " [INFO]\n" + "in " + className + "." + methodName + "():\n" + infoMessage + "\n" + "------------------------"));
    }

    public final void warn(String username, String className, String methodName, String warnMessage) {
        this.logger.warn((Object)("\n------------------------\n" + (username != null ? "[" + username + "] " : "[UNDEFINED] ") + new Date() + " [WARN]\n" + "in " + className + "." + methodName + "():\n" + warnMessage + "\n" + "------------------------"));
    }

    class StackTraceCollector
    extends OutputStream {
        private StringBuffer stack = new StringBuffer();

        StackTraceCollector() {
        }

        public String toString() {
            return this.stack.toString();
        }

        public void write(int b) throws IOException {
            this.stack.append((char)b);
        }
    }
}

