/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.permissions.java;

import java.io.Serializable;
import java.util.Hashtable;

public class ButtonsAuthorizations
implements Serializable {
    private Hashtable authorizations = new Hashtable();

    public final void addButtonAuthorization(String functionId, boolean isInsertEnabled, boolean isEditEnabled, boolean isDeleteEnabled) {
        ButtonAuthorization ba = (ButtonAuthorization)this.authorizations.get(functionId);
        if (ba == null) {
            this.authorizations.put(functionId, new ButtonAuthorization(isInsertEnabled, isEditEnabled, isDeleteEnabled));
        } else {
            this.authorizations.put(functionId, new ButtonAuthorization(ba.isInsertEnabled() || isInsertEnabled, ba.isEditEnabled() || isEditEnabled, ba.isDeleteEnabled() || isDeleteEnabled));
        }
    }

    public final boolean isDeleteEnabled(String functionId) {
        if (functionId == null) {
            return true;
        }
        ButtonAuthorization auth = (ButtonAuthorization)this.authorizations.get(functionId);
        if (auth == null) {
            return true;
        }
        return auth.isDeleteEnabled();
    }

    public final boolean isEditEnabled(String functionId) {
        if (functionId == null) {
            return true;
        }
        ButtonAuthorization auth = (ButtonAuthorization)this.authorizations.get(functionId);
        if (auth == null) {
            return true;
        }
        return auth.isEditEnabled();
    }

    public final boolean isInsertEnabled(String functionId) {
        if (functionId == null) {
            return true;
        }
        ButtonAuthorization auth = (ButtonAuthorization)this.authorizations.get(functionId);
        if (auth == null) {
            return true;
        }
        return auth.isInsertEnabled();
    }

    class ButtonAuthorization
    implements Serializable {
        private boolean isDeleteEnabled;
        private boolean isEditEnabled;
        private boolean isInsertEnabled;

        public ButtonAuthorization(boolean isInsertEnabled, boolean isEditEnabled, boolean isDeleteEnabled) {
            this.isInsertEnabled = isInsertEnabled;
            this.isEditEnabled = isEditEnabled;
            this.isDeleteEnabled = isDeleteEnabled;
        }

        public final boolean isDeleteEnabled() {
            return this.isDeleteEnabled;
        }

        public final boolean isEditEnabled() {
            return this.isEditEnabled;
        }

        public final boolean isInsertEnabled() {
            return this.isInsertEnabled;
        }
    }
}

