/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.pivottable.server;

import java.util.HashMap;
import java.util.HashSet;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.pivottable.functions.java.GenericFunction;
import org.openswing.swing.pivottable.java.ColGenericNode;
import org.openswing.swing.pivottable.java.ColumnField;
import org.openswing.swing.pivottable.java.DataField;
import org.openswing.swing.pivottable.java.GenericNodeKey;
import org.openswing.swing.pivottable.java.GlobalColGenericNode;
import org.openswing.swing.pivottable.java.PivotTableModel;
import org.openswing.swing.pivottable.java.PivotTableParameters;
import org.openswing.swing.pivottable.java.RowField;
import org.openswing.swing.pivottable.java.RowGenericNode;
import org.openswing.swing.pivottable.tablemodelreaders.server.Reader;

public class PivotTableEngine {
    private Reader reader = null;

    public PivotTableEngine(Reader reader) {
        this.reader = reader;
    }

    private void fillRow(PivotTableParameters pars, int[] dataFieldsIndexes, GenericFunction[] gf) {
        Number n = null;
        int j = 0;
        while (j < pars.getDataFields().size()) {
            n = (Number)this.reader.getValueAt(dataFieldsIndexes[j]);
            gf[j].processValue(this.reader.getValueAt(dataFieldsIndexes[j]));
            ++j;
        }
    }

    public final Response getPivotTableModel(PivotTableParameters pars) {
        HashSet<String> cols = new HashSet<String>();
        int i = 0;
        while (i < this.reader.getColumnCount()) {
            cols.add(this.reader.getColumnName(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < pars.getRowFields().size()) {
            if (!cols.contains(((RowField)pars.getRowFields().get(i2)).getColumnName())) {
                return new ErrorResponse(((RowField)pars.getRowFields().get(i2)).getColumnName() + "' row field is not defined in data model: Pivot Table cannot be created.");
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < pars.getColumnFields().size()) {
            if (!cols.contains(((ColumnField)pars.getColumnFields().get(i3)).getColumnName())) {
                return new ErrorResponse(((ColumnField)pars.getColumnFields().get(i3)).getColumnName() + "' column field is not defined in data model: Pivot Table cannot be created.");
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < pars.getDataFields().size()) {
            if (!cols.contains(((DataField)pars.getDataFields().get(i4)).getColumnName())) {
                return new ErrorResponse(((DataField)pars.getDataFields().get(i4)).getColumnName() + "' data field is not defined in data model: Pivot Table cannot be created.");
            }
            ++i4;
        }
        if (pars.getRowFields().size() == 0) {
            return new ErrorResponse("At least one field must be defined as row field: Pivot Table cannot be created.");
        }
        if (pars.getColumnFields().size() == 0) {
            return new ErrorResponse("At least one field must be defined as column field: Pivot Table cannot be created.");
        }
        if (pars.getDataFields().size() == 0) {
            return new ErrorResponse("At least one field must be defined as data field: Pivot Table cannot be created.");
        }
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        int j = 0;
        while (j < this.reader.getColumnCount()) {
            indexes.put(this.reader.getColumnName(j), new Integer(j));
            ++j;
        }
        int[] rowFieldsIndexes = new int[pars.getRowFields().size()];
        int j2 = 0;
        while (j2 < pars.getRowFields().size()) {
            rowFieldsIndexes[j2] = (Integer)indexes.get(((RowField)pars.getRowFields().get(j2)).getColumnName());
            ++j2;
        }
        int[] dataFieldsIndexes = new int[pars.getDataFields().size()];
        int j3 = 0;
        while (j3 < pars.getDataFields().size()) {
            dataFieldsIndexes[j3] = (Integer)indexes.get(((DataField)pars.getDataFields().get(j3)).getColumnName());
            ++j3;
        }
        int[] colFieldsIndexes = new int[pars.getColumnFields().size()];
        int j4 = 0;
        while (j4 < pars.getColumnFields().size()) {
            colFieldsIndexes[j4] = (Integer)indexes.get(((ColumnField)pars.getColumnFields().get(j4)).getColumnName());
            ++j4;
        }
        RowGenericNode hroot = new RowGenericNode();
        GlobalColGenericNode vroot = new GlobalColGenericNode();
        PivotTableModel model = new PivotTableModel(hroot, vroot);
        if (!this.reader.initializeScrolling(pars.getInputFilter())) {
            return new ErrorResponse("Error on reading data on input.");
        }
        GenericNodeKey hpath = null;
        RowGenericNode hnode = null;
        ColGenericNode vnode = null;
        GlobalColGenericNode globalvnode = null;
        RowGenericNode hparentNode = null;
        ColGenericNode vparentNode = null;
        GlobalColGenericNode globalvparentNode = null;
        RowField rowField = null;
        ColumnField colField = null;
        Object hvalue = null;
        Object vvalue = null;
        HashMap<GenericNodeKey, RowGenericNode> htreeNodes = new HashMap<GenericNodeKey, RowGenericNode>();
        HashMap vtreeNodes = null;
        HashMap<GenericNodeKey, GlobalColGenericNode> globalvtreeNodes = new HashMap<GenericNodeKey, GlobalColGenericNode>();
        GenericFunction[] gf = null;
        GenericNodeKey vpath = null;
        while (this.reader.nextRow(pars.getInputFilter())) {
            hparentNode = hroot;
            hpath = new GenericNodeKey();
            int j5 = 0;
            while (j5 < pars.getRowFields().size()) {
                rowField = (RowField)pars.getRowFields().get(j5);
                hvalue = rowField.getAggregator().decodeValue(this.reader.getValueAt(rowFieldsIndexes[j5]));
                if (hvalue == null) {
                    hvalue = "";
                }
                if ((hnode = (RowGenericNode)htreeNodes.get(hpath = hpath.appendKey(hvalue))) == null) {
                    hnode = new RowGenericNode(hpath);
                    htreeNodes.put(hpath, hnode);
                    hparentNode.add(hnode);
                }
                vtreeNodes = hnode.getVtreeNodes();
                vparentNode = null;
                globalvparentNode = vroot;
                vpath = new GenericNodeKey();
                int y = 0;
                while (y < pars.getColumnFields().size()) {
                    colField = (ColumnField)pars.getColumnFields().get(y);
                    vvalue = colField.getAggregator().decodeValue(this.reader.getValueAt(colFieldsIndexes[y]));
                    if (vvalue == null) {
                        vvalue = "";
                    }
                    if ((vnode = (ColGenericNode)vtreeNodes.get(vpath = vpath.appendKey(vvalue))) == null) {
                        gf = new GenericFunction[dataFieldsIndexes.length];
                        int u = 0;
                        while (u < dataFieldsIndexes.length) {
                            try {
                                gf[u] = (GenericFunction)((DataField)pars.getDataFields().get(u)).getFunction().getClass().newInstance();
                            }
                            catch (Throwable ex) {
                                return new ErrorResponse("Error while analyzing data.");
                            }
                            ++u;
                        }
                        vnode = new ColGenericNode(vpath, gf);
                        vtreeNodes.put(vpath, vnode);
                        if (vparentNode != null) {
                            vparentNode.add(vnode);
                        } else {
                            hnode.setColsParentNode(vnode);
                        }
                    } else {
                        gf = vnode.getGenericFunctions();
                    }
                    this.fillRow(pars, dataFieldsIndexes, gf);
                    vparentNode = vnode;
                    globalvnode = (GlobalColGenericNode)globalvtreeNodes.get(vpath);
                    if (globalvnode == null) {
                        globalvnode = new GlobalColGenericNode(vpath);
                        globalvtreeNodes.put(vpath, globalvnode);
                        globalvparentNode.add(globalvnode);
                    }
                    globalvparentNode = globalvnode;
                    ++y;
                }
                hparentNode = hnode;
                ++j5;
            }
        }
        return new VOResponse(model);
    }
}

