/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.pivottable.tablemodelreaders.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import org.openswing.swing.pivottable.java.InputFilter;
import org.openswing.swing.pivottable.tablemodelreaders.server.Reader;
import org.openswing.swing.util.dataconverters.java.DataConverter;
import org.openswing.swing.util.dataconverters.java.DataConverterException;

public class CSVFileReader
implements Reader {
    private static final String DELIM = ";";
    private String[] attributeNames = null;
    private File csvFile = null;
    private String currentLine = null;
    private Object[] currentLineTokens = null;
    private DataConverter[] dataConverters = null;
    private BufferedReader in = null;
    private HashMap indexes = new HashMap();

    public CSVFileReader(File csvFile, String[] attributeNames, DataConverter[] dataConverters) {
        this.csvFile = csvFile;
        this.attributeNames = attributeNames;
        this.dataConverters = dataConverters;
        int i = 0;
        while (i < attributeNames.length) {
            this.indexes.put(attributeNames[i], new Integer(i));
            ++i;
        }
    }

    private String decodePattern(String pattern) {
        if (pattern.length() == 0) {
            return pattern;
        }
        StringBuffer aux = new StringBuffer("");
        int i = 0;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\"' && i + 1 < pattern.length() && pattern.charAt(i + 1) == '\"') {
                aux.append("\"");
                ++i;
            } else {
                aux.append(String.valueOf(pattern.charAt(i)));
            }
            ++i;
        }
        if (aux.charAt(0) == '\"' && aux.charAt(aux.length() - 1) == '\"') {
            return aux.substring(1, aux.length() - 1);
        }
        return aux.toString();
    }

    public final int getColumnCount() {
        return this.attributeNames.length;
    }

    public final String getColumnName(int index) {
        return this.attributeNames[index];
    }

    private int getRightEdge(String pattern, int index) {
        int odd = 0;
        int i = index;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\"') {
                ++odd;
            } else if (odd % 2 == 0) {
                odd = 0;
            } else {
                return i;
            }
            ++i;
        }
        return pattern.length();
    }

    public final Object getValueAt(int col) {
        if (this.currentLineTokens == null) {
            return null;
        }
        return this.currentLineTokens[col];
    }

    public boolean initializeScrolling(InputFilter inputFilter) {
        try {
            this.in = new BufferedReader(new InputStreamReader(new FileInputStream(this.csvFile)));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isOdd(String pattern, int index, int end) {
        int odd = 0;
        int i = index;
        while (i < end) {
            if (pattern.charAt(i) == '\"') {
                ++odd;
            }
            ++i;
        }
        return odd % 2 == 1;
    }

    public final boolean nextRow(InputFilter inputFilter) {
        try {
            Iterator it = null;
            this.currentLine = this.in.readLine();
            this.splitLine();
            while (this.currentLine != null && inputFilter != null) {
                it = inputFilter.getFilteredColumnNames();
                String colName = null;
                boolean skipRow = false;
                while (it.hasNext()) {
                    colName = it.next().toString();
                    skipRow = inputFilter.skipRow(colName, this.getValueAt((Integer)this.indexes.get(colName)));
                    if (skipRow) break;
                }
                if (!skipRow) break;
                this.currentLine = this.in.readLine();
                this.splitLine();
            }
            if (this.currentLine == null) {
                this.in.close();
            }
        }
        catch (Exception ex) {
            this.currentLineTokens = null;
            return false;
        }
        return this.currentLine != null;
    }

    private void splitLine() {
        if (this.currentLine == null) {
            this.currentLineTokens = null;
        } else {
            try {
                if (this.currentLine.trim().length() == 0) {
                    this.currentLineTokens = null;
                    return;
                }
                if (this.currentLineTokens == null) {
                    this.currentLineTokens = new Object[this.attributeNames.length];
                } else {
                    int i = 0;
                    while (i < this.currentLineTokens.length) {
                        this.currentLineTokens[i] = null;
                        ++i;
                    }
                }
                boolean bContinue = true;
                int i = 0;
                int j = 0;
                while (bContinue) {
                    int ind = this.currentLine.indexOf(DELIM, j);
                    if (ind == -1) {
                        ind = this.currentLine.length();
                        bContinue = false;
                        if (j > ind) {
                            continue;
                        }
                    } else if (this.isOdd(this.currentLine, j, ind)) {
                        ind = this.getRightEdge(this.currentLine, ind);
                    }
                    String value = ind == this.currentLine.length() ? this.currentLine.substring(j) : this.currentLine.substring(j, ind);
                    value = this.decodePattern(value);
                    j = ind + 1;
                    if (value != null && value.length() == 0) {
                        value = null;
                    }
                    try {
                        this.currentLineTokens[i] = this.dataConverters[i].decodeValue(value);
                    }
                    catch (DataConverterException ex) {
                        this.currentLineTokens[i] = null;
                    }
                    if (++i < this.currentLineTokens.length) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ec) {
                this.currentLineTokens = null;
            }
        }
    }
}

