/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.pivottable.tablemodelreaders.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.table.TableModel;
import org.openswing.swing.pivottable.java.InputFilter;
import org.openswing.swing.pivottable.tablemodelreaders.server.Reader;
import org.openswing.swing.pivottable.tablemodelreaders.server.VOTableModel;

public class TableModelReader
implements Reader {
    private int currentRow = -1;
    private HashMap indexes = new HashMap();
    private TableModel model = null;

    public TableModelReader(ArrayList valueObjects, String[] attributeNames) {
        this(new VOTableModel(valueObjects, attributeNames));
    }

    public TableModelReader(TableModel model) {
        this.model = model;
        int i = 0;
        while (i < model.getColumnCount()) {
            this.indexes.put(this.getColumnName(i), new Integer(i));
            ++i;
        }
    }

    public final int getColumnCount() {
        return this.model.getColumnCount();
    }

    public final String getColumnName(int index) {
        return this.model.getColumnName(index);
    }

    public final Object getValueAt(int col) {
        return this.model.getValueAt(this.currentRow, col);
    }

    public boolean initializeScrolling(InputFilter inputFilter) {
        this.currentRow = -1;
        return true;
    }

    public final boolean nextRow(InputFilter inputFilter) {
        ++this.currentRow;
        Iterator it = null;
        while (this.currentRow < this.model.getRowCount() && inputFilter != null) {
            it = inputFilter.getFilteredColumnNames();
            String colName = null;
            boolean skipRow = false;
            while (it.hasNext()) {
                colName = it.next().toString();
                skipRow = inputFilter.skipRow(colName, this.getValueAt((Integer)this.indexes.get(colName)));
                if (skipRow) break;
            }
            if (!skipRow) break;
            ++this.currentRow;
        }
        return this.currentRow < this.model.getRowCount();
    }
}

