/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.server;

import com.rp.database.RPDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.openswing.swing.server.ConnectionSource;

public class PoolerConnectionSource
implements ConnectionSource {
    private RPDataSource pool = null;

    public Connection getConnection(ServletContext context) throws Exception {
        Connection conn = this.pool.getConnection();
        try {
            conn.setTransactionIsolation(2);
        }
        catch (Exception ex) {
            // empty catch block
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public boolean initPooler(HttpServlet servlet) {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(this.getClass().getResource("/").getPath().replaceAll("%20", " ") + "pooler.ini"));
            if (props.getProperty("logLevel") == null || props.getProperty("logLevel").equals("")) {
                props.setProperty("logLevel", "1");
            }
            props.setProperty("autoCommit", "false");
            if (props.getProperty("maxCount") == null || props.getProperty("maxCount").equals("")) {
                props.setProperty("maxCount", "5");
            }
            if (props.getProperty("minCount") == null || props.getProperty("minCount").equals("")) {
                props.setProperty("minCount", "1");
            }
            if (props.getProperty("loginTimeout") == null || props.getProperty("loginTimeout").equals("")) {
                props.setProperty("loginTimeout", "0");
            }
            if (props.getProperty("holdTimeout") == null || props.getProperty("holdTimeout").equals("")) {
                props.setProperty("holdTimeout", "1000");
            }
            if (props.getProperty("waitTimeout") == null || props.getProperty("waitTimeout").equals("")) {
                props.setProperty("waitTimeout", "10000");
            }
            props.setProperty("statementCacheSize", "10");
            this.pool = new RPDataSource(props);
            return true;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            servlet.getServletContext().log("Error while creating connection pooler: file not found in\n" + new File("pooler.ini").getAbsolutePath(), (Throwable)ex);
            return false;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            servlet.getServletContext().log("Error while creating connection pooler", ex);
            return false;
        }
    }

    public void releaseConnection(Connection conn, ServletContext context) {
        try {
            conn.rollback();
            conn.close();
        }
        catch (SQLException ex) {
            context.log("Error while releasing the database connection", (Throwable)ex);
        }
    }

    public final void saveProperties(ServletContext context, String driverClass, String user, String password, String url) {
        try {
            Properties props = new Properties();
            props.setProperty("driverClass", driverClass);
            props.setProperty("user", user);
            props.setProperty("password", password);
            props.setProperty("url", url);
            props.save(new FileOutputStream(this.getClass().getResource("/").getPath().replaceAll("%20", " ") + "pooler.ini"), "POOLER PROPERTIES");
        }
        catch (Throwable ex) {
            context.log("Error while creating connection pooler", ex);
        }
    }
}

