/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.profiles.database.server;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.openswing.swing.message.send.java.FilterWhereClause;
import org.openswing.swing.table.profiles.database.server.DbActiveProfileDescriptor;
import org.openswing.swing.table.profiles.database.server.DbConnectionSource;
import org.openswing.swing.table.profiles.database.server.DbDigestDescriptor;
import org.openswing.swing.table.profiles.database.server.DbProfileDescriptor;
import org.openswing.swing.table.profiles.java.GridProfile;
import org.openswing.swing.table.profiles.java.GridProfileDescription;
import org.openswing.swing.table.profiles.java.GridProfileManager;

public class DbGridProfileManager
extends GridProfileManager {
    private DbActiveProfileDescriptor dbActiveProfileDescriptor = null;
    private DbConnectionSource dbConnectionSource = null;
    private DbDigestDescriptor dbDigestDescriptor = null;
    private DbProfileDescriptor dbProfileDescriptor = null;
    private SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");

    public DbGridProfileManager(DbConnectionSource dbConnectionSource, DbActiveProfileDescriptor dbActiveProfileDescriptor, DbDigestDescriptor dbDigestDescriptor, DbProfileDescriptor dbProfileDescriptor) {
        this.dbConnectionSource = dbConnectionSource;
        this.dbActiveProfileDescriptor = dbActiveProfileDescriptor;
        this.dbDigestDescriptor = dbDigestDescriptor;
        this.dbProfileDescriptor = dbProfileDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllGridProfileIds(String functionId) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            Hashtable h = this.dbActiveProfileDescriptor.deleteAllGridProfileIds(functionId);
            String where = " and ";
            Enumeration en = h.keys();
            String field = null;
            ArrayList whereValues = new ArrayList();
            while (en.hasMoreElements()) {
                field = en.nextElement().toString();
                where = where + field + "=? and ";
                whereValues.add(h.get(field));
            }
            where = where.length() > 5 ? where.substring(0, where.length() - 4) : "";
            pstmt = conn.prepareStatement("delete from " + this.dbActiveProfileDescriptor.getActiveProfileTableName() + " " + "where " + this.dbActiveProfileDescriptor.getFunctionIdFieldName() + "=? " + where);
            pstmt.setString(1, functionId);
            int i = 0;
            while (i < whereValues.size()) {
                pstmt.setObject(i + 2, whereValues.get(i));
                ++i;
            }
            pstmt.execute();
            conn.commit();
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllGridProfiles(String functionId) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            Hashtable h = this.dbProfileDescriptor.deleteAllGridProfiles(functionId);
            String where = " and ";
            Enumeration en = h.keys();
            String field = null;
            ArrayList whereValues = new ArrayList();
            while (en.hasMoreElements()) {
                field = en.nextElement().toString();
                where = where + field + "=? and ";
                whereValues.add(h.get(field));
            }
            where = where.length() > 5 ? where.substring(0, where.length() - 4) : "";
            pstmt = conn.prepareStatement("delete from " + this.dbProfileDescriptor.getProfileTableName() + " " + "where " + this.dbProfileDescriptor.getFunctionIdFieldName() + "=? " + where);
            pstmt.setString(1, functionId);
            int i = 0;
            while (i < whereValues.size()) {
                pstmt.setObject(i + 2, whereValues.get(i));
                ++i;
            }
            pstmt.execute();
            conn.commit();
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUserProfile(String functionId, Object id) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            String idFields = "";
            int i = 0;
            while (i < this.dbProfileDescriptor.getIdFieldNames().length) {
                idFields = idFields + this.dbProfileDescriptor.getIdFieldNames()[i] + "=? and ";
                ++i;
            }
            idFields = idFields.substring(0, idFields.length() - 4);
            Hashtable h = this.dbProfileDescriptor.deleteUserProfile(functionId, id);
            String where = " and ";
            Enumeration en = h.keys();
            String field = null;
            ArrayList whereValues = new ArrayList();
            while (en.hasMoreElements()) {
                field = en.nextElement().toString();
                where = where + field + "=? and ";
                whereValues.add(h.get(field));
            }
            where = where.length() > 5 ? where.substring(0, where.length() - 4) : "";
            pstmt = conn.prepareStatement("delete from " + this.dbProfileDescriptor.getProfileTableName() + " " + "where " + idFields + where);
            Object[] idValues = (Object[])id;
            int i2 = 0;
            while (i2 < idValues.length) {
                pstmt.setObject(i2 + 1, idValues[i2]);
                ++i2;
            }
            int i3 = 0;
            while (i3 < whereValues.size()) {
                pstmt.setObject(i3 + idValues.length + 1, whereValues.get(i3));
                ++i3;
            }
            int num = pstmt.executeUpdate();
            if (num == 0) {
                throw new IOException("Record not found: " + id);
            }
            conn.commit();
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridProfile getDefaultProfile(String functionId) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rset = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            String idFields = "";
            int i = 0;
            while (i < this.dbProfileDescriptor.getIdFieldNames().length) {
                idFields = idFields + this.dbProfileDescriptor.getIdFieldNames()[i] + ",";
                ++i;
            }
            pstmt = conn.prepareStatement("select " + this.dbProfileDescriptor.getColumnsAttributeFieldName() + "," + this.dbProfileDescriptor.getColumnsVisibilityFieldName() + "," + this.dbProfileDescriptor.getColumnsWidthFieldName() + "," + this.dbProfileDescriptor.getCurrentSortedColumnsFieldName() + "," + this.dbProfileDescriptor.getCurrentSortedVersusColumnsFieldName() + "," + this.dbProfileDescriptor.getDefaultProfileFieldName() + "," + this.dbProfileDescriptor.getDescriptionFieldName() + "," + this.dbProfileDescriptor.getFunctionIdFieldName() + "," + idFields + this.dbProfileDescriptor.getQuickFilterValuesFieldName() + "," + this.dbProfileDescriptor.getUsernameFieldName() + " " + "from " + this.dbProfileDescriptor.getProfileTableName() + " " + "where " + this.dbProfileDescriptor.getFunctionIdFieldName() + "=? " + "and " + this.dbProfileDescriptor.getUsernameFieldName() + "=? " + "and " + this.dbProfileDescriptor.getDefaultProfileFieldName() + "='Y'");
            pstmt.setString(1, functionId);
            pstmt.setString(2, this.getUsername());
            rset = pstmt.executeQuery();
            ArrayList profiles = new ArrayList();
            Object ids = null;
            Object profile = null;
            if (rset.next()) {
                GridProfile gridProfile = this.getUserProfileFromResultSet(rset);
                return gridProfile;
            }
            GridProfile gridProfile = null;
            return gridProfile;
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastGridDigest(String functionId) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rset = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            pstmt = conn.prepareStatement("select " + this.dbDigestDescriptor.getDigestFieldName() + " " + "from " + this.dbDigestDescriptor.getDigestTableName() + " " + "where " + this.dbDigestDescriptor.getFunctionIdFieldName() + "=? ");
            pstmt.setString(1, functionId);
            rset = pstmt.executeQuery();
            if (rset.next()) {
                String string = rset.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastGridProfileId(String functionId) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rset = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            String idFields = "";
            int i = 0;
            while (i < this.dbActiveProfileDescriptor.getIdFieldNames().length) {
                idFields = idFields + this.dbActiveProfileDescriptor.getIdFieldNames()[i] + ",";
                ++i;
            }
            idFields = idFields.substring(0, idFields.length() - 1);
            pstmt = conn.prepareStatement("select " + idFields + " " + "from " + this.dbActiveProfileDescriptor.getActiveProfileTableName() + " " + "where " + this.dbActiveProfileDescriptor.getFunctionIdFieldName() + "=? " + "and " + this.dbActiveProfileDescriptor.getUsernameFieldName() + "=? ");
            pstmt.setString(1, functionId);
            pstmt.setString(2, this.getUsername());
            rset = pstmt.executeQuery();
            if (rset.next()) {
                Object[] id = new Object[this.dbActiveProfileDescriptor.getIdFieldNames().length];
                int i2 = 0;
                while (i2 < id.length) {
                    id[i2] = rset.getObject(i2 + 1);
                    ++i2;
                }
                Object[] objectArray = id;
                return objectArray;
            }
            Object var7_8 = null;
            return var7_8;
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    public GridProfile getUserProfile(String functionId, Object id) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rset = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            String idFields = "";
            String idWhereFields = "";
            Object[] idWhereFieldValues = (Object[])id;
            int i = 0;
            while (i < this.dbProfileDescriptor.getIdFieldNames().length) {
                idFields = idFields + this.dbProfileDescriptor.getIdFieldNames()[i] + ",";
                idWhereFields = idWhereFields + this.dbProfileDescriptor.getIdFieldNames()[i] + "=? and ";
                ++i;
            }
            idWhereFields = idWhereFields.substring(0, idWhereFields.length() - 4);
            pstmt = conn.prepareStatement("select " + this.dbProfileDescriptor.getColumnsAttributeFieldName() + "," + this.dbProfileDescriptor.getColumnsVisibilityFieldName() + "," + this.dbProfileDescriptor.getColumnsWidthFieldName() + "," + this.dbProfileDescriptor.getCurrentSortedColumnsFieldName() + "," + this.dbProfileDescriptor.getCurrentSortedVersusColumnsFieldName() + "," + this.dbProfileDescriptor.getDefaultProfileFieldName() + "," + this.dbProfileDescriptor.getDescriptionFieldName() + "," + this.dbProfileDescriptor.getFunctionIdFieldName() + "," + idFields + this.dbProfileDescriptor.getQuickFilterValuesFieldName() + "," + this.dbProfileDescriptor.getUsernameFieldName() + " " + "from " + this.dbProfileDescriptor.getProfileTableName() + " " + "where " + this.dbProfileDescriptor.getFunctionIdFieldName() + "=? " + "and " + idWhereFields);
            pstmt.setString(1, functionId);
            int i2 = 0;
            while (i2 < idWhereFieldValues.length) {
                pstmt.setObject(i2 + 2, idWhereFieldValues[i2]);
                ++i2;
            }
            rset = pstmt.executeQuery();
            if (rset.next()) {
                GridProfile gridProfile = this.getUserProfileFromResultSet(rset);
                return gridProfile;
            }
            throw new IOException("Record not found: " + id);
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    private GridProfile getUserProfileFromResultSet(ResultSet rset) throws Throwable {
        String description = rset.getString(7);
        String functionId = rset.getString(8);
        String username = rset.getString(rset.getMetaData().getColumnCount());
        String aux = rset.getString(4);
        ArrayList<String> currentSortedColumns = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(aux, ",");
        while (st.hasMoreTokens()) {
            currentSortedColumns.add(st.nextToken());
        }
        aux = rset.getString(5);
        ArrayList<String> currentSortedVersusColumns = new ArrayList<String>();
        st = new StringTokenizer(aux, ",");
        while (st.hasMoreTokens()) {
            currentSortedVersusColumns.add(st.nextToken());
        }
        aux = rset.getString(1);
        st = new StringTokenizer(aux, ",");
        int cols = st.countTokens();
        String[] columnsAttribute = new String[cols];
        int i = 0;
        while (st.hasMoreTokens()) {
            columnsAttribute[i++] = st.nextToken();
        }
        aux = rset.getString(2);
        boolean[] columnsVisibility = new boolean[cols];
        st = new StringTokenizer(aux, ",");
        i = 0;
        while (st.hasMoreTokens()) {
            columnsVisibility[i++] = st.nextToken().toLowerCase().equals("true");
        }
        aux = rset.getString(3);
        int[] columnsWidth = new int[cols];
        st = new StringTokenizer(aux, ",");
        i = 0;
        while (st.hasMoreTokens()) {
            columnsWidth[i++] = Integer.parseInt(st.nextToken().trim());
        }
        aux = rset.getString(6);
        boolean defaultProfile = aux.equals("Y");
        Object[] id = new Object[rset.getMetaData().getColumnCount() - 10];
        i = 9;
        while (i <= rset.getMetaData().getColumnCount() - 2) {
            id[i - 9] = rset.getObject(i);
            ++i;
        }
        HashMap<String, FilterWhereClause[]> quickFilterValues = new HashMap<String, FilterWhereClause[]>();
        String attributeName = null;
        FilterWhereClause[] filter = new FilterWhereClause[2];
        String filters = rset.getString(rset.getMetaData().getColumnCount() - 1);
        StringTokenizer f = new StringTokenizer(filters, "\n");
        ArrayList<Object> values = null;
        String[] tokens = null;
        while (f.hasMoreTokens()) {
            int j;
            st = new StringTokenizer(f.nextToken(), ",");
            attributeName = st.nextToken();
            String operator1 = st.nextToken();
            String typevalue1 = st.nextToken();
            Object value1 = st.nextToken();
            tokens = value1.toString().split("\t");
            if (tokens.length == 1 && !operator1.equals("in")) {
                if (typevalue1.equals("D")) {
                    value1 = this.sdf.parse(value1.toString());
                } else if (typevalue1.equals("N")) {
                    value1 = new BigDecimal(value1.toString());
                }
            } else {
                values = new ArrayList<Object>();
                j = 0;
                while (j < tokens.length) {
                    if (typevalue1.equals("D")) {
                        values.add(this.sdf.parse(tokens[j]));
                    } else if (typevalue1.equals("N")) {
                        values.add(new BigDecimal(tokens[j]));
                    } else {
                        values.add(tokens[j]);
                    }
                    ++j;
                }
                value1 = values;
            }
            filter[0] = new FilterWhereClause(attributeName, operator1, value1);
            if (st.hasMoreTokens()) {
                String operator2 = st.nextToken();
                String typevalue2 = st.nextToken();
                Object value2 = st.nextToken();
                tokens = value2.toString().split("\t");
                if (tokens.length == 1 && !operator2.equals("in")) {
                    if (typevalue2.equals("D")) {
                        value1 = this.sdf.parse(value2.toString());
                    } else if (typevalue2.equals("N")) {
                        value1 = new BigDecimal(value2.toString());
                    }
                } else {
                    values = new ArrayList();
                    j = 0;
                    while (j < tokens.length) {
                        if (typevalue1.equals("D")) {
                            values.add(this.sdf.parse(tokens[j]));
                        } else if (typevalue1.equals("N")) {
                            values.add(new BigDecimal(tokens[j]));
                        } else {
                            values.add(tokens[j]);
                        }
                        ++j;
                    }
                    value2 = values;
                }
                filter[1] = new FilterWhereClause(attributeName, operator2, value2);
            } else {
                filter[1] = null;
            }
            quickFilterValues.put(attributeName, filter);
        }
        return new GridProfile(id, description, functionId, username, currentSortedColumns, currentSortedVersusColumns, quickFilterValues, columnsAttribute, columnsVisibility, columnsWidth, defaultProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUserProfiles(String functionId) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rset = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            String idFields = "";
            int i = 0;
            while (i < this.dbProfileDescriptor.getIdFieldNames().length) {
                idFields = idFields + this.dbProfileDescriptor.getIdFieldNames()[i] + ",";
                ++i;
            }
            pstmt = conn.prepareStatement("select " + idFields + this.dbProfileDescriptor.getDescriptionFieldName() + "," + this.dbProfileDescriptor.getDefaultProfileFieldName() + " " + "from " + this.dbProfileDescriptor.getProfileTableName() + " " + "where " + this.dbProfileDescriptor.getFunctionIdFieldName() + "=? " + "and " + this.dbProfileDescriptor.getUsernameFieldName() + "=? " + "order by " + this.dbProfileDescriptor.getDescriptionFieldName());
            pstmt.setString(1, functionId);
            pstmt.setString(2, this.getUsername());
            rset = pstmt.executeQuery();
            ArrayList<GridProfileDescription> profiles = new ArrayList<GridProfileDescription>();
            Object[] id = null;
            while (rset.next()) {
                id = new Object[rset.getMetaData().getColumnCount() - 2];
                int i2 = 0;
                while (i2 < id.length) {
                    id[i2] = rset.getObject(i2 + 1);
                    ++i2;
                }
                profiles.add(new GridProfileDescription(id, rset.getString(id.length + 1), rset.getString(id.length + 2).equals("Y")));
            }
            ArrayList<GridProfileDescription> arrayList = profiles;
            return arrayList;
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeGridDigest(String functionId, String gridDigest) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            Hashtable h1 = this.dbDigestDescriptor.storeGridDigestOnSetUpdate();
            Hashtable h2 = this.dbDigestDescriptor.storeGridDigestOnWhereUpdate();
            String where = " and ";
            Enumeration en = h2.keys();
            String field = null;
            ArrayList whereValues = new ArrayList();
            while (en.hasMoreElements()) {
                field = en.nextElement().toString();
                where = where + field + "=? and ";
                whereValues.add(h2.get(field));
            }
            where = where.length() > 5 ? where.substring(0, where.length() - 4) : "";
            String set = ",";
            en = h1.keys();
            field = null;
            ArrayList setValues = new ArrayList();
            while (en.hasMoreElements()) {
                field = en.nextElement().toString();
                set = set + field + "=?,";
                setValues.add(h1.get(field));
            }
            set = set.length() > 1 ? set.substring(0, set.length() - 1) : "";
            pstmt = conn.prepareStatement("update " + this.dbDigestDescriptor.getDigestTableName() + " " + "set " + this.dbDigestDescriptor.getDigestFieldName() + "=? " + set + " " + "where " + this.dbDigestDescriptor.getFunctionIdFieldName() + "=? " + where);
            pstmt.setString(1, gridDigest);
            pstmt.setString(2 + setValues.size(), functionId);
            int i = 0;
            while (i < setValues.size()) {
                pstmt.setObject(i + 2, setValues.get(i));
                ++i;
            }
            int i2 = 0;
            while (i2 < whereValues.size()) {
                pstmt.setObject(i2 + setValues.size() + 3, whereValues.get(i2));
                ++i2;
            }
            int num = pstmt.executeUpdate();
            if (num == 0) {
                Hashtable h = this.dbDigestDescriptor.storeGridDigestOnInsert();
                String ins = "";
                en = h.keys();
                field = null;
                String pkQuestions = "";
                ArrayList insValues = new ArrayList();
                while (en.hasMoreElements()) {
                    field = en.nextElement().toString();
                    pkQuestions = pkQuestions + "?,";
                    ins = ins + "," + field;
                    insValues.add(h.get(field));
                }
                pstmt = conn.prepareStatement("insert into " + this.dbDigestDescriptor.getDigestTableName() + "(" + this.dbDigestDescriptor.getDigestFieldName() + "," + this.dbDigestDescriptor.getFunctionIdFieldName() + ins + ") " + "values(" + pkQuestions + "?,?)");
                pstmt.setString(1, gridDigest);
                pstmt.setString(2, functionId);
                int i3 = 0;
                while (i3 < insValues.size()) {
                    pstmt.setObject(i3 + 3, insValues.get(i3));
                    ++i3;
                }
                pstmt.execute();
            }
            conn.commit();
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeGridProfileId(String functionId, Object id) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            String idFields = "";
            String idSetFields = "";
            String idQuestions = "";
            int i = 0;
            while (i < this.dbActiveProfileDescriptor.getIdFieldNames().length) {
                idFields = idFields + this.dbActiveProfileDescriptor.getIdFieldNames()[i] + ",";
                idSetFields = idSetFields + this.dbActiveProfileDescriptor.getIdFieldNames()[i] + "=?,";
                idQuestions = idQuestions + "?,";
                ++i;
            }
            idSetFields = idSetFields.substring(0, idSetFields.length() - 1);
            Hashtable h1 = this.dbActiveProfileDescriptor.storeGridProfileIdOnSetUpdate();
            Hashtable h2 = this.dbActiveProfileDescriptor.storeGridProfileIdOnWhereUpdate();
            String where = " and ";
            Enumeration en = h2.keys();
            String field = null;
            ArrayList whereValues = new ArrayList();
            while (en.hasMoreElements()) {
                field = en.nextElement().toString();
                where = where + field + "=? and ";
                whereValues.add(h2.get(field));
            }
            where = where.length() > 5 ? where.substring(0, where.length() - 4) : "";
            String set = ",";
            en = h1.keys();
            field = null;
            ArrayList setValues = new ArrayList();
            while (en.hasMoreElements()) {
                field = en.nextElement().toString();
                set = set + field + "=?,";
                setValues.add(h1.get(field));
            }
            set = set.length() > 1 ? set.substring(0, set.length() - 1) : "";
            pstmt = conn.prepareStatement("update " + this.dbActiveProfileDescriptor.getActiveProfileTableName() + " " + "set " + idSetFields + " " + set + " " + "where " + this.dbActiveProfileDescriptor.getFunctionIdFieldName() + "=? " + "and " + this.dbActiveProfileDescriptor.getUsernameFieldName() + "=? " + where);
            Object[] idValues = (Object[])id;
            int i2 = 0;
            while (i2 < idValues.length) {
                pstmt.setObject(i2 + 1, idValues[i2]);
                ++i2;
            }
            int i3 = 0;
            while (i3 < setValues.size()) {
                pstmt.setObject(i3 + idValues.length + 1, setValues.get(i3));
                ++i3;
            }
            pstmt.setString(idValues.length + 1 + setValues.size(), functionId);
            pstmt.setString(idValues.length + 2 + setValues.size(), this.getUsername());
            int i4 = 0;
            while (i4 < whereValues.size()) {
                pstmt.setObject(i4 + setValues.size() + idValues.length + 3, whereValues.get(i4));
                ++i4;
            }
            int num = pstmt.executeUpdate();
            if (num == 0) {
                Hashtable h = this.dbActiveProfileDescriptor.storeGridProfileIdOnInsert();
                String ins = "";
                en = h.keys();
                field = null;
                ArrayList insValues = new ArrayList();
                while (en.hasMoreElements()) {
                    field = en.nextElement().toString();
                    idQuestions = idQuestions + "?,";
                    ins = ins + "," + field;
                    insValues.add(h.get(field));
                }
                pstmt = conn.prepareStatement("insert into " + this.dbActiveProfileDescriptor.getActiveProfileTableName() + "(" + idFields + this.dbActiveProfileDescriptor.getFunctionIdFieldName() + "," + this.dbActiveProfileDescriptor.getUsernameFieldName() + ins + ") " + "values(" + idQuestions + "?,?)");
                int i5 = 0;
                while (i5 < idValues.length) {
                    pstmt.setObject(i5 + 1, idValues[i5]);
                    ++i5;
                }
                pstmt.setString(idValues.length + 1, functionId);
                pstmt.setString(idValues.length + 2, this.getUsername());
                int i6 = 0;
                while (i6 < insValues.size()) {
                    pstmt.setObject(i6 + idValues.length + 3, insValues.get(i6));
                    ++i6;
                }
                pstmt.execute();
            }
            conn.commit();
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }

    public Object storeUserProfile(GridProfile profile) throws Throwable {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rset = null;
        try {
            conn = this.dbConnectionSource.getConnection();
            if (profile.getId() == null || ((Object[])profile.getId())[0] == null) {
                profile.setId(this.dbProfileDescriptor.getNewIdFieldValues(conn, profile));
            }
            String idFields = "";
            String idSetFields = "";
            String idWhereFields = "";
            String pkQuestions = "";
            int i = 0;
            while (i < this.dbProfileDescriptor.getIdFieldNames().length) {
                idFields = idFields + this.dbProfileDescriptor.getIdFieldNames()[i] + ",";
                idSetFields = idSetFields + this.dbProfileDescriptor.getIdFieldNames()[i] + "=?,";
                idWhereFields = idWhereFields + this.dbProfileDescriptor.getIdFieldNames()[i] + "=? and ";
                pkQuestions = pkQuestions + "?,";
                ++i;
            }
            idWhereFields = idWhereFields.substring(0, idWhereFields.length() - 4);
            Object[] idValues = (Object[])profile.getId();
            String currentSortedColumns = "";
            int i2 = 0;
            while (i2 < profile.getCurrentSortedColumns().size()) {
                currentSortedColumns = currentSortedColumns + profile.getCurrentSortedColumns().get(i2) + ",";
                ++i2;
            }
            if (currentSortedColumns.length() > 0) {
                currentSortedColumns = currentSortedColumns.substring(0, currentSortedColumns.length() - 1);
            }
            String currentSortedVersusColumns = "";
            int i3 = 0;
            while (i3 < profile.getCurrentSortedVersusColumns().size()) {
                currentSortedVersusColumns = currentSortedVersusColumns + profile.getCurrentSortedVersusColumns().get(i3) + ",";
                ++i3;
            }
            if (currentSortedVersusColumns.length() > 0) {
                currentSortedVersusColumns = currentSortedVersusColumns.substring(0, currentSortedVersusColumns.length() - 1);
            }
            String columnsAttribute = "";
            int i4 = 0;
            while (i4 < profile.getColumnsAttribute().length) {
                columnsAttribute = columnsAttribute + profile.getColumnsAttribute()[i4] + ",";
                ++i4;
            }
            if (columnsAttribute.length() > 0) {
                columnsAttribute = columnsAttribute.substring(0, columnsAttribute.length() - 1);
            }
            String columnsVisibility = "";
            int i5 = 0;
            while (i5 < profile.getColumnsVisibility().length) {
                columnsVisibility = columnsVisibility + profile.getColumnsVisibility()[i5] + ",";
                ++i5;
            }
            if (columnsVisibility.length() > 0) {
                columnsVisibility = columnsVisibility.substring(0, columnsVisibility.length() - 1);
            }
            String columnsWidth = "";
            int i6 = 0;
            while (i6 < profile.getColumnsWidth().length) {
                columnsWidth = columnsWidth + profile.getColumnsWidth()[i6] + ",";
                ++i6;
            }
            if (columnsWidth.length() > 0) {
                columnsWidth = columnsWidth.substring(0, columnsWidth.length() - 1);
            }
            Iterator it = profile.getQuickFilterValues().keySet().iterator();
            String aux = "";
            FilterWhereClause[] filter = null;
            String attributeName = null;
            String filters = "";
            while (it.hasNext()) {
                int j;
                ArrayList values;
                attributeName = it.next().toString();
                filter = (FilterWhereClause[])profile.getQuickFilterValues().get(attributeName);
                aux = attributeName + "," + filter[0].getOperator() + ",";
                if (filter[0].getValue() != null) {
                    if (filter[0].getOperator().equals("in") || filter[0].getValue() instanceof ArrayList) {
                        values = (ArrayList)filter[0].getValue();
                        j = 0;
                        while (j < values.size()) {
                            aux = values.get(j) instanceof Date ? aux + "D," + this.sdf.format(values.get(j)) + "\t" : (filter[0].getValue() instanceof Number ? aux + "N," + values.get(j) + "\t" : aux + "T," + values.get(j) + "\t");
                            ++j;
                        }
                    } else {
                        aux = filter[0].getValue() instanceof Date ? aux + "D," + this.sdf.format(filter[0].getValue()) : (filter[0].getValue() instanceof Number ? aux + "N," + filter[0].getValue() : aux + "T," + filter[0].getValue());
                    }
                }
                if (filter[1] != null) {
                    aux = aux + "," + filter[1].getOperator() + ",";
                    if (filter[1].getValue() != null) {
                        if (filter[1].getOperator().equals("in") || filter[1].getValue() instanceof ArrayList) {
                            values = (ArrayList)filter[1].getValue();
                            j = 0;
                            while (j < values.size()) {
                                aux = values.get(j) instanceof Date ? aux + "D," + this.sdf.format(values.get(j)) + "\t" : (filter[1].getValue() instanceof Number ? aux + "N," + values.get(j) + "\t" : aux + "T," + values.get(j) + "\t");
                                ++j;
                            }
                        } else {
                            aux = filter[1].getValue() instanceof Date ? aux + "D," + this.sdf.format(filter[1].getValue()) : (filter[1].getValue() instanceof Number ? aux + "N," + filter[1].getValue() : aux + "T," + filter[1].getValue());
                        }
                    }
                }
                filters = filters + aux + "\n";
            }
            Hashtable h1 = this.dbProfileDescriptor.storeUserProfileOnSetUpdate();
            Hashtable h2 = this.dbProfileDescriptor.storeUserProfileOnWhereUpdate();
            String where = " and ";
            Enumeration en = h2.keys();
            String field = null;
            ArrayList whereValues = new ArrayList();
            while (en.hasMoreElements()) {
                field = en.nextElement().toString();
                where = where + field + "=? and ";
                whereValues.add(h2.get(field));
            }
            where = where.length() > 5 ? where.substring(0, where.length() - 4) : "";
            String set = ",";
            en = h1.keys();
            field = null;
            ArrayList setValues = new ArrayList();
            while (en.hasMoreElements()) {
                field = en.nextElement().toString();
                set = set + field + "=?,";
                setValues.add(h1.get(field));
            }
            set = set.length() > 1 ? set.substring(0, set.length() - 1) : "";
            pstmt = conn.prepareStatement("update " + this.dbProfileDescriptor.getProfileTableName() + " " + "set " + this.dbProfileDescriptor.getColumnsAttributeFieldName() + "=?," + this.dbProfileDescriptor.getColumnsVisibilityFieldName() + "=?," + this.dbProfileDescriptor.getColumnsWidthFieldName() + "=?," + this.dbProfileDescriptor.getCurrentSortedColumnsFieldName() + "=?," + this.dbProfileDescriptor.getCurrentSortedVersusColumnsFieldName() + "=?," + this.dbProfileDescriptor.getDefaultProfileFieldName() + "=?," + this.dbProfileDescriptor.getDescriptionFieldName() + "=?," + this.dbProfileDescriptor.getFunctionIdFieldName() + "=?," + idSetFields + this.dbProfileDescriptor.getQuickFilterValuesFieldName() + "=?," + this.dbProfileDescriptor.getUsernameFieldName() + "=? " + set + " " + "where " + idWhereFields + where);
            int len1 = 8 + idValues.length;
            int len2 = 8 + idValues.length + 2 + setValues.size();
            pstmt.setString(7, profile.getDescription());
            pstmt.setString(8, profile.getFunctionId());
            pstmt.setString(len1 + 2, profile.getUsername());
            int i7 = 0;
            while (i7 < idValues.length) {
                pstmt.setObject(i7 + 9, idValues[i7]);
                ++i7;
            }
            pstmt.setString(4, currentSortedColumns);
            pstmt.setString(5, currentSortedVersusColumns);
            pstmt.setString(1, columnsAttribute);
            pstmt.setString(2, columnsVisibility);
            pstmt.setString(3, columnsWidth);
            pstmt.setString(6, profile.isDefaultProfile() ? "Y" : "N");
            pstmt.setString(len1 + 1, filters);
            int i8 = 0;
            while (i8 < setValues.size()) {
                pstmt.setObject(i8 + len1 + 2, setValues.get(i8));
                ++i8;
            }
            int i9 = 0;
            while (i9 < idValues.length) {
                pstmt.setObject(i9 + len2 + 1, idValues[i9]);
                ++i9;
            }
            int i10 = 0;
            while (i10 < whereValues.size()) {
                pstmt.setObject(i10 + len2 + idValues.length + 1, whereValues.get(i10));
                ++i10;
            }
            int num = pstmt.executeUpdate();
            if (num == 0) {
                Hashtable h = this.dbProfileDescriptor.storeUserProfileOnInsert();
                String ins = "";
                en = h.keys();
                field = null;
                ArrayList insValues = new ArrayList();
                while (en.hasMoreElements()) {
                    field = en.nextElement().toString();
                    pkQuestions = pkQuestions + "?,";
                    ins = ins + "," + field;
                    insValues.add(h.get(field));
                }
                pstmt = conn.prepareStatement("insert into " + this.dbProfileDescriptor.getProfileTableName() + "(" + this.dbProfileDescriptor.getColumnsAttributeFieldName() + "," + this.dbProfileDescriptor.getColumnsVisibilityFieldName() + "," + this.dbProfileDescriptor.getColumnsWidthFieldName() + "," + this.dbProfileDescriptor.getCurrentSortedColumnsFieldName() + "," + this.dbProfileDescriptor.getCurrentSortedVersusColumnsFieldName() + "," + this.dbProfileDescriptor.getDefaultProfileFieldName() + "," + this.dbProfileDescriptor.getDescriptionFieldName() + "," + this.dbProfileDescriptor.getFunctionIdFieldName() + "," + idFields + this.dbProfileDescriptor.getQuickFilterValuesFieldName() + "," + this.dbProfileDescriptor.getUsernameFieldName() + ins + ") " + "values(" + pkQuestions + "?,?,?,?,?,?,?,?,?,?)");
                int i11 = 0;
                while (i11 < idValues.length) {
                    pstmt.setObject(i11 + 9, idValues[i11]);
                    ++i11;
                }
                pstmt.setString(7, profile.getDescription());
                pstmt.setString(8, profile.getFunctionId());
                pstmt.setString(8 + idValues.length + 2, profile.getUsername());
                pstmt.setString(4, currentSortedColumns);
                pstmt.setString(5, currentSortedVersusColumns);
                pstmt.setString(1, columnsAttribute);
                pstmt.setString(2, columnsVisibility);
                pstmt.setString(3, columnsWidth);
                pstmt.setString(6, profile.isDefaultProfile() ? "Y" : "N");
                pstmt.setString(8 + idValues.length + 1, filters);
                int i12 = 0;
                while (i12 < insValues.size()) {
                    pstmt.setObject(i12 + 8 + idValues.length + 3, insValues.get(i12));
                    ++i12;
                }
                pstmt.execute();
            }
            conn.commit();
            Object object = profile.getId();
            return object;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage());
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    this.dbConnectionSource.releaseConnection(conn);
                }
            }
            catch (Exception ex1) {
            }
        }
    }
}

