/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.util.server;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.EntityType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.send.java.FilterWhereClause;
import org.openswing.swing.server.QueryUtil;
import org.openswing.swing.server.UserSessionParameters;

public class HibernateUtils {
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Date;

    public static String applyFiltersAndSorter(Map decodedAttributes, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, String select, String from, String where, String group, String having, String order, ArrayList paramValues, ArrayList paramTypes, String tableName, SessionFactory sessions) throws Exception {
        ClassMetadata meta = sessions.getClassMetadata(valueObjectType);
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        HashMap attributesTypeMap = new HashMap();
        HashMap propDescriptors = new HashMap();
        if (meta != null) {
            HibernateUtils.fillInMetaData(sessions, tableName, "", meta, attributesMap, attributesTypeMap, "", new HashMap());
            attributesMap.put(meta.getIdentifierPropertyName(), tableName + "." + meta.getIdentifierPropertyName());
        } else {
            PropertyDescriptor[] p = Introspector.getBeanInfo(valueObjectType).getPropertyDescriptors();
            int i = 0;
            while (i < p.length) {
                propDescriptors.put(p[i].getName(), p[i].getPropertyType());
                ++i;
            }
        }
        attributesMap.putAll(decodedAttributes);
        ArrayList filterAttrNames = new ArrayList();
        String baseSQL = QueryUtil.getSql(new UserSessionParameters(), select, from, where, group, having, order, filterAttrNames, paramValues, filteredColumns, currentSortedColumns, currentSortedVersusColumns, attributesMap);
        FilterWhereClause[] whereC = null;
        int i = 0;
        while (i < filterAttrNames.size()) {
            whereC = (FilterWhereClause[])filteredColumns.get(filterAttrNames.get(i));
            if (whereC[0].getValue() != null && whereC[0].getValue() instanceof List) {
                int j = 0;
                while (j < ((List)whereC[0].getValue()).size()) {
                    paramTypes.add(HibernateUtils.getPropertyType(attributesTypeMap, meta, filterAttrNames.get(i).toString(), propDescriptors));
                    ++j;
                }
            } else {
                paramTypes.add(HibernateUtils.getPropertyType(attributesTypeMap, meta, filterAttrNames.get(i).toString(), propDescriptors));
            }
            ++i;
        }
        return baseSQL;
    }

    public static String applyFiltersAndSorter(Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, String select, String from, String where, String group, String having, String order, ArrayList paramValues, ArrayList paramTypes, String tableName, SessionFactory sessions) throws Exception {
        return HibernateUtils.applyFiltersAndSorter(new HashMap(), filteredColumns, currentSortedColumns, currentSortedVersusColumns, valueObjectType, select, from, where, group, having, order, paramValues, paramTypes, tableName, sessions);
    }

    public static String applyFiltersAndSorter(Map decodedAttributes, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, String baseSQL, ArrayList paramValues, ArrayList paramTypes, String tableName, SessionFactory sessions) throws Exception {
        ClassMetadata meta = sessions.getClassMetadata(valueObjectType);
        HashMap propDescriptors = new HashMap();
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        HashMap attributesTypeMap = new HashMap();
        if (meta != null) {
            HibernateUtils.fillInMetaData(sessions, tableName, "", meta, attributesMap, attributesTypeMap, "", new HashMap());
            attributesMap.put(meta.getIdentifierPropertyName(), tableName + "." + meta.getIdentifierPropertyName());
        } else {
            PropertyDescriptor[] p = Introspector.getBeanInfo(valueObjectType).getPropertyDescriptors();
            int i = 0;
            while (i < p.length) {
                propDescriptors.put(p[i].getName(), p[i].getPropertyType());
                ++i;
            }
        }
        attributesMap.putAll(decodedAttributes);
        ArrayList filterAttrNames = new ArrayList();
        baseSQL = QueryUtil.getSql(new UserSessionParameters(), baseSQL, filterAttrNames, paramValues, filteredColumns, currentSortedColumns, currentSortedVersusColumns, attributesMap);
        FilterWhereClause[] where = null;
        int i = 0;
        while (i < filterAttrNames.size()) {
            where = (FilterWhereClause[])filteredColumns.get(filterAttrNames.get(i));
            if (where[0].getValue() != null && where[0].getValue() instanceof List) {
                int j = 0;
                while (j < ((List)where[0].getValue()).size()) {
                    paramTypes.add(HibernateUtils.getPropertyType(attributesTypeMap, meta, filterAttrNames.get(i).toString(), propDescriptors));
                    ++j;
                }
            } else {
                paramTypes.add(HibernateUtils.getPropertyType(attributesTypeMap, meta, filterAttrNames.get(i).toString(), propDescriptors));
            }
            ++i;
        }
        return baseSQL;
    }

    public static String applyFiltersAndSorter(Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, String baseSQL, ArrayList paramValues, ArrayList paramTypes, String tableName, SessionFactory sessions) throws Exception {
        return HibernateUtils.applyFiltersAndSorter(new HashMap(), filteredColumns, currentSortedColumns, currentSortedVersusColumns, valueObjectType, baseSQL, paramValues, paramTypes, tableName, sessions);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static void fillInMetaData(SessionFactory sessions, String tableName, String prefix, ClassMetadata meta, Map attributesMap, Map attributesTypeMap, String lastAttrName, HashMap entitiesAlreadyAnalyzed) {
        if (meta != null) {
            ClassMetadata submeta;
            Integer num = (Integer)entitiesAlreadyAnalyzed.get(meta.getEntityName());
            if (num == null) {
                num = new Integer(1);
                entitiesAlreadyAnalyzed.put(meta.getEntityName(), num);
            } else {
                entitiesAlreadyAnalyzed.put(meta.getEntityName(), new Integer(num + 1));
            }
            if (num > 10) {
                return;
            }
            String[] attrNames = meta.getPropertyNames();
            int i = 0;
            while (i < attrNames.length) {
                attributesMap.put(prefix + attrNames[i], tableName + "." + attrNames[i]);
                attributesTypeMap.put(prefix + attrNames[i], meta.getPropertyType(attrNames[i]));
                if (meta.getPropertyType(attrNames[i]) instanceof EntityType && !lastAttrName.equals(meta.getEntityName() + "." + attrNames[i])) {
                    submeta = sessions.getClassMetadata(((EntityType)meta.getPropertyType(attrNames[i])).getReturnedClass());
                    HibernateUtils.fillInMetaData(sessions, tableName + "." + attrNames[i], prefix + attrNames[i] + ".", submeta, attributesMap, attributesTypeMap, meta.getEntityName() + "." + attrNames[i], entitiesAlreadyAnalyzed);
                }
                ++i;
            }
            attributesMap.put(prefix + meta.getIdentifierPropertyName(), tableName + "." + meta.getIdentifierPropertyName());
            attributesTypeMap.put(prefix + meta.getIdentifierPropertyName(), meta.getPropertyType(meta.getIdentifierPropertyName()));
            if (meta.getPropertyType(meta.getIdentifierPropertyName()) instanceof EntityType && !lastAttrName.equals(meta.getEntityName() + "." + meta.getIdentifierPropertyName())) {
                submeta = sessions.getClassMetadata(((EntityType)meta.getPropertyType(meta.getIdentifierPropertyName())).getReturnedClass());
                HibernateUtils.fillInMetaData(sessions, ((EntityType)meta.getPropertyType(meta.getIdentifierPropertyName())).getReturnedClass().getName(), prefix + prefix + meta.getIdentifierPropertyName() + ".", submeta, attributesMap, attributesTypeMap, meta.getEntityName() + "." + meta.getIdentifierPropertyName(), new HashMap());
            }
        }
    }

    public static Response getAllFromClass(Class valueObjectClass, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, FetchMode fetchMode, Session sess) throws Exception {
        Criteria criteria = sess.createCriteria(valueObjectClass).setFetchMode("permissions", fetchMode);
        return HibernateUtils.getAllFromCriteria(filteredColumns, currentSortedColumns, currentSortedVersusColumns, criteria, sess);
    }

    public static Response getAllFromCriteria(Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Criteria criteria, Session sess) throws Exception {
        int rowCount;
        Iterator keys = filteredColumns.keySet().iterator();
        String attributeName = null;
        FilterWhereClause[] filterClauses = null;
        while (keys.hasNext()) {
            ArrayList inValues;
            attributeName = keys.next().toString();
            filterClauses = (FilterWhereClause[])filteredColumns.get(attributeName);
            if (filterClauses[0].getValue() != null && !filterClauses[0].getOperator().equals("is not null") && !filterClauses[0].getOperator().equals("is null")) {
                if (filterClauses[0].getValue() instanceof ArrayList) {
                    inValues = (ArrayList)filterClauses[0].getValue();
                    criteria = criteria.add(Restrictions.in((String)attributeName, (Collection)inValues));
                } else if (filterClauses[0].getOperator().equals("=")) {
                    criteria = criteria.add((Criterion)Restrictions.eq((String)attributeName, (Object)filterClauses[0].getValue()));
                } else if (filterClauses[0].getOperator().equals("<>")) {
                    criteria = criteria.add((Criterion)Restrictions.ne((String)attributeName, (Object)filterClauses[0].getValue()));
                } else if (filterClauses[0].getOperator().equals("<=")) {
                    criteria = criteria.add((Criterion)Restrictions.le((String)attributeName, (Object)filterClauses[0].getValue()));
                } else if (filterClauses[0].getOperator().equals("<")) {
                    criteria = criteria.add((Criterion)Restrictions.lt((String)attributeName, (Object)filterClauses[0].getValue()));
                } else if (filterClauses[0].getOperator().equals(">=")) {
                    criteria = criteria.add((Criterion)Restrictions.ge((String)attributeName, (Object)filterClauses[0].getValue()));
                } else if (filterClauses[0].getOperator().equals(">")) {
                    criteria = criteria.add((Criterion)Restrictions.gt((String)attributeName, (Object)filterClauses[0].getValue()));
                } else if (filterClauses[0].getOperator().equals("like")) {
                    criteria = criteria.add((Criterion)Restrictions.like((String)attributeName, (Object)filterClauses[0].getValue()));
                }
            } else if (filterClauses[0].getOperator().equals("is null")) {
                criteria = criteria.add(Restrictions.isNull((String)attributeName));
            } else if (filterClauses[0].getOperator().equals("is not null")) {
                criteria = criteria.add(Restrictions.isNotNull((String)attributeName));
            }
            if (filterClauses[1] == null) continue;
            if (filterClauses[1].getValue() != null && !filterClauses[1].getOperator().equals("is not null") && !filterClauses[1].getOperator().equals("is null")) {
                if (filterClauses[1].getValue() instanceof ArrayList) {
                    inValues = (ArrayList)filterClauses[1].getValue();
                    criteria = criteria.add(Restrictions.in((String)attributeName, (Collection)inValues));
                    continue;
                }
                if (filterClauses[1].getOperator().equals("=")) {
                    criteria = criteria.add((Criterion)Restrictions.eq((String)attributeName, (Object)filterClauses[1].getValue()));
                    continue;
                }
                if (filterClauses[1].getOperator().equals("<>")) {
                    criteria = criteria.add((Criterion)Restrictions.ne((String)attributeName, (Object)filterClauses[1].getValue()));
                    continue;
                }
                if (filterClauses[1].getOperator().equals("<=")) {
                    criteria = criteria.add((Criterion)Restrictions.le((String)attributeName, (Object)filterClauses[1].getValue()));
                    continue;
                }
                if (filterClauses[1].getOperator().equals("<")) {
                    criteria = criteria.add((Criterion)Restrictions.lt((String)attributeName, (Object)filterClauses[1].getValue()));
                    continue;
                }
                if (filterClauses[1].getOperator().equals(">=")) {
                    criteria = criteria.add((Criterion)Restrictions.ge((String)attributeName, (Object)filterClauses[1].getValue()));
                    continue;
                }
                if (filterClauses[1].getOperator().equals(">")) {
                    criteria = criteria.add((Criterion)Restrictions.gt((String)attributeName, (Object)filterClauses[1].getValue()));
                    continue;
                }
                if (!filterClauses[1].getOperator().equals("like")) continue;
                criteria = criteria.add((Criterion)Restrictions.like((String)attributeName, (Object)filterClauses[1].getValue()));
                continue;
            }
            if (filterClauses[1].getOperator().equals("is null")) {
                criteria = criteria.add(Restrictions.isNull((String)attributeName));
                continue;
            }
            if (!filterClauses[1].getOperator().equals("is not null")) continue;
            criteria = criteria.add(Restrictions.isNotNull((String)attributeName));
        }
        int i = 0;
        while (i < currentSortedColumns.size()) {
            criteria = currentSortedVersusColumns.get(i).equals("ASC") ? criteria.addOrder(Order.asc((String)currentSortedColumns.get(i).toString())) : criteria.addOrder(Order.desc((String)currentSortedColumns.get(i).toString()));
            ++i;
        }
        ArrayList gridList = new ArrayList();
        boolean moreRows = false;
        List list = criteria.list();
        int resultSetLength = rowCount = list.size();
        gridList.addAll(list);
        return new VOListResponse(gridList, moreRows, resultSetLength);
    }

    public static Response getAllFromQuery(Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, String select, String from, String where, String group, String having, String order, Object[] paramValues, Type[] paramTypes, String tableName, SessionFactory sessions, Session sess) throws Exception {
        return HibernateUtils.getAllFromQuery(new HashMap(), filteredColumns, currentSortedColumns, currentSortedVersusColumns, valueObjectType, select, from, where, group, having, order, paramValues, paramTypes, tableName, sessions, sess);
    }

    public static Response getAllFromQuery(Map decodedAttributes, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, String select, String from, String where, String group, String having, String order, Object[] paramValues, Type[] paramTypes, String tableName, SessionFactory sessions, Session sess) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(Arrays.asList(paramValues));
        ArrayList<Type> types = new ArrayList<Type>();
        types.addAll(Arrays.asList(paramTypes));
        String baseSQL = HibernateUtils.applyFiltersAndSorter(decodedAttributes, filteredColumns, currentSortedColumns, currentSortedVersusColumns, valueObjectType, select, from, where, group, having, order, values, types, tableName, sessions);
        ArrayList gridList = new ArrayList();
        boolean moreRows = false;
        int resultSetLength = -1;
        List list = sess.createQuery(baseSQL).setParameters(values.toArray(), types.toArray(new Type[types.size()])).list();
        gridList.addAll(list);
        resultSetLength = gridList.size();
        return new VOListResponse(gridList, moreRows, resultSetLength);
    }

    public static Response getAllFromQuery(Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, String baseSQL, Object[] paramValues, Type[] paramTypes, String tableName, SessionFactory sessions, Session sess) throws Exception {
        return HibernateUtils.getAllFromQuery(new HashMap(), filteredColumns, currentSortedColumns, currentSortedVersusColumns, valueObjectType, baseSQL, paramValues, paramTypes, tableName, sessions, sess);
    }

    public static Response getAllFromQuery(Map decodedAttributes, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, String baseSQL, Object[] paramValues, Type[] paramTypes, String tableName, SessionFactory sessions, Session sess) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(Arrays.asList(paramValues));
        ArrayList<Type> types = new ArrayList<Type>();
        types.addAll(Arrays.asList(paramTypes));
        baseSQL = HibernateUtils.applyFiltersAndSorter(decodedAttributes, filteredColumns, currentSortedColumns, currentSortedVersusColumns, valueObjectType, baseSQL, values, types, tableName, sessions);
        ArrayList gridList = new ArrayList();
        boolean moreRows = false;
        int resultSetLength = -1;
        List list = sess.createQuery(baseSQL).setParameters(values.toArray(), types.toArray(new Type[types.size()])).list();
        gridList.addAll(list);
        resultSetLength = gridList.size();
        return new VOListResponse(gridList, moreRows, resultSetLength);
    }

    public static Response getBlockFromClass(Class valueObjectClass, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, int action, int startIndex, int blockSize, FetchMode fetchMode, Session sess) throws Exception {
        Criteria criteria = sess.createCriteria(valueObjectClass).setFetchMode("permissions", fetchMode);
        return HibernateUtils.getBlockFromCriteria(filteredColumns, currentSortedColumns, currentSortedVersusColumns, action, startIndex, blockSize, criteria, sess);
    }

    public static Response getBlockFromCriteria(Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, int action, int startIndex, int blockSize, Criteria criteria, Session sess) throws Exception {
        Iterator keys = filteredColumns.keySet().iterator();
        String attributeName = null;
        FilterWhereClause[] filterClauses = null;
        while (keys.hasNext()) {
            ArrayList inValues;
            attributeName = keys.next().toString();
            filterClauses = (FilterWhereClause[])filteredColumns.get(attributeName);
            if (filterClauses[0].getValue() != null && !filterClauses[0].getOperator().equals("is not null") && !filterClauses[0].getOperator().equals("is null")) {
                if (filterClauses[0].getValue() instanceof ArrayList) {
                    inValues = (ArrayList)filterClauses[0].getValue();
                    criteria = criteria.add(Restrictions.in((String)attributeName, (Collection)inValues));
                } else if (filterClauses[0].getOperator().equals("=")) {
                    criteria = criteria.add((Criterion)Restrictions.eq((String)attributeName, (Object)filterClauses[0].getValue()));
                } else if (filterClauses[0].getOperator().equals("<>")) {
                    criteria = criteria.add((Criterion)Restrictions.ne((String)attributeName, (Object)filterClauses[0].getValue()));
                } else if (filterClauses[0].getOperator().equals("<=")) {
                    criteria = criteria.add((Criterion)Restrictions.le((String)attributeName, (Object)filterClauses[0].getValue()));
                } else if (filterClauses[0].getOperator().equals("<")) {
                    criteria = criteria.add((Criterion)Restrictions.lt((String)attributeName, (Object)filterClauses[0].getValue()));
                } else if (filterClauses[0].getOperator().equals(">=")) {
                    criteria = criteria.add((Criterion)Restrictions.ge((String)attributeName, (Object)filterClauses[0].getValue()));
                } else if (filterClauses[0].getOperator().equals(">")) {
                    criteria = criteria.add((Criterion)Restrictions.gt((String)attributeName, (Object)filterClauses[0].getValue()));
                } else if (filterClauses[0].getOperator().equals("like")) {
                    criteria = criteria.add((Criterion)Restrictions.like((String)attributeName, (Object)filterClauses[0].getValue()));
                }
            } else if (filterClauses[0].getOperator().equals("is null")) {
                criteria = criteria.add(Restrictions.isNull((String)attributeName));
            } else if (filterClauses[0].getOperator().equals("is not null")) {
                criteria = criteria.add(Restrictions.isNotNull((String)attributeName));
            }
            if (filterClauses[1] == null) continue;
            if (filterClauses[1].getValue() != null && !filterClauses[1].getOperator().equals("is not null") && !filterClauses[1].getOperator().equals("is null")) {
                if (filterClauses[1].getValue() instanceof ArrayList) {
                    inValues = (ArrayList)filterClauses[1].getValue();
                    criteria = criteria.add(Restrictions.in((String)attributeName, (Collection)inValues));
                    continue;
                }
                if (filterClauses[1].getOperator().equals("=")) {
                    criteria = criteria.add((Criterion)Restrictions.eq((String)attributeName, (Object)filterClauses[1].getValue()));
                    continue;
                }
                if (filterClauses[1].getOperator().equals("<>")) {
                    criteria = criteria.add((Criterion)Restrictions.ne((String)attributeName, (Object)filterClauses[1].getValue()));
                    continue;
                }
                if (filterClauses[1].getOperator().equals("<=")) {
                    criteria = criteria.add((Criterion)Restrictions.le((String)attributeName, (Object)filterClauses[1].getValue()));
                    continue;
                }
                if (filterClauses[1].getOperator().equals("<")) {
                    criteria = criteria.add((Criterion)Restrictions.lt((String)attributeName, (Object)filterClauses[1].getValue()));
                    continue;
                }
                if (filterClauses[1].getOperator().equals(">=")) {
                    criteria = criteria.add((Criterion)Restrictions.ge((String)attributeName, (Object)filterClauses[1].getValue()));
                    continue;
                }
                if (filterClauses[1].getOperator().equals(">")) {
                    criteria = criteria.add((Criterion)Restrictions.gt((String)attributeName, (Object)filterClauses[1].getValue()));
                    continue;
                }
                if (!filterClauses[1].getOperator().equals("like")) continue;
                criteria = criteria.add((Criterion)Restrictions.like((String)attributeName, (Object)filterClauses[1].getValue()));
                continue;
            }
            if (filterClauses[1].getOperator().equals("is null")) {
                criteria = criteria.add(Restrictions.isNull((String)attributeName));
                continue;
            }
            if (!filterClauses[1].getOperator().equals("is not null")) continue;
            criteria = criteria.add(Restrictions.isNotNull((String)attributeName));
        }
        int i = 0;
        while (i < currentSortedColumns.size()) {
            criteria = currentSortedVersusColumns.get(i).equals("ASC") ? criteria.addOrder(Order.asc((String)currentSortedColumns.get(i).toString())) : criteria.addOrder(Order.desc((String)currentSortedColumns.get(i).toString()));
            ++i;
        }
        ArrayList gridList = new ArrayList();
        boolean moreRows = false;
        int resultSetLength = -1;
        int rowCount = 0;
        ArrayList list = null;
        if (action == 2) {
            List tmp = criteria.list();
            resultSetLength = rowCount = tmp.size();
            action = 1;
            startIndex = Math.max(rowCount - blockSize, 0);
            rowCount = 0;
            list = new ArrayList();
            int i2 = startIndex;
            while (i2 < startIndex + blockSize) {
                list.add(tmp.get(i2));
                ++i2;
            }
        } else {
            if (action == 0) {
                action = 1;
                startIndex = Math.max(startIndex - blockSize, 0);
            }
            criteria.setFirstResult(startIndex);
            criteria.setMaxResults(blockSize + 1);
            list = criteria.list();
        }
        gridList.addAll(list);
        if (gridList.size() > blockSize) {
            gridList.remove(gridList.size() - 1);
            moreRows = true;
        }
        if (resultSetLength == -1) {
            resultSetLength = gridList.size();
        }
        return new VOListResponse(gridList, moreRows, resultSetLength);
    }

    public static Response getBlockFromQuery(Class valueObjectClass, int action, int startIndex, int blockSize, Query query, Session sess) throws Exception {
        ArrayList gridList = new ArrayList();
        boolean moreRows = false;
        int resultSetLength = -1;
        int rowCount = 0;
        if (action == 2) {
            Iterator it = query.iterate();
            while (it.hasNext()) {
                ++rowCount;
                it.next();
            }
            resultSetLength = rowCount;
            action = 1;
            startIndex = Math.max(rowCount - blockSize, 0);
            rowCount = 0;
            query.setFirstResult(startIndex);
            query.setMaxResults(blockSize);
        } else {
            if (action == 0) {
                action = 1;
                startIndex = Math.max(startIndex - blockSize, 0);
            }
            query.setFirstResult(startIndex);
            query.setMaxResults(blockSize + 1);
        }
        List list = query.list();
        gridList.addAll(list);
        if (gridList.size() > blockSize) {
            gridList.remove(gridList.size() - 1);
            moreRows = true;
        }
        if (resultSetLength == -1) {
            resultSetLength = gridList.size();
        }
        if (gridList.size() > 0 && gridList.get(0) instanceof Object[]) {
            return QueryUtil.getQuery(query.getReturnAliases(), valueObjectClass, gridList, moreRows);
        }
        return new VOListResponse(gridList, moreRows, resultSetLength);
    }

    public static Response getBlockFromQuery(int action, int startIndex, int blockSize, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, String select, String from, String where, String group, String having, String order, Object[] paramValues, Type[] paramTypes, String tableName, SessionFactory sessions, Session sess) throws Exception {
        return HibernateUtils.getBlockFromQuery(new HashMap(), action, startIndex, blockSize, filteredColumns, currentSortedColumns, currentSortedVersusColumns, valueObjectType, select, from, where, group, having, order, paramValues, paramTypes, tableName, sessions, sess);
    }

    public static Response getBlockFromQuery(Map decodedAttributes, int action, int startIndex, int blockSize, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, String select, String from, String where, String group, String having, String order, Object[] paramValues, Type[] paramTypes, String tableName, SessionFactory sessions, Session sess) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(Arrays.asList(paramValues));
        ArrayList<Type> types = new ArrayList<Type>();
        types.addAll(Arrays.asList(paramTypes));
        String baseSQL = HibernateUtils.applyFiltersAndSorter(decodedAttributes, filteredColumns, currentSortedColumns, currentSortedVersusColumns, valueObjectType, select, from, where, group, having, order, values, types, tableName, sessions);
        return HibernateUtils.getBlockFromQuery(valueObjectType, action, startIndex, blockSize, sess.createQuery(baseSQL).setParameters(values.toArray(), types.toArray(new Type[types.size()])), sess);
    }

    public static Response getBlockFromQuery(Map decodedAttributes, int action, int startIndex, int blockSize, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, String baseSQL, Object[] paramValues, Type[] paramTypes, String tableName, SessionFactory sessions, Session sess) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(Arrays.asList(paramValues));
        ArrayList<Type> types = new ArrayList<Type>();
        types.addAll(Arrays.asList(paramTypes));
        baseSQL = HibernateUtils.applyFiltersAndSorter(decodedAttributes, filteredColumns, currentSortedColumns, currentSortedVersusColumns, valueObjectType, baseSQL, values, types, tableName, sessions);
        return HibernateUtils.getBlockFromQuery(valueObjectType, action, startIndex, blockSize, sess.createQuery(baseSQL).setParameters(values.toArray(), types.toArray(new Type[types.size()])), sess);
    }

    public static Response getBlockFromQuery(int action, int startIndex, int blockSize, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, String baseSQL, Object[] paramValues, Type[] paramTypes, String tableName, SessionFactory sessions, Session sess) throws Exception {
        return HibernateUtils.getBlockFromQuery(new HashMap(), action, startIndex, blockSize, filteredColumns, currentSortedColumns, currentSortedVersusColumns, valueObjectType, baseSQL, paramValues, paramTypes, tableName, sessions, sess);
    }

    private static Type getPropertyType(Map attributesTypeMap, ClassMetadata meta, String attrName, Map propDescriptors) {
        Type type;
        if (attributesTypeMap != null && (type = (Type)attributesTypeMap.get(attrName)) != null) {
            return type;
        }
        if (meta != null) {
            return meta.getPropertyType(attrName);
        }
        Class clazz = (Class)propDescriptors.get(attrName);
        if (clazz == null) {
            return new StringType();
        }
        if (clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = HibernateUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return new BigDecimalType();
        }
        if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = HibernateUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new DoubleType();
        }
        if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = HibernateUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new LongType();
        }
        if (clazz.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = HibernateUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return new BigIntegerType();
        }
        if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = HibernateUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new IntegerType();
        }
        if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = HibernateUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new FloatType();
        }
        if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = HibernateUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new ShortType();
        }
        if (clazz.equals(class$java$util$Date == null ? (class$java$util$Date = HibernateUtils.class$("java.util.Date")) : class$java$util$Date)) {
            return new DateType();
        }
        if (clazz.equals(class$java$sql$Date == null ? (class$java$sql$Date = HibernateUtils.class$("java.sql.Date")) : class$java$sql$Date)) {
            return new DateType();
        }
        if (clazz.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = HibernateUtils.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return new TimestampType();
        }
        return new StringType();
    }
}

