/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.painter.highlight.SubstanceHighlightUtils;
import org.jvnet.substance.painter.utils.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;

public class SubstanceMenuBackgroundDelegate {
    private SubstanceFillBackgroundDelegate fillBackgroundDelegate;

    public SubstanceMenuBackgroundDelegate(float fillAlpha) {
        this.fillBackgroundDelegate = new SubstanceFillBackgroundDelegate(fillAlpha);
    }

    public void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor, float borderAlpha, int textOffset) {
        if (!menuItem.isShowing()) {
            return;
        }
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        Graphics2D graphics = (Graphics2D)g.create();
        this.fillBackgroundDelegate.setWatermarkAlpha(0.4f);
        for (Container comp = menuItem.getParent(); comp != null && !(comp instanceof JMenuItem); comp = comp.getParent()) {
            if (!(comp instanceof JMenuBar)) continue;
            this.fillBackgroundDelegate.setWatermarkAlpha(1.0f);
            break;
        }
        this.fillBackgroundDelegate.update(graphics, menuItem, false);
        if (menuItem.getParent() instanceof JPopupMenu) {
            if (menuItem.getComponentOrientation().isLeftToRight()) {
                SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(menuItem, ComponentState.DEFAULT);
                    Color leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getUltraLightColor() : scheme.getLightColor();
                    Color rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getUltraLightColor() : scheme.getLightColor();
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, leftColor, textOffset, 0.0f, rightColor);
                    graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, 0.7f, g));
                    graphics.setPaint(gp);
                    graphics.fillRect(0, 0, textOffset - 2, menuHeight);
                }
            } else {
                SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(menuItem, ComponentState.DEFAULT);
                    Color leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getLightColor() : scheme.getUltraLightColor();
                    Color rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getLightColor() : scheme.getUltraLightColor();
                    GradientPaint gp = new GradientPaint(textOffset, 0.0f, leftColor, menuWidth, 0.0f, rightColor);
                    graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, 0.7f, g));
                    graphics.setPaint(gp);
                    graphics.fillRect(textOffset - 2, 0, menuWidth, menuHeight);
                }
            }
        }
        graphics.dispose();
    }

    public static void paintHighlights(Graphics g, JMenuItem menuItem, float borderAlpha) {
        boolean hasHighlight;
        MenuElement[] selectedMenuPath;
        Graphics2D graphics = (Graphics2D)g.create();
        ButtonModel model = menuItem.getModel();
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(menuItem);
        ComponentState currState = ComponentState.getState(model, menuItem, !(menuItem instanceof JMenu));
        float startAlpha = SubstanceColorSchemeUtilities.getHighlightAlpha(menuItem, prevState);
        float endAlpha = SubstanceColorSchemeUtilities.getHighlightAlpha(menuItem, currState);
        SubstanceColorScheme prevScheme = SubstanceColorSchemeUtilities.getHighlightColorScheme(menuItem, prevState);
        SubstanceColorScheme currScheme = SubstanceColorSchemeUtilities.getHighlightColorScheme(menuItem, currState);
        FadeState state = SubstanceFadeUtilities.getFadeState((Component)menuItem, FadeKind.SELECTION, FadeKind.ARM, FadeKind.ROLLOVER);
        float fadeCoef = 0.0f;
        float totalAlpha = endAlpha;
        if (state != null) {
            fadeCoef = state.getFadePosition();
            totalAlpha = state.isFadingIn() ? startAlpha + (endAlpha - startAlpha) * fadeCoef : startAlpha + (endAlpha - startAlpha) * (1.0f - fadeCoef);
            if (state.isFadingIn()) {
                fadeCoef = 1.0f - fadeCoef;
            }
        }
        boolean isRollover = (selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()).length == 0;
        for (MenuElement elem : selectedMenuPath) {
            if (elem != menuItem) continue;
            isRollover = true;
            break;
        }
        isRollover = isRollover && model.isRollover();
        boolean bl = hasHighlight = state != null || model.isArmed() || isRollover || menuItem instanceof JMenu && model.isSelected();
        if (hasHighlight && totalAlpha > 0.0f) {
            graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, totalAlpha, g));
            SubstanceHighlightUtils.paintHighlight(graphics, menuItem, new Rectangle(0, 0, menuItem.getWidth(), menuItem.getHeight()), borderAlpha, null, currScheme, prevScheme, fadeCoef);
            graphics.setComposite(TransitionLayout.getAlphaComposite((Component)menuItem, g));
        }
        graphics.dispose();
    }
}

