/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api;

import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.api.SubstanceApi;

@SubstanceApi
public enum ComponentState {
    DISABLED_ACTIVE(ColorSchemeKind.DISABLED, 0.0f, new FadeKind[0]),
    ACTIVE(ColorSchemeKind.CURRENT, 0.0f, FadeKind.ENABLE),
    DISABLED_SELECTED(ColorSchemeKind.DISABLED, 1.0f, FadeKind.SELECTION),
    DISABLED_UNSELECTED(ColorSchemeKind.DISABLED, 0.0f, new FadeKind[0]),
    PRESSED_SELECTED(ColorSchemeKind.CURRENT, 0.5f, FadeKind.ENABLE, FadeKind.SELECTION, FadeKind.PRESS),
    PRESSED_UNSELECTED(ColorSchemeKind.CURRENT, 0.8f, FadeKind.ENABLE, FadeKind.PRESS),
    SELECTED(ColorSchemeKind.CURRENT, 0.8f, FadeKind.ENABLE, FadeKind.SELECTION),
    ROLLOVER_SELECTED(ColorSchemeKind.CURRENT, 0.4f, FadeKind.ENABLE, FadeKind.ROLLOVER, FadeKind.SELECTION),
    ARMED(ColorSchemeKind.CURRENT, 0.5f, FadeKind.ENABLE, FadeKind.ARM),
    ROLLOVER_ARMED(ColorSchemeKind.CURRENT, 0.7f, FadeKind.ENABLE, FadeKind.ROLLOVER, FadeKind.ARM),
    ROLLOVER_UNSELECTED(ColorSchemeKind.CURRENT, 0.3f, FadeKind.ENABLE, FadeKind.ROLLOVER),
    DEFAULT(ColorSchemeKind.REGULAR, 0.0f, FadeKind.ENABLE);

    private ColorSchemeKind colorSchemeKind;
    private float cyclePos;
    private FadeKind[] activeKinds;

    private ComponentState(ColorSchemeKind kind, float cyclePos, FadeKind ... activeKinds) {
        this.colorSchemeKind = kind;
        this.cyclePos = cyclePos;
        this.activeKinds = activeKinds;
    }

    public ColorSchemeKind getColorSchemeKind() {
        return this.colorSchemeKind;
    }

    public float getCyclePosition() {
        return this.cyclePos;
    }

    public boolean isKindActive(FadeKind fadeKind) {
        if (this.activeKinds == null) {
            return false;
        }
        for (FadeKind fk : this.activeKinds) {
            if (fadeKind != fk) continue;
            return true;
        }
        return false;
    }

    public static ComponentState[] getActiveStates() {
        LinkedList<ComponentState> states = new LinkedList<ComponentState>();
        for (ComponentState state : ComponentState.values()) {
            if (state == DEFAULT || !state.isKindActive(FadeKind.ENABLE)) continue;
            states.add(state);
        }
        return states.toArray(new ComponentState[0]);
    }

    public static ComponentState getState(ButtonModel model, JComponent component) {
        return ComponentState.getState(model, component, false);
    }

    public static ComponentState getState(AbstractButton button) {
        return ComponentState.getState(button.getModel(), button, false);
    }

    public static ComponentState getState(ButtonModel model, JComponent component, boolean toIgnoreSelection) {
        JButton jb;
        boolean isRollover = model.isRollover();
        if (component instanceof MenuElement) {
            MenuElement[] selectedMenuPath;
            for (MenuElement elem : selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()) {
                if (elem != component) continue;
                isRollover = true;
                break;
            }
        }
        if (component != null && component instanceof JButton && (jb = (JButton)component).isDefaultButton()) {
            if (model.isEnabled()) {
                if (!model.isPressed() && !model.isArmed()) {
                    return ACTIVE;
                }
            } else {
                return DISABLED_ACTIVE;
            }
        }
        boolean isRolloverEnabled = true;
        if (component instanceof AbstractButton) {
            isRolloverEnabled = ((AbstractButton)component).isRolloverEnabled();
        }
        if (!model.isEnabled()) {
            if (model.isSelected()) {
                return DISABLED_SELECTED;
            }
            return DISABLED_UNSELECTED;
        }
        if (model.isPressed() && model.isArmed()) {
            if (model.isSelected()) {
                return PRESSED_SELECTED;
            }
            return PRESSED_UNSELECTED;
        }
        if (!toIgnoreSelection && model.isSelected()) {
            if ((component == null || isRolloverEnabled) && isRollover) {
                return ROLLOVER_SELECTED;
            }
            return SELECTED;
        }
        if (model.isArmed()) {
            if ((component == null || isRolloverEnabled) && isRollover) {
                return ROLLOVER_ARMED;
            }
            return ARMED;
        }
        if ((component == null || isRolloverEnabled) && isRollover) {
            return ROLLOVER_UNSELECTED;
        }
        return DEFAULT;
    }

    public static enum ColorSchemeKind {
        CURRENT,
        REGULAR,
        DISABLED;

    }
}

