/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.accounting.vatregisters.server;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jallinone.accounting.movements.java.JournalHeaderVO;
import org.jallinone.accounting.movements.java.JournalRowVO;
import org.jallinone.accounting.movements.server.InsertJournalItemBean;
import org.jallinone.events.server.EventsManager;
import org.jallinone.events.server.GenericEvent;
import org.jallinone.system.server.JAIOUserSessionParameters;
import org.jallinone.system.server.LoadUserParamAction;
import org.openswing.swing.internationalization.java.Resources;
import org.openswing.swing.internationalization.server.ServerResourcesFactory;
import org.openswing.swing.logger.server.Logger;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.server.Action;
import org.openswing.swing.server.ConnectionManager;
import org.openswing.swing.server.UserSessionParameters;

public class VatEndorseAction
implements Action {
    InsertJournalItemBean insJornalItemAction = new InsertJournalItemBean();
    LoadUserParamAction userParamAction = new LoadUserParamAction();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Response executeCommand(Object inputPar, UserSessionParameters userSessionPars, HttpServletRequest request, HttpServletResponse response, HttpSession userSession, ServletContext context) {
        Connection conn = null;
        Statement pstmt = null;
        Statement pstmt2 = null;
        try {
            String serverLanguageId = ((JAIOUserSessionParameters)userSessionPars).getServerLanguageId();
            conn = ConnectionManager.getConnection((ServletContext)context);
            EventsManager.getInstance().processEvent(new GenericEvent(this, this.getRequestName(), 0, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, inputPar, null));
            Map map = (Map)inputPar;
            String companyCode = (String)map.get("COMPANY_CODE_SYS01");
            java.util.Date toDate = (java.util.Date)map.get("DATE_FILTER");
            String sql = "select REGISTER_CODE,LAST_RECORD_NUMBER,LAST_VAT_DATE,ACCOUNT_CODE_ACC02 from ACC04_VAT_REGISTERS where COMPANY_CODE_SYS01=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, companyCode);
            ResultSet rset = pstmt.executeQuery();
            Hashtable<String, BigDecimal> lastRecordNumbers = new Hashtable<String, BigDecimal>();
            Hashtable<String, Date> lastVatDates = new Hashtable<String, Date>();
            Hashtable<String, String> accountCodes = new Hashtable<String, String>();
            String regCode = null;
            BigDecimal lastRN = null;
            Date lastVD = null;
            while (rset.next()) {
                regCode = rset.getString(1);
                lastRN = rset.getBigDecimal(2);
                lastVD = rset.getDate(3);
                if (lastRN == null) {
                    lastRN = new BigDecimal(0.0);
                }
                lastRecordNumbers.put(regCode, lastRN);
                if (lastVD == null) {
                    Calendar cal = Calendar.getInstance();
                    cal.set(2, 0);
                    cal.set(5, 1);
                    lastVD = new Date(cal.getTimeInMillis());
                }
                lastVatDates.put(regCode, lastVD);
                accountCodes.put(regCode, rset.getString(4));
            }
            rset.close();
            pstmt.close();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("COMPANY_CODE_SYS01", companyCode);
            params.put("PARAM_CODE", "VAT_ENDORSE_ACCOUNT");
            Response res = this.userParamAction.executeCommand(params, userSessionPars, request, response, userSession, context);
            if (res.isError()) {
                conn.rollback();
                Response response2 = res;
                return response2;
            }
            String vatEndorseAccountCode = ((VOResponse)res).getVo().toString();
            ServerResourcesFactory factory = (ServerResourcesFactory)context.getAttribute("RESOURCES_FACTORY");
            Resources resources = factory.getResources(userSessionPars.getLanguageId());
            SimpleDateFormat sdf = new SimpleDateFormat(resources.getDateMask(1));
            Enumeration en = lastRecordNumbers.keys();
            sql = "select VAT_VALUE,RECORD_NUMBER from ACC07_VAT_ROWS where COMPANY_CODE_SYS01=? and REGISTER_CODE_ACC04=? and RECORD_NUMBER>? and VAT_DATE<=?";
            pstmt = conn.prepareStatement(sql);
            BigDecimal amount = null;
            BigDecimal newLastRN = null;
            JournalHeaderVO jhVO = null;
            JournalRowVO jrVO = null;
            String accountCode = null;
            sql = "update ACC04_VAT_REGISTERS set LAST_RECORD_NUMBER=?,LAST_VAT_DATE=? where COMPANY_CODE_SYS01=? and REGISTER_CODE=? and (LAST_RECORD_NUMBER=? || LAST_RECORD_NUMBER is null)";
            pstmt2 = conn.prepareStatement(sql);
            while (en.hasMoreElements()) {
                amount = new BigDecimal(0.0);
                regCode = en.nextElement().toString();
                lastRN = (BigDecimal)lastRecordNumbers.get(regCode);
                lastVD = (Date)lastVatDates.get(regCode);
                accountCode = (String)accountCodes.get(regCode);
                pstmt.setString(1, companyCode);
                pstmt.setString(2, regCode);
                pstmt.setBigDecimal(3, lastRN);
                pstmt.setDate(4, new Date(toDate.getTime()));
                rset = pstmt.executeQuery();
                while (rset.next()) {
                    amount = amount.add(rset.getBigDecimal(1));
                    newLastRN = rset.getBigDecimal(2);
                }
                rset.close();
                if (amount.doubleValue() == 0.0) continue;
                lastVD.setTime(lastVD.getTime() + 86400000L);
                jhVO = new JournalHeaderVO();
                jhVO.setCompanyCodeSys01ACC05(companyCode);
                jhVO.setAccountingMotiveCodeAcc03ACC05("138");
                jhVO.setDescriptionACC05(resources.getResource("endorse vat from register") + " " + regCode + " " + resources.getResource("period") + " " + sdf.format(lastVD) + " - " + sdf.format(toDate));
                jhVO.setItemDateACC05(new Date(System.currentTimeMillis()));
                jhVO.setItemYearACC05(new BigDecimal((double)Calendar.getInstance().get(1)));
                jrVO = new JournalRowVO();
                jrVO.setCompanyCodeSys01ACC06(jhVO.getCompanyCodeSys01ACC05());
                jrVO.setAccountCodeAcc02ACC06(accountCode);
                jrVO.setAccountCodeACC06(accountCode);
                jrVO.setAccountCodeTypeACC06("A");
                jrVO.setDebitAmountACC06(amount);
                jrVO.setDescriptionACC06("");
                jrVO.setItemYearAcc05ACC06(jhVO.getItemYearACC05());
                jrVO.setProgressiveAcc05ACC06(jhVO.getProgressiveACC05());
                jhVO.addJournalRow(jrVO);
                jrVO = new JournalRowVO();
                jrVO.setCompanyCodeSys01ACC06(jhVO.getCompanyCodeSys01ACC05());
                jrVO.setAccountCodeAcc02ACC06(vatEndorseAccountCode);
                jrVO.setAccountCodeACC06(vatEndorseAccountCode);
                jrVO.setAccountCodeTypeACC06("A");
                jrVO.setCreditAmountACC06(amount);
                jrVO.setDescriptionACC06("");
                jrVO.setItemYearAcc05ACC06(jhVO.getItemYearACC05());
                jrVO.setProgressiveAcc05ACC06(jhVO.getProgressiveACC05());
                jhVO.addJournalRow(jrVO);
                res = this.insJornalItemAction.insertItem(conn, jhVO, userSessionPars, request, response, userSession, context);
                if (res.isError()) {
                    conn.rollback();
                    Response response3 = res;
                    return response3;
                }
                pstmt2.setBigDecimal(1, newLastRN);
                pstmt2.setDate(2, new Date(toDate.getTime()));
                pstmt2.setString(3, companyCode);
                pstmt2.setString(4, regCode);
                pstmt2.setBigDecimal(5, lastRN);
                int upd = pstmt2.executeUpdate();
                if (upd != 0) continue;
                conn.rollback();
                ErrorResponse errorResponse = new ErrorResponse("Updating not performed: the record was previously updated.");
                return errorResponse;
            }
            VOResponse answer = new VOResponse((Object)Boolean.TRUE);
            EventsManager.getInstance().processEvent(new GenericEvent(this, this.getRequestName(), 1, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, inputPar, answer));
            conn.commit();
            EventsManager.getInstance().processEvent(new GenericEvent(this, this.getRequestName(), 2, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, inputPar, answer));
            VOResponse vOResponse = answer;
            return vOResponse;
        }
        catch (Throwable ex) {
            Logger.error((String)userSessionPars.getUsername(), (String)this.getClass().getName(), (String)"executeCommand", (String)"Error while endorsing vat", (Throwable)ex);
            try {
                conn.rollback();
            }
            catch (Exception ex3) {
                // empty catch block
            }
            ErrorResponse errorResponse = new ErrorResponse(ex.toString());
            return errorResponse;
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception ex2) {}
            try {
                pstmt2.close();
            }
            catch (Exception ex2) {}
            try {
                ConnectionManager.releaseConnection((Connection)conn, (ServletContext)context);
            }
            catch (Exception ex1) {
            }
        }
    }

    public final String getRequestName() {
        return "vatEndorse";
    }
}

