/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.purchases.pricelist.server;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jallinone.events.server.EventsManager;
import org.jallinone.events.server.GenericEvent;
import org.jallinone.items.java.DetailItemVO;
import org.jallinone.items.java.ItemPK;
import org.jallinone.items.server.LoadItemAction;
import org.jallinone.purchases.items.java.SupplierItemVO;
import org.jallinone.purchases.items.server.InsertSupplierItemsBean;
import org.jallinone.purchases.pricelist.java.SupplierPriceVO;
import org.jallinone.system.server.JAIOUserSessionParameters;
import org.openswing.swing.logger.server.Logger;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.server.Action;
import org.openswing.swing.server.ConnectionManager;
import org.openswing.swing.server.QueryUtil;
import org.openswing.swing.server.UserSessionParameters;

public class InsertSupplierPricesAction
implements Action {
    private InsertSupplierItemsBean insItem = new InsertSupplierItemsBean();
    private LoadItemAction loadItem = new LoadItemAction();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Response executeCommand(Object inputPar, UserSessionParameters userSessionPars, HttpServletRequest request, HttpServletResponse response, HttpSession userSession, ServletContext context) {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rset = null;
        try {
            conn = ConnectionManager.getConnection((ServletContext)context);
            EventsManager.getInstance().processEvent(new GenericEvent(this, this.getRequestName(), 0, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, inputPar, null));
            pstmt = conn.prepareStatement("select ITEM_CODE_ITM01 from PUR02_SUPPLIER_ITEMS where COMPANY_CODE_SYS01=? and PROGRESSIVE_REG04=? and ITEM_CODE_ITM01=?");
            HashMap<String, String> attribute2dbField = new HashMap<String, String>();
            attribute2dbField.put("companyCodeSys01PUR04", "COMPANY_CODE_SYS01");
            attribute2dbField.put("pricelistCodePur03PUR04", "PRICELIST_CODE_PUR03");
            attribute2dbField.put("progressiveReg04PUR04", "PROGRESSIVE_REG04");
            attribute2dbField.put("itemCodeItm01PUR04", "ITEM_CODE_ITM01");
            attribute2dbField.put("valuePUR04", "VALUE");
            attribute2dbField.put("startDatePUR04", "START_DATE");
            attribute2dbField.put("endDatePUR04", "END_DATE");
            ArrayList list = (ArrayList)inputPar;
            SupplierPriceVO vo = null;
            Response res = null;
            ArrayList<SupplierItemVO> items = new ArrayList<SupplierItemVO>();
            SupplierItemVO itemVO = new SupplierItemVO();
            items.add(itemVO);
            DetailItemVO detailItemVO = null;
            int i = 0;
            while (i < list.size()) {
                vo = (SupplierPriceVO)((Object)list.get(i));
                pstmt.setString(1, vo.getCompanyCodeSys01PUR04());
                pstmt.setBigDecimal(2, vo.getProgressiveReg04PUR04());
                pstmt.setString(3, vo.getItemCodeItm01PUR04());
                rset = pstmt.executeQuery();
                if (!rset.next()) {
                    res = this.loadItem.executeCommand(new ItemPK(vo.getCompanyCodeSys01PUR04(), vo.getItemCodeItm01PUR04()), userSessionPars, request, response, userSession, context);
                    if (res.isError()) {
                        conn.rollback();
                        Response response2 = res;
                        return response2;
                    }
                    detailItemVO = (DetailItemVO)((Object)((VOResponse)res).getVo());
                    itemVO.setCompanyCodeSys01PUR02(vo.getCompanyCodeSys01PUR04());
                    itemVO.setDecimalsREG02(detailItemVO.getMinSellingQtyDecimalsREG02());
                    itemVO.setItemCodeItm01PUR02(vo.getItemCodeItm01PUR04());
                    itemVO.setMinPurchaseQtyPUR02(detailItemVO.getMinSellingQtyITM01());
                    itemVO.setMultipleQtyPUR02(itemVO.getMinPurchaseQtyPUR02());
                    itemVO.setProgressiveHie01PUR02(detailItemVO.getProgressiveHie01ITM01());
                    itemVO.setProgressiveHie02PUR02(detailItemVO.getProgressiveHie02ITM01());
                    itemVO.setProgressiveReg04PUR02(vo.getProgressiveReg04PUR04());
                    itemVO.setSupplierItemCodePUR02(vo.getItemCodeItm01PUR04());
                    itemVO.setUmCodeReg02PUR02(detailItemVO.getMinSellingQtyUmCodeReg02ITM01());
                    res = this.insItem.insertSupplierItems(conn, items, userSessionPars, request, response, userSession, context);
                    if (res.isError()) {
                        conn.rollback();
                        Response response3 = res;
                        return response3;
                    }
                }
                rset.close();
                res = QueryUtil.insertTable((Connection)conn, (UserSessionParameters)userSessionPars, (ValueObject)vo, (String)"PUR04_SUPPLIER_PRICES", attribute2dbField, (String)"Y", (String)"N", (ServletContext)context, (boolean)true);
                if (res.isError()) {
                    conn.rollback();
                    Response response4 = res;
                    return response4;
                }
                ++i;
            }
            VOListResponse answer = new VOListResponse((List)list, false, list.size());
            EventsManager.getInstance().processEvent(new GenericEvent(this, this.getRequestName(), 1, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, inputPar, answer));
            conn.commit();
            EventsManager.getInstance().processEvent(new GenericEvent(this, this.getRequestName(), 2, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, inputPar, answer));
            VOListResponse vOListResponse = answer;
            return vOListResponse;
        }
        catch (Throwable ex) {
            Logger.error((String)userSessionPars.getUsername(), (String)this.getClass().getName(), (String)"executeCommand", (String)"Error while inserting a new supplier item price", (Throwable)ex);
            try {
                conn.rollback();
            }
            catch (Exception ex3) {
                // empty catch block
            }
            ErrorResponse errorResponse = new ErrorResponse(ex.getMessage());
            return errorResponse;
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception ex4) {}
            try {
                pstmt.close();
            }
            catch (Exception ex2) {}
            try {
                ConnectionManager.releaseConnection((Connection)conn, (ServletContext)context);
            }
            catch (Exception ex1) {
            }
        }
    }

    public final String getRequestName() {
        return "insertSupplierPrices";
    }
}

