/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.documents.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jallinone.events.server.EventsManager;
import org.jallinone.events.server.GenericEvent;
import org.jallinone.sales.documents.java.DetailSaleDocVO;
import org.jallinone.sales.documents.java.GridSaleDocRowVO;
import org.jallinone.sales.documents.java.SaleDocPK;
import org.jallinone.subjects.java.OrganizationVO;
import org.jallinone.subjects.java.SubjectPK;
import org.jallinone.system.companies.server.LoadCompanyAction;
import org.jallinone.system.server.JAIOUserSessionParameters;
import org.jallinone.system.server.LoadUserParamAction;
import org.openswing.swing.internationalization.java.Resources;
import org.openswing.swing.internationalization.server.ServerResourcesFactory;
import org.openswing.swing.logger.server.Logger;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.server.ConnectionManager;
import org.openswing.swing.server.UserSessionParameters;

public class ExportRetailSaleOnFileBean {
    private LoadCompanyAction companyAction;
    private LoadUserParamAction userParAction = new LoadUserParamAction();

    public ExportRetailSaleOnFileBean() {
        this.companyAction = new LoadCompanyAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final Response exportToFile(SaleDocPK pk, DetailSaleDocVO docVO, ArrayList rows, UserSessionParameters userSessionPars, HttpServletRequest request, HttpServletResponse response, HttpSession userSession, ServletContext context) {
        Statement pstmt;
        Connection conn;
        block43: {
            Response companyRes;
            String path;
            String programPath;
            Resources resources;
            block40: {
                BigDecimal progressiveREG04;
                block37: {
                    block34: {
                        Response userParRes;
                        block31: {
                            String serverLanguageId = ((JAIOUserSessionParameters)userSessionPars).getServerLanguageId();
                            conn = null;
                            pstmt = null;
                            EventsManager.getInstance().processEvent(new GenericEvent(this, "ExportRetailSaleOnFileBean.exportToFile", 0, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, (Object)docVO, null));
                            ServerResourcesFactory factory = (ServerResourcesFactory)context.getAttribute("RESOURCES_FACTORY");
                            resources = factory.getResources(userSessionPars.getLanguageId());
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("COMPANY_CODE_SYS01", pk.getCompanyCodeSys01DOC01());
                            params.put("PARAM_CODE", "RECEIPT_PATH");
                            userParRes = this.userParAction.executeCommand(params, userSessionPars, request, response, userSession, context);
                            if (!userParRes.isError()) break block31;
                            Response response2 = userParRes;
                            Object var37_18 = null;
                            try {
                                pstmt.close();
                            }
                            catch (Exception ex2) {
                                // empty catch block
                            }
                            try {
                                ConnectionManager.releaseConnection(conn, (ServletContext)context);
                            }
                            catch (Exception ex1) {
                            }
                            return response2;
                        }
                        programPath = (String)((VOResponse)userParRes).getVo();
                        if (programPath != null) break block34;
                        ErrorResponse errorResponse = new ErrorResponse(resources.getResource("retail sale export non allowed: receipt path has not been defined as user parameter."));
                        Object var37_19 = null;
                        try {
                            pstmt.close();
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                        try {
                            ConnectionManager.releaseConnection((Connection)conn, (ServletContext)context);
                        }
                        catch (Exception ex1) {
                        }
                        return errorResponse;
                    }
                    programPath = programPath.replace('\\', '/');
                    path = programPath.substring(0, programPath.lastIndexOf("/"));
                    conn = ConnectionManager.getConnection((ServletContext)context);
                    pstmt = conn.prepareStatement("select PROGRESSIVE from REG04_SUBJECTS where COMPANY_CODE_SYS01=? and SUBJECT_TYPE=?");
                    pstmt.setString(1, pk.getCompanyCodeSys01DOC01());
                    pstmt.setString(2, "M");
                    ResultSet rset = pstmt.executeQuery();
                    progressiveREG04 = null;
                    if (rset.next()) {
                        progressiveREG04 = rset.getBigDecimal(1);
                    }
                    rset.close();
                    if (progressiveREG04 != null) break block37;
                    ErrorResponse errorResponse = new ErrorResponse(resources.getResource("company not found."));
                    Object var37_20 = null;
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    try {
                        ConnectionManager.releaseConnection((Connection)conn, (ServletContext)context);
                    }
                    catch (Exception ex1) {
                    }
                    return errorResponse;
                }
                SubjectPK subjectPK = new SubjectPK(pk.getCompanyCodeSys01DOC01(), progressiveREG04);
                companyRes = this.companyAction.executeCommand(subjectPK, userSessionPars, request, response, userSession, context);
                if (!companyRes.isError()) break block40;
                Response response3 = companyRes;
                Object var37_21 = null;
                try {
                    pstmt.close();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                try {
                    ConnectionManager.releaseConnection((Connection)conn, (ServletContext)context);
                }
                catch (Exception ex1) {
                }
                return response3;
            }
            OrganizationVO companyVO = (OrganizationVO)((VOResponse)companyRes).getVo();
            GridSaleDocRowVO docRowVO = null;
            String tmpFile = path + "/receipt_" + docVO.getDocYearDOC01() + "_" + docVO.getDocSequenceDOC01() + ".tmp";
            PrintWriter pw = new PrintWriter(new FileOutputStream(tmpFile));
            pw.println(companyVO.getName_1REG04());
            pw.println(companyVO.getAddressREG04() == null ? "" : companyVO.getAddressREG04());
            pw.println(companyVO.getCityREG04() == null ? "" : companyVO.getCityREG04());
            pw.println(companyVO.getProvinceREG04() == null ? "" : companyVO.getProvinceREG04());
            pw.println(companyVO.getTaxCodeREG04() == null ? "" : companyVO.getTaxCodeREG04());
            pw.println();
            int i = 0;
            while (i < rows.size()) {
                docRowVO = (GridSaleDocRowVO)((Object)rows.get(i));
                pw.println(docRowVO.getItemCodeItm01DOC02() + "\t" + docRowVO.getDescriptionSYS10() + "\t" + docVO.getCurrencyCodeReg03DOC01() + "\t" + docRowVO.getValueDOC02());
                ++i;
            }
            pw.println();
            if (docVO.getDiscountPercDOC01() != null) {
                pw.println("%\t" + docVO.getDiscountPercDOC01());
            }
            if (docVO.getDiscountValueDOC01() != null) {
                pw.println(docVO.getCurrencyCodeReg03DOC01() + "\t" + docVO.getDiscountValueDOC01());
            }
            pw.println();
            pw.println(docVO.getCurrencyCodeReg03DOC01() + "\t" + docVO.getTotalDOC01());
            pw.println();
            SimpleDateFormat sdf = new SimpleDateFormat(resources.getDateMask(2));
            pw.println(sdf.format(new Date()));
            pw.println();
            pw.println(docVO.getDocSequenceDOC01());
            pw.close();
            String file = path + "/receipt_" + docVO.getDocYearDOC01() + "_" + docVO.getDocSequenceDOC01() + ".txt";
            new File(tmpFile).renameTo(new File(file));
            Process p = Runtime.getRuntime().exec(programPath + " " + file);
            LogProcessMessage log = new LogProcessMessage(userSessionPars.getUsername(), p.getInputStream());
            LogErrorProcessMessage errorLog = new LogErrorProcessMessage(userSessionPars.getUsername(), p.getErrorStream());
            int returnCode = p.waitFor();
            if (returnCode == 0) break block43;
            ErrorResponse errorResponse = new ErrorResponse(resources.getResource("error while executing external application; return code:") + " " + returnCode);
            Object var37_22 = null;
            try {
                pstmt.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            try {
                ConnectionManager.releaseConnection((Connection)conn, (ServletContext)context);
            }
            catch (Exception ex1) {
            }
            return errorResponse;
        }
        VOResponse vOResponse = new VOResponse((Object)Boolean.TRUE);
        Object var37_23 = null;
        try {
            pstmt.close();
        }
        catch (Exception ex2) {
            // empty catch block
        }
        try {
            ConnectionManager.releaseConnection((Connection)conn, (ServletContext)context);
        }
        catch (Exception ex1) {
        }
        return vOResponse;
        catch (Throwable ex) {
            ErrorResponse errorResponse;
            try {
                Logger.error((String)userSessionPars.getUsername(), (String)this.getClass().getName(), (String)"executeCommand", (String)"Error while exporting a retail sale to file", (Throwable)ex);
                errorResponse = new ErrorResponse(ex.getMessage());
                Object var37_24 = null;
            }
            catch (Throwable throwable) {
                Object var37_25 = null;
                try {
                    pstmt.close();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                try {
                    ConnectionManager.releaseConnection(conn, (ServletContext)context);
                }
                catch (Exception ex1) {
                }
                throw throwable;
            }
            try {
                pstmt.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            try {
                ConnectionManager.releaseConnection(conn, (ServletContext)context);
            }
            catch (Exception ex1) {
            }
            return errorResponse;
        }
    }

    class LogErrorProcessMessage
    extends Thread {
        private BufferedReader brError = null;
        private String username = null;

        public LogErrorProcessMessage(String username, InputStream in) {
            this.username = username;
            this.brError = new BufferedReader(new InputStreamReader(in));
            this.start();
        }

        public void run() {
            String line = null;
            try {
                while ((line = this.brError.readLine()) != null) {
                    Logger.error((String)this.username, (String)"org.jallinone.sales.documents.server.LogErrorProcessMessage", (String)"run", (String)line, null);
                }
            }
            catch (IOException ex) {
            }
        }
    }

    class LogProcessMessage
    extends Thread {
        private BufferedReader br = null;
        private String username = null;

        public LogProcessMessage(String username, InputStream in) {
            this.username = username;
            this.br = new BufferedReader(new InputStreamReader(in));
            this.start();
        }

        public void run() {
            String line = null;
            try {
                while ((line = this.br.readLine()) != null) {
                    Logger.debug((String)this.username, (String)"org.jallinone.sales.documents.server.LogProcessMessage", (String)"run", (String)line);
                }
            }
            catch (IOException ex) {
            }
        }
    }
}

