/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.pricelist.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jallinone.events.server.EventsManager;
import org.jallinone.events.server.GenericEvent;
import org.jallinone.sales.pricelist.java.PricelistChanges;
import org.jallinone.system.server.JAIOUserSessionParameters;
import org.openswing.swing.logger.server.Logger;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.server.Action;
import org.openswing.swing.server.ConnectionManager;
import org.openswing.swing.server.UserSessionParameters;

public class ChangePricelistAction
implements Action {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final Response executeCommand(Object inputPar, UserSessionParameters userSessionPars, HttpServletRequest request, HttpServletResponse response, HttpSession userSession, ServletContext context) {
        String sql;
        Connection conn = null;
        Statement pstmt = null;
        String serverLanguageId = ((JAIOUserSessionParameters)userSessionPars).getServerLanguageId();
        conn = ConnectionManager.getConnection((ServletContext)context);
        EventsManager.getInstance().processEvent(new GenericEvent(this, this.getRequestName(), 0, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, inputPar, null));
        PricelistChanges changes = (PricelistChanges)inputPar;
        if (changes.getStartDate() != null && changes.getEndDate() != null) {
            sql = "update SAL02_PRICES set START_DATE=?,END_DATE=? where COMPANY_CODE_SYS01=? and PRICELIST_CODE_SAL01=? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setDate(1, changes.getStartDate());
            pstmt.setDate(2, changes.getEndDate());
            pstmt.setString(3, changes.getCompanyCodeSys01SAL02());
            pstmt.setString(4, changes.getPricelistCodeSal01SAL02());
            pstmt.execute();
            pstmt.close();
        }
        if (changes.getPercentage() != null && !changes.isTruncateDecimals()) {
            sql = "update SAL02_PRICES set VALUE=VALUE+VALUE*" + changes.getPercentage().doubleValue() + "/100 where COMPANY_CODE_SYS01=? and PRICELIST_CODE_SAL01=? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, changes.getCompanyCodeSys01SAL02());
            pstmt.setString(2, changes.getPricelistCodeSal01SAL02());
            pstmt.execute();
            pstmt.close();
        }
        if (changes.getPercentage() != null && changes.isTruncateDecimals()) {
            sql = "select ITEM_CODE_ITM01,VALUE from SAL02_PRICES where COMPANY_CODE_SYS01=? and PRICELIST_CODE_SAL01=? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, changes.getCompanyCodeSys01SAL02());
            pstmt.setString(2, changes.getPricelistCodeSal01SAL02());
            ResultSet rset = pstmt.executeQuery();
            PreparedStatement pstmt2 = conn.prepareStatement("update SAL02_PRICES set VALUE=? where COMPANY_CODE_SYS01=? and PRICELIST_CODE_SAL01=? and ITEM_CODE_ITM01=?");
            while (rset.next()) {
                pstmt2.setInt(1, (int)(rset.getDouble(2) + rset.getDouble(2) * changes.getPercentage().doubleValue() / 100.0));
                pstmt2.setString(2, changes.getCompanyCodeSys01SAL02());
                pstmt2.setString(3, changes.getPricelistCodeSal01SAL02());
                pstmt2.setString(4, rset.getString(1));
                pstmt2.execute();
            }
            rset.close();
            pstmt.close();
            pstmt2.close();
        }
        if (changes.getDeltaValue() != null) {
            sql = "update SAL02_PRICES set VALUE=VALUE+" + changes.getDeltaValue().doubleValue() + " where COMPANY_CODE_SYS01=? and PRICELIST_CODE_SAL01=? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, changes.getCompanyCodeSys01SAL02());
            pstmt.setString(2, changes.getPricelistCodeSal01SAL02());
            pstmt.execute();
            pstmt.close();
        }
        VOResponse answer = new VOResponse((Object)Boolean.TRUE);
        EventsManager.getInstance().processEvent(new GenericEvent(this, this.getRequestName(), 1, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, inputPar, answer));
        conn.commit();
        EventsManager.getInstance().processEvent(new GenericEvent(this, this.getRequestName(), 2, (JAIOUserSessionParameters)userSessionPars, request, response, userSession, context, conn, inputPar, answer));
        VOResponse vOResponse = answer;
        Object var15_17 = null;
        try {
            pstmt.close();
        }
        catch (Exception ex2) {
            // empty catch block
        }
        try {
            ConnectionManager.releaseConnection((Connection)conn, (ServletContext)context);
        }
        catch (Exception ex1) {
        }
        return vOResponse;
        catch (Throwable ex) {
            ErrorResponse errorResponse;
            try {
                Logger.error((String)userSessionPars.getUsername(), (String)this.getClass().getName(), (String)"executeCommand", (String)"Error while updating existing prices", (Throwable)ex);
                try {
                    conn.rollback();
                }
                catch (Exception ex3) {
                    // empty catch block
                }
                errorResponse = new ErrorResponse(ex.getMessage());
                Object var15_18 = null;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                try {
                    pstmt.close();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                try {
                    ConnectionManager.releaseConnection((Connection)conn, (ServletContext)context);
                }
                catch (Exception ex1) {
                }
                throw throwable;
            }
            try {
                pstmt.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            try {
                ConnectionManager.releaseConnection((Connection)conn, (ServletContext)context);
            }
            catch (Exception ex1) {
            }
            return errorResponse;
        }
    }

    public final String getRequestName() {
        return "changePricelist";
    }
}

