package org.openswing.swing.message.send.java;

import java.io.*;
import java.util.*;


/**
 * <p>Title: OpenSwing Framework</p>
 * <p>Description: Parameters generated by the lookup controller to validate code.</p>
 * <p>Copyright: Copyright (C) 2006 Mauro Carniel</p>
 *
 * <p> This file is part of OpenSwing Framework.
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the (LGPL) Lesser General Public
 * License as published by the Free Software Foundation;
 *
 *                GNU LESSER GENERAL PUBLIC LICENSE
 *                 Version 2.1, February 1999
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *       The author may be contacted at:
 *           maurocarniel@tin.it</p>
 *
 * @author Mauro Carniel
 * @version 1.0
 */
public class LookupValidationParams implements Serializable {

  /** code to validate */
  private String code = null;

  /** parameters used to validate code (optionals) */
  private Map lookupValidationParameters = null;


  /**
   * @param code code to validate
   * @param lookupValidationParameters parameters used to validate code (optionals)
   */
  public LookupValidationParams(String code,Map lookupValidationParameters) {
    this.code = code;
    this.lookupValidationParameters = lookupValidationParameters;
  }


  /**
   * @return parameters used to validate code (optionals)
   */
  public final Map getLookupValidationParameters() {
    return lookupValidationParameters;
  }


  /**
   * @return code to validate
   */
  public final String getCode() {
    return code;
  }

}
