package org.openswing.swing.util.server;

import java.util.*;

import org.openswing.swing.message.send.java.*;


/**
 * <p>Title: OpenSwing Framework</p>
 * <p>Description: Wrapper for filtering and sorting conditions used by iBatis in a SQL select.</p>
 * <p>Copyright: Copyright (C) 2006 Mauro Carniel</p>
 *
 * <p> This file is part of OpenSwing Framework.
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the (LGPL) Lesser General Public
 * License as published by the Free Software Foundation;
 *
 *                GNU LESSER GENERAL PUBLIC LICENSE
 *                 Version 2.1, February 1999
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *       The author may be contacted at:
 *           maurocarniel@tin.it</p>
 *
 * @author Mauro Carniel
 * @version 1.0
 */
public class IBatisParamsWrapper {

  /** filtered columns; collection of pairs: attributeName, FilterWhereClause[2] */
  private List filteredColumns = null;

  /** sorted columns; collection of IBatisSortCondition elements */
  private ArrayList sortedColumns = new ArrayList();


  /**
   * Constructor callable from a DAO class that uses iBatis layer, when no filtering or sorting conditions are applied.
   */
  public IBatisParamsWrapper() {
    this(new HashMap(),new ArrayList(),new ArrayList());
  }

  /**
   * Construtor callable from a DAO class that uses iBatis layer.
   * @param filteredColumns Map collection of filtering conditions generated by an OpenSwing grid control
   * @param currentSortedColumns list of attribute names related to fields to sort, generated by an OpenSwing grid control
   * @param currentSortedVersusColumns ArrayList list of sorting versus (ASC/DESC) related to fields to sort, generated by an OpenSwing grid control
   */
  public IBatisParamsWrapper(
    Map filteredColumns,
    ArrayList currentSortedColumns,
    ArrayList currentSortedVersusColumns
  ) {
    this.filteredColumns = new ArrayList();
    Iterator it = filteredColumns.values().iterator();
    FilterWhereClause[] filterClauses = null;
    while(it.hasNext()) {
      filterClauses = (FilterWhereClause[])it.next();
      this.filteredColumns.add(filterClauses[0]);
      if (filterClauses[1]!=null)
        this.filteredColumns.add(filterClauses[1]);
    }

    for(int i=0;i<currentSortedColumns.size();i++)
      sortedColumns.add(new IBatisSortCondition(
        currentSortedColumns.get(i).toString(),
        currentSortedVersusColumns.get(i).toString()
      ));
  }


  /**
   * @return collection of IBatisSortCondition elements
   */
  public final ArrayList getSortedColumns() {
    return sortedColumns;
  }


  /**
   * @return filteredColumns; list of FilterWhereClause objects
   */
  public final List getFilteredColumns() {
    return filteredColumns;
  }


  /**
   * <p>Title: OpenSwing Framework</p>
   * <p>Description: Inner class used by IBatisParamsWrapper</p>
   * <p>Copyright: Copyright (C) 2006 Mauro Carniel</p>
   * @version 1.0
   */
  class IBatisSortCondition {

    private String attributeName;
    private String versus;


    public IBatisSortCondition(String attributeName,String versus) {
      this.attributeName = attributeName;
      this.versus = versus;
    }


    public final String getAttributeName() {
      return attributeName;
    }


    public final String getVersus() {
      return versus;
    }
  } // end inner-class


}


