package org.openswing.swing.internationalization.java;

import java.util.*;

/**
 * <p>Title: OpenSwing Framework</p>
 * <p>Description: Class for retrieve the collection of all internationalization properties:
 * translations, data/numeric/currency formats.
 * No translation is performed, date/numeric/currency formats are based on english formats.</p>
 * <p>Copyright: Copyright (C) 2006 Mauro Carniel</p>
 *
 * <p> This file is part of OpenSwing Framework.
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the (LGPL) Lesser General Public
 * License as published by the Free Software Foundation;
 *
 *                GNU LESSER GENERAL PUBLIC LICENSE
 *                 Version 2.1, February 1999
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *       The author may be contacted at:
 *           maurocarniel@tin.it</p>
 *
 * @author Mauro Carniel/Zoltn Zidarics/Attila Szomor
 * @version 1.0
 */
public class HungarianOnlyResourceFactory extends ResourcesFactory {

    /** internationalization settings */
    private Resources resources = null;

    /**
     * Constructor.
     * @param currencySymbol currency symbol
     * @param additionalDictionary additional descriptions
     * @param showResourceNotFoundWarning warn when no resource key not found
     */
    public HungarianOnlyResourceFactory(String currencySymbol, Properties additionalDictionary, boolean showResourceNotFoundWarning) {
        this(currencySymbol, additionalDictionary, showResourceNotFoundWarning, '/');
    }

    /**
     * Constructor.
     * @param currencySymbol currency symbol
     * @param additionalDictionary additional descriptions
     * @param showResourceNotFoundWarning warn when no resource key not found
     * @param dateFormatSeparator date format separator; for example: '-' or '/'
     */
    public HungarianOnlyResourceFactory(String currencySymbol, Properties additionalDictionary, boolean showResourceNotFoundWarning, char dateFormatSeparator) {
        Properties dictionary = new Properties();

        dictionary.putAll(additionalDictionary);

        // grid...
        dictionary.setProperty("of", "/");
        dictionary.setProperty("page", "Oldal");
        dictionary.setProperty("Remove Filter", "Sz\u0171r\u0151felttel trlse");
        dictionary.setProperty("This column is not sorteable", "Ezen oszlop alapjn nem rendezhet\u0151");
        dictionary.setProperty("Sorting not allowed", "A rendezs nem engedlyezett");
        dictionary.setProperty("Maximum number of sorted columns", "Maximlisan rendezhet\u0151 oszlopok szma");
        dictionary.setProperty("Sorting not applicable", "Rendezs nem hajthat vcgre");
        dictionary.setProperty("Selected Row", "Kijellt sor");
        dictionary.setProperty("Selected Rows", "Kijellt sorok");
        dictionary.setProperty("Cancel changes and reload data?", "Eldobja a vltoztsokat s jratlti az adatokat?");
        dictionary.setProperty("Attention", "Figyelmeztets");
        dictionary.setProperty("Loading data...", "Adatok betltse...");
        dictionary.setProperty("Error while loading data", "Hiba betlts kzben");
        dictionary.setProperty("Loading Data Error", "Adathiba");
        dictionary.setProperty("Delete Rows?", "Sor trlse?");
        dictionary.setProperty("Delete Confirmation", "Trls meger\u0151sts");
        dictionary.setProperty("Error while deleting rows.", "Hiba sor trlse kzben.");
        dictionary.setProperty("Deleting Error", "Trls hiba");
        dictionary.setProperty("Error while saving", "Hiba ments kzben");
        dictionary.setProperty("Saving Error", "Ments hiba");
        dictionary.setProperty("A mandatory column is empty.", "A ktelez\u0151en kitltend\u0151 oszlop res.");
        dictionary.setProperty("Value not valid", "Hibs rtk");
        dictionary.setProperty("sorting conditions", "Rendezsi felttelek");
        dictionary.setProperty("filtering conditions", "Sz\u0171rsi felttelek");
        dictionary.setProperty("filtering and sorting settings", "Sz\u0171rsi s rendezsi belltsok");
        dictionary.setProperty("Filtering/Sorting data (CTRL+F)", "Adat sz\u0171rs/rendezs (CTRL+F)");
        dictionary.setProperty("upload file", "Fjl feltltse");
        dictionary.setProperty("download file", "Fjl letltse");

        // export...
        dictionary.setProperty("grid export", "Tbla exportls");
        dictionary.setProperty("export", "Exportls");
        dictionary.setProperty("exportmnemonic", "X");
        dictionary.setProperty("column", "Oszlop");
        dictionary.setProperty("sel.", "Jell");
        dictionary.setProperty("you must select at least one column", "Legalbb egy oszlopot ki kell jellnie");
        dictionary.setProperty("columns to export", "Exportland oszlopok");
        dictionary.setProperty("export type", "Export formtum");

        // import...
        dictionary.setProperty("grid import", "Tbla Importls");
        dictionary.setProperty("file to import", "Import file");
        dictionary.setProperty("import", "Import");
        dictionary.setProperty("importmnemonic", "M");
        dictionary.setProperty("columns to import", "Importland oszlopok");
        dictionary.setProperty("import type", "Import formtum");
        dictionary.setProperty("error while importing data", "Hiba importls kzben");
        dictionary.setProperty("import completed", "Importls ksz");

        // quick filter...
        dictionary.setProperty("To value", "Tartalomra");
        dictionary.setProperty("Filter by", "Sz\u0171rs alapja");
        dictionary.setProperty("From value", "rtkt\u0151l");
        dictionary.setProperty("equals", "egyenl\u0151");
        dictionary.setProperty("contains", "tartalmazza");
        dictionary.setProperty("starts with", "kezd\u0151dik");
        dictionary.setProperty("ends with", "vgz\u0151dik");

        // select/deselect all
        dictionary.setProperty("select all", "Az sszes kiejllse");
        dictionary.setProperty("deselect all", "Kijellsek megszntetse");

        // copy/cut/paste
        dictionary.setProperty("copy", "Msol");
        dictionary.setProperty("copymnemonic", "C");
        dictionary.setProperty("cut", "Kivg");
        dictionary.setProperty("cutmnemonic", "X");
        dictionary.setProperty("paste", "Beilleszt");
        dictionary.setProperty("pastemnemonic", "V");

        // lookup...
        dictionary.setProperty("Code is not correct.", "A kd nem korrekt");
        dictionary.setProperty("Code Validation", "Kd validls");
        dictionary.setProperty("Code Selection", "Kd vlaszts");

        // form...
        dictionary.setProperty("Confirm deliting data?", "Biztos trlni akarja?");
        dictionary.setProperty("Error while saving: incorrect data.", "Hiba ments kzben: inkorrekt adat.");
        dictionary.setProperty("Error on deleting:", "Hiba trls kzben:");
        dictionary.setProperty("Error on Loading", "Hiba betlts kzben");
        dictionary.setProperty("Error while loading data:", "Hiba betlts kzben:");
        dictionary.setProperty("Error on setting value to the input control having the attribute name", "Hiba bellts kzben az attributumnak nincs rtke");

        // toolbar buttons...
        dictionary.setProperty("Delete record (CTRL+D)", "Rekord trls (CTRL+D)");
        dictionary.setProperty("Edit record (CTRL+E)", "Rekord szerkesztse (CTRL+E)");
        dictionary.setProperty("New record (CTRL+I)", "j rekord (CTRL+I)");
        dictionary.setProperty("Reload record/Cancel current operation (CTRL+Z)", "Az aktulis operci trlse/rekord jratltse (CTRL+Z)");
        dictionary.setProperty("Save record (CTRL+S)", "Rekord mentse (CTRL+S)");
        dictionary.setProperty("Copy record (CTRL+C)", "Rekord msolsa (CTRL+C)");
        dictionary.setProperty("Export record (CTRL+X)", "Rekord exportlsa (CTRL+X)");
        dictionary.setProperty("Import records (CTRL+M)", "Rekords importlsa (CTRL+M)");
        dictionary.setProperty("Load the first block of records", "Az els\u0151 blokk betltse");
        dictionary.setProperty("Select the previous row in grid", "A tbla el\u0151z\u0151 sornak kivlasztsa");
        dictionary.setProperty("Select the next row in grid", "A tbla kvetkez\u0151 sornak kivlasztsa");
        dictionary.setProperty("Load the previous block of records", "Az el\u0151z\u0151 blokk betltse");
        dictionary.setProperty("Load the next block of records", "A kvetkez\u0151 blokk betltse");
        dictionary.setProperty("Load the last block of records", "Az utols blokk betltse");

        dictionary.setProperty("Insert", "Beszrs");
        dictionary.setProperty("Edit", "Szerkeszts");
        dictionary.setProperty("Copy", "Msols");
        dictionary.setProperty("Delete", "Trls");
        dictionary.setProperty("Save", "Ments");
        dictionary.setProperty("Reload", "jratlts");
        dictionary.setProperty("Export", "Export");
        dictionary.setProperty("Filter", "Sz\u0171rs");

        // MDI Frame...
        dictionary.setProperty("file", "Fjl");
        dictionary.setProperty("exit", "Kilps");
        dictionary.setProperty("filemnemonic", "F");
        dictionary.setProperty("exitmnemonic", "K");
        dictionary.setProperty("change user", "Felhasznl vlts");
        dictionary.setProperty("changeusermnemonic", "V");
        dictionary.setProperty("changelanguagemnemonic", "L");
        dictionary.setProperty("help", "Sg");
        dictionary.setProperty("about", "Nvjegy");
        dictionary.setProperty("helpmnemonic", "S");
        dictionary.setProperty("aboutmnemonic", "N");
        dictionary.setProperty("are you sure to quit application?", "Biztosan kilp?");
        dictionary.setProperty("quit application", "Kilps");
        dictionary.setProperty("forcegcmnemonic", "F");
        dictionary.setProperty("Force GC", "Tisztogats");
        dictionary.setProperty("Java Heap", "Java Heap");
        dictionary.setProperty("used", "hasznlt");
        dictionary.setProperty("allocated", "alloklva");
        dictionary.setProperty("change language", "Nyelv vlts");
        dictionary.setProperty("changemnemonic", "N");
        dictionary.setProperty("cancelmnemonic", "C");
        dictionary.setProperty("cancel", "Eldob");
        dictionary.setProperty("yes", "Igen");
        dictionary.setProperty("no", "Nem");
        dictionary.setProperty("Functions", "Funkcik");
        dictionary.setProperty("Error while executing function", "Hiba a funkci vgrehajtsa kzben");
        dictionary.setProperty("Error", "Hiba");
        dictionary.setProperty("infoPanel", "Info");
        dictionary.setProperty("imageButton", "Nvjegy");
        dictionary.setProperty("Window", "Ablak");
        dictionary.setProperty("windowmnemonic", "W");
        dictionary.setProperty("Close All", "Bezr mindent");
        dictionary.setProperty("closeallmnemonic", "A");
        dictionary.setProperty("Press ENTER to find function", "ENTER a funkci keresshez");
        dictionary.setProperty("Find Function", "Funkci keress");
        dictionary.setProperty("Operation in progress...", "Operci vgrehajts alatt...");
        dictionary.setProperty("close window", "Ablak bezrs");
        dictionary.setProperty("reduce to icon", "Ikonmret");
        dictionary.setProperty("save changes?", "Vltozsok elmentse?");
        dictionary.setProperty("confirm window closing", "Ablak bezrs meger\u0151stse");
        dictionary.setProperty("change background", "Httr csere");
        dictionary.setProperty("reset background", "Httr frissts");

        dictionary.setProperty("switch", "Vlts");
        dictionary.setProperty("switchmnemonic", "S");
        dictionary.setProperty("window name", "Ablak neve");
        dictionary.setProperty("opened windows", "Nyitott ablakok");
        dictionary.setProperty("tile horizontally", "Vzszintes elrendezs");
        dictionary.setProperty("tilehorizontallymnemonic", "H");
        dictionary.setProperty("tile vertically", "Fgg\u0151leges elrendezs");
        dictionary.setProperty("tileverticallymnemonic", "V");
        dictionary.setProperty("cascade", "Lezdul elrendezs");
        dictionary.setProperty("cascademnemonic", "C");
        dictionary.setProperty("minimize", "Kis mret");
        dictionary.setProperty("minimizemnemonic", "M");
        dictionary.setProperty("minimize all", "Mind kis mretre");
        dictionary.setProperty("minimizeallmnemonic", "A");

        // server...
        dictionary.setProperty("Client request not supported", "A krs kiszolglsa nem megvalstott");
        dictionary.setProperty("User disconnected", "Felhasznl kicpett");
        dictionary.setProperty("Updating not performed: the record was previously updated.", "A mdosts nem sikerlt: a rekordot el\u0151z\u0151leg mdostottk.");

        // wizard...
        dictionary.setProperty("back", "Vissza");
        dictionary.setProperty("next", "Kvetkez\u0151");
        dictionary.setProperty("finish", "Vge");

        // image panel...
        dictionary.setProperty("image selection", "Kp vlaszts");

        // tip of the day panel...
        dictionary.setProperty("show 'tip of the day' after launching", "Programindtskor napi tippek");
        dictionary.setProperty("previous tip", "El\u0151z\u0151 tipp");
        dictionary.setProperty("next tip", "Kvetkez\u0151 tipp");
        dictionary.setProperty("close", "Bezr");
        dictionary.setProperty("tip of the day", "Napi tippek");
        dictionary.setProperty("select tip", "Tipp kivlaszts");
        dictionary.setProperty("tip name", "Tipp neve");
        dictionary.setProperty("tips list", "Tippek listja");

        // progress panel...
        dictionary.setProperty("progress", "Folyamatban");

        // licence agreement...
        dictionary.setProperty("i accept the terms in the licence agreement", "Elfogadom a licensz-szerz\u0151dsben foglaltakat");
        dictionary.setProperty("ok", "Rendben");
        dictionary.setProperty("i do not accept the terms in the licence agreement", "Nem fogadom el a licensz-szerz\u0151dsben foglaltakat");

        // property grid control
        dictionary.setProperty("property name", "Nv");
        dictionary.setProperty("property value", "rtk");

        // grid profile
        dictionary.setProperty("grid profile management", "Tbla profil management");
        dictionary.setProperty("restore default grid profile", "Az alaprtelmezett tblaprofil visszatltse");
        dictionary.setProperty("create new grid profile", "j tblaprofil");
        dictionary.setProperty("profile description", "Profil lers");
        dictionary.setProperty("remove current grid profile", "Tblaprofil trlse");
        dictionary.setProperty("select grid profile", "Tblaprofil vlaszts");
        dictionary.setProperty("default profile", "Alaprtelmezett profil");

        // search box
        dictionary.setProperty("search", "Keress");
        dictionary.setProperty("not found", "Nem tallhat");

        // drag...
        dictionary.setProperty("drag", "Drag");

        // pivot table...
        dictionary.setProperty("pivot table settings", "Pivot tbla belltsok");
        dictionary.setProperty("row fields", "Sor mez\u0151k");
        dictionary.setProperty("column fields", "Oszlop mez\u0151k");
        dictionary.setProperty("data fields", "Adat mez\u0151k");
        dictionary.setProperty("filtering conditions", "Sz\u0171rsi felttelek");
        dictionary.setProperty("field", "Mez\u0151");
        dictionary.setProperty("checked", "Kijellt");
        dictionary.setProperty("at least one data field must be selected", "Minimum egy adat mez\u0151t ktelez\u0151 vlasztani.");
        dictionary.setProperty("at least one row field must be selected", "Minimum egy sor mez\u0151t ktelez\u0151 vlasztani.");
        dictionary.setProperty("at least one column field must be selected", "Minimum egy oszlop mez\u0151t ktelez\u0151 vlasztani.");
        dictionary.setProperty("expand all", "Felfedi mind");
        dictionary.setProperty("collapse all", "Elrejti mind");

        // LoginDialog
        dictionary.setProperty("Logon", "Bejelentkezs");
        dictionary.setProperty("Login", "Belps");
        dictionary.setProperty("L", "B");
        dictionary.setProperty("Exit", "Kilps");
        dictionary.setProperty("E", "K");
        dictionary.setProperty("store account", "Elmentsk a felhasznlt");
        dictionary.setProperty("Username", "Felhasznl");
        dictionary.setProperty("Password", "Jelsz");

        resources = new Resources(
                dictionary,
                currencySymbol,
                '.',
                ',',
                Resources.YMD,
                true,
                dateFormatSeparator,
                "HH:mm",
                "HU",
                showResourceNotFoundWarning);
    }

    /**
     * @return internationalization settings, according with the current language
     */
    public final Resources getResources() {
        return resources;
    }

    /**
     * Load dictionary, according to the specified language id.
     * @param langId language id identifier
     */
    public final void setLanguage(String langId) throws UnsupportedOperationException {
        if (!resources.getLanguageId().equals(langId)) {
            throw new UnsupportedOperationException("Nem tmogatott nyelv.");
        }
    }

    /**
     * @param langId language id identifier
     * @return internationalization settings, according with the language specified
     */
    public final Resources getResources(String langId) throws UnsupportedOperationException {
        if (!resources.getLanguageId().equals(langId)) {
            throw new UnsupportedOperationException("Nem tmogatott nyelv.");
        }
        return resources;
    }
}
