package org.openswing.swing.message.send.java;

import java.io.*;
import java.util.*;



/**
 * <p>Title: OpenSwing Framework</p>
 * <p>Description: Parameters generated by the grid when fetching data.</p>
 * <p>Copyright: Copyright (C) 2006 Mauro Carniel</p>
 *
 * <p> This file is part of OpenSwing Framework.
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the (LGPL) Lesser General Public
 * License as published by the Free Software Foundation;
 *
 *                GNU LESSER GENERAL PUBLIC LICENSE
 *                 Version 2.1, February 1999
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *       The author may be contacted at:
 *           maurocarniel@tin.it</p>
 *
 * @author Mauro Carniel
 * @version 1.0
 */
public class GridParams implements Serializable {

  /** fetch previous block of rows */
  public static final int PREVIOUS_BLOCK_ACTION = 0;

  /** fetch next block of rows */
  public static final int NEXT_BLOCK_ACTION = 1;

  /** fetch last block of rows */
  public static final int LAST_BLOCK_ACTION = 2;

  /** filtered columns; collection of pairs: attributeName, FilterWhereClause[2] */
  private Map filteredColumns = null;

  /** sorted columns */
  private ArrayList currentSortedColumns = new ArrayList();

  /** ordering versus of sorted columns */
  private ArrayList currentSortedVersusColumns = new ArrayList();

  /** other grid parameters */
  private Map otherGridParams = null;

  /** fetching versus: PREVIOUS_BLOCK_ACTION, NEXT_BLOCK_ACTION or LAST_BLOCK_ACTION */
  private int action;

  /** start position of data fetching in result set */
  private int startPos;


  /**
   * Void constructor.
   */
  public GridParams() {
    this(GridParams.NEXT_BLOCK_ACTION,0,new HashMap(),new ArrayList(),new ArrayList(),new HashMap());
  }


  /**
   * @param action fetching versus: PREVIOUS_BLOCK_ACTION, NEXT_BLOCK_ACTION or LAST_BLOCK_ACTION
   * @param startPos start position of data fetching in result set
   * @param filteredColumns  filtered columns; collection of pairs: attributeName, FilterWhereClause[2]
   * @param currentSortedColumns sorted columns
   * @param currentSortedVersusColumns ordering versus of sorted columns
   * @param valueObjectType
   * @param otherGridParams other grid parameters
   */
  public GridParams(
      int action,
      int startPos,
      Map filteredColumns,
      ArrayList currentSortedColumns,
      ArrayList currentSortedVersusColumns,
      Map otherGridParams
  ) {
    this.action = action;
    this.startPos = startPos;
    this.filteredColumns = filteredColumns;
    this.currentSortedColumns = currentSortedColumns;
    this.currentSortedVersusColumns = currentSortedVersusColumns;
    this.otherGridParams = otherGridParams;
  }


  /**
   * @return sorted columns
   */
  public final ArrayList getCurrentSortedColumns() {
    return currentSortedColumns;
  }

  /**
   * @return ordering versus of sorted columns
   */
  public final ArrayList getCurrentSortedVersusColumns() {
    return currentSortedVersusColumns;
  }


  /**
   * Set sorted columns.
   * @param currentSortedColumns sorted columns
   */
  public final void setCurrentSortedColumns(ArrayList currentSortedColumns) {
    this.currentSortedColumns = currentSortedColumns;
  }


  /**
   * Set ordering versus of sorted columns.
   * @param currentSortedVersusColumns ordering versus of sorted columns
   */
  public final void setCurrentSortedVersusColumns(ArrayList currentSortedVersusColumns) {
    this.currentSortedVersusColumns = currentSortedVersusColumns;
  }


  /**
   * @return other grid parameters
   */
  public final Map getOtherGridParams() {
    return otherGridParams;
  }


  /**
   * @return start position of data fetching in result set
   */
  public final int getStartPos() {
    return startPos;
  }


  /**
   * @return fetching versus: PREVIOUS_BLOCK_ACTION, NEXT_BLOCK_ACTION or LAST_BLOCK_ACTION
   */
  public final int getAction() {
    return action;
  }


  /**
   * @return filteredColumns; collection of pairs: attributeName, FilterWhereClause[2]
   */
  public final Map getFilteredColumns() {
    return filteredColumns;
  }



}
