package org.jallinone.commons.java;

import java.math.BigDecimal;


/**
 * <p>Title: JAllInOne ERP/CRM application</p>
 * <p>Description: Application constants.</p>
 * <p>Copyright: Copyright (C) 2006 Mauro Carniel</p>
 *
 * <p> This file is part of JAllInOne ERP/CRM application.
 * This application is free software; you can redistribute it and/or
 * modify it under the terms of the (LGPL) Lesser General Public
 * License as published by the Free Software Foundation;
 *
 *                GNU LESSER GENERAL PUBLIC LICENSE
 *                 Version 2.1, February 1999
 *
 * This application is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *       The author may be contacted at:
 *           maurocarniel@tin.it</p>
 *
 * @author Mauro Carniel
 * @version 1.0
 */
public class ApplicationConsts {

  public static final String DB_VERSION = "0.9.0.7";

  public static final String DO_NOT_ADD_ENABLED = "DO_NOT_ADD_ENABLED";

  public static final String START_DATE = "START_DATE";
  public static final String END_DATE = "END_DATE";
  public static final String PAYED = "PAYED";
  public static final String LOAD_ALL = "LOAD_ALL";
  public static final String LOAD_ONLY_CURRENT_LEVEL = "LOAD_ONLY_CURRENT_LEVEL";
  public static final String QUERY_INFO = "QUERY_INFO";
  public static final String CODE = "CODE";
  public static final String WHERE_VALUES = "WHERE_VALUES";

  public static final String DOC_PATH = "DOC_PATH";
  public static final String IMAGE_PATH = "IMAGE_PATH";
  public static final String TREE_FILTER = "TREE_FILTER";
  public static final String DATE_FILTER = "DATE_FILTER";
  public static final String PROPERTIES_FILTER = "PROPERTIES_FILTER";

  public static final String TASK_CODE_REG07 = "TASK_CODE_REG07";
  public static final String PROGRESSIVE_SYS04 = "PROGRESSIVE_SYS04";
  public static final String FUNCTION_CODE_SYS06 = "FUNCTION_CODE_SYS06";
  public static final String CUSTOMER_CODE = "CUSTOMER_CODE";
  public static final String SUPPLIER_CODE = "SUPPLIER_CODE";
  public static final String RECEIPT_PATH = "RECEIPT_PATH";

  public static final String CREDITS_ACCOUNT = "CREDITS_ACCOUNT";
  public static final String ITEMS_ACCOUNT = "ITEMS_ACCOUNT";
  public static final String ACTIVITIES_ACCOUNT = "ACTIVITIES_ACCOUNT";
  public static final String CHARGES_ACCOUNT = "CHARGES_ACCOUNT";
  public static final String DEBITS_ACCOUNT = "DEBITS_ACCOUNT";
  public static final String COSTS_ACCOUNT = "COSTS_ACCOUNT";
  public static final String CASE_ACCOUNT = "CASE_ACCOUNT";
  public static final String BANK_ACCOUNT = "BANK_ACCOUNT";
  public static final String VAT_ENDORSE_ACCOUNT = "VAT_ENDORSE_ACCOUNT";
  public static final String LOSSPROFIT_E_ACCOUNT = "LOSSPROFIT_E_ACCOUNT";
  public static final String LOSSPROFIT_P_ACCOUNT = "LOSSPROFIT_P_ACCOUNT";
  public static final String CLOSING_ACCOUNT = "CLOSING_ACCOUNT";
  public static final String OPENING_ACCOUNT = "OPENING_ACCOUNT";

  public static final String MORNING_START_HOUR = "MORNING_START_HOUR";
  public static final String AFTERNOON_START_HOUR = "AFTERNOON_START_HOUR";
  public static final String MORNING_END_HOUR = "MORNING_END_HOUR";
  public static final String AFTERNOON_END_HOUR = "AFTERNOON_END_HOUR";

  public static final String SALE_SECTIONAL = "SALE_SECTIONAL";

  public static final String CREDITS_ACCOUNT_VALUE = "020.010";
  public static final String ITEMS_ACCOUNT_VALUE = "200.010";
  public static final String ACTIVITIES_ACCOUNT_VALUE = "200.020";
  public static final String CHARGES_ACCOUNT_VALUE = "200.030";
  public static final String DEBITS_ACCOUNT_VALUE = "080.010";
  public static final String COSTS_ACCOUNT_VALUE = "140.010";
  public static final String CASE_ACCOUNT_VALUE = "010.010";
  public static final String BANK_ACCOUNT_VALUE = "010.020";
  public static final String VAT_ENDORSE_ACCOUNT_VALUE = "050.010";
  public static final String LOSSPROFIT_E_ACCOUNT_VALUE = "210.010";
  public static final String LOSSPROFIT_P_ACCOUNT_VALUE = "130.010";
  public static final String CLOSING_ACCOUNT_VALUE = "220.020";
  public static final String OPENING_ACCOUNT_VALUE = "220.010";


  public static final String USERNAME_SYS03 = "USERNAME_SYS03";
  public static final String NAME_1 = "NAME_1";
  public static final String NAME_2 = "NAME_2";

  public static final String PROGRESSIVE_SYS13 = "PROGRESSIVE_SYS13";
  public static final String TABLE_NAME_SYS13 = "TABLE_NAME_SYS13";

  public static final String CURRENCY_CODE_REG03 = "CURRENCY_CODE_REG03";

  public static final String UM_CODE_REG02 = "UM_CODE_REG02";

  public static final String PAYMENT_CODE_REG10 = "PAYMENT_CODE_REG10";

  public static final String SCHEDULED_EMPLOYEE = "SCHEDULED_EMPLOYEE";
  public static final String SCHEDULED_ACTIVITY_PK = "SCHEDULED_ACTIVITY_PK";
  public static final String CALL_OUT_REQUEST_PK = "CALL_OUT_REQUEST_PK";
  public static final String CALL_OUT_PK = "CALL_OUT_PK";
  public static final String ITEM_PK = "ITEM_PK";
  public static final String SUBJECT_PK = "SUBJECT_PK";
  public static final String SUBJECT_VO = "SUBJECT_VO";
  public static final String PURCHASE_DOC_PK = "PURCHASE_DOC_PK";
  public static final String PURCHASE_DOC_VO = "PURCHASE_DOC_VO";
  public static final String PURCHASE_DOC_ROW_PK = "PURCHASE_DOC_ROW_PK";
  public static final String PURCHASE_DOC_ROW_VO = "PURCHASE_DOC_ROW_VO";
  public static final String SALE_DOC_PK = "SALE_DOC_PK";
  public static final String SALE_DOC_VO = "SALE_DOC_VO";
  public static final String DELIVERY_NOTE_PK = "DELIVERY_NOTE_PK";
  public static final String WAREHOUSE_CODE = "WAREHOUSE_CODE";
  public static final String SALE_DOC_ROW_PK = "SALE_DOC_ROW_PK";
  public static final String SALE_DOC_ROW_VO = "SALE_DOC_ROW_VO";
  public static final String DOCUMENT_PK = "DOCUMENT_PK";
  public static final String DOCUMENT = "DOCUMENT";
  public static final String PROD_ORDER_PK = "PROD_ORDER_PK";

  public static final String SUBJECT_TYPE = "SUBJECT_TYPE";
  public static final String FUCTION_CODE = "FUCTION_CODE";

  public static final String MANUFACTURE_VO = "MANUFACTURE_VO";
  public static final String INTERNAL_MANUFACTURE = "I";
  public static final String EXTERNAL_MANUFACTURE = "E";

  public static final String SUBJECT_MY_COMPANY = "M";
  public static final String SUBJECT_PEOPLE_CUSTOMER = "P";
  public static final String SUBJECT_ORGANIZATION_CUSTOMER = "C";
  public static final String SUBJECT_SUPPLIER = "S";
  public static final String SUBJECT_ORGANIZATION_CONTACT = "O";
  public static final String SUBJECT_PEOPLE_CONTACT = "N";
  public static final String SUBJECT_EMPLOYEE = "E";

  public static final String SUBJECT_ORGANIZATION = "A";
  public static final String SUBJECT_PEOPLE = "B";

  public static final String PRIORITY_HIGHEST = "V";
  public static final String PRIORITY_HIGH = "H";
  public static final String PRIORITY_NORMAL = "N";
  public static final String PRIORITY_LOW = "L";
  public static final String PRIORITY_TRIVIAL = "T";

  public static final String ACTIVITY_STATE  = "ACTIVITY_STATE";
  public static final String ACTIVITY_TYPE  = "ACTIVITY_TYPE";
  public static final String ACT_GENERIC_TASK  = "T";
  public static final String ACT_APPOINTMENT  = "A";
  public static final String ACT_CALL_OUT  = "C";
  public static final String ACT_SEND_EMAIL  = "E";
  public static final String ACT_SEND_FAX  = "F";
  public static final String ACT_MEETING  = "M";
  public static final String ACT_PHONE_CALL  = "P";
  public static final String ACT_ABSENCE  = "B";
  public static final String ACT_HOLIDAY  = "H";
  public static final String ACT_ILLNESS  = "I";

  public static final String PROGRESSIVE_REG04_MANAGER = "PROGRESSIVE_REG04_MANAGER";
  public static final String PROGRESSIVE_REG04_SUBJECT = "PROGRESSIVE_REG04_SUBJECT";
  public static final String PROGRESSIVE_REG04 = "PROGRESSIVE_REG04";
  public static final String PROGRESSIVE_HIE02 = "PROGRESSIVE_HIE02";
  public static final String PROGRESSIVE_HIE01 = "PROGRESSIVE_HIE01";
  public static final String ROOT_PROGRESSIVE_HIE01 = "ROOT_PROGRESSIVE_HIE01";
  public static final String LOAD_ANCIENTS = "LOAD_ANCIENTS";
  public static final String COMPANY_CODE_SYS01 = "COMPANY_CODE_SYS01";
  public static final String PRICELIST = "PRICELIST";
  public static final String ITEM = "ITEM";
  public static final String ACTIVITY_CODE = "ACTIVITY_CODE";
  public static final String PARAM_CODE = "PARAM_CODE";
  public static final String PARAM_VALUE = "PARAM_VALUE";
  public static final String LEDGER_CODE = "LEDGER_CODE";
  public static final String PRODUCTS_ONLY = "PRODUCTS_ONLY";
  public static final String COMPONENTS_ONLY = "COMPONENTS_ONLY";
  public static final String PRODUCTS = "PRODUCTS";

  public static final BigDecimal ID_CONTACT_GRID = new BigDecimal(522);
  public static final BigDecimal ID_CUSTOMER_GRID = new BigDecimal(282);
  public static final BigDecimal ID_HIERAR_SUBJECTS_GRID = new BigDecimal(1042);
  public static final BigDecimal ID_HIERAR_EMPLOYEES_GRID = new BigDecimal(1072);
  public static final BigDecimal ID_ITEMS_GRID = new BigDecimal(262);
  public static final BigDecimal ID_SUPPLIER_GRID = new BigDecimal(412);
  public static final BigDecimal ID_SUPPLIER_ITEMS_GRID = new BigDecimal(962);
  public static final BigDecimal ID_UM_GRID = new BigDecimal(172);
  public static final BigDecimal ID_SUPPLIER_PRICELIST_GRID = new BigDecimal(972);
  public static final BigDecimal ID_PURCHASE_ORDER = new BigDecimal(422);
  public static final BigDecimal ID_WAREHOUSE_MOTIVE = new BigDecimal(442);
  public static final BigDecimal ID_SALE_ORDER = new BigDecimal(322);
  public static final BigDecimal ID_SALE_ACTIVITIES = new BigDecimal(392);
  public static final BigDecimal ID_SALE_CONTRACT = new BigDecimal(332);
  public static final BigDecimal ID_SALE_ESTIMATE = new BigDecimal(852);
  public static final BigDecimal ID_SALE_DESK = new BigDecimal(352);
  public static final BigDecimal ID_SALE_INVOICE = new BigDecimal(352);
  public static final BigDecimal ID_SALE_INVOICE_FROM_DN = new BigDecimal(352);
  public static final BigDecimal ID_SALE_INVOICE_FROM_SD = new BigDecimal(352);
  public static final BigDecimal ID_TRANSPORT_MOTIVES = new BigDecimal(1282);
  public static final BigDecimal ID_LEDGER = new BigDecimal(1302);
  public static final BigDecimal ID_ACCOUNTS = new BigDecimal(1312);
  public static final BigDecimal ID_ACCOUNTING_MOTIVES = new BigDecimal(1322);
  public static final BigDecimal ID_VAT_REGISTERS = new BigDecimal(1332);
  public static final BigDecimal ID_SCHEDULED_ACTIVITIES = new BigDecimal(572);
  public static final BigDecimal ID_CALL_OUTS = new BigDecimal(3222);
  public static final BigDecimal ID_CALL_OUT_REQUESTS = new BigDecimal(3232);
  public static final BigDecimal ID_MACHINERIES = new BigDecimal(602);
  public static final BigDecimal ID_DOCUMENT = new BigDecimal(712);
  public static final BigDecimal ID_MANUFACTURE = new BigDecimal(592);
  public static final BigDecimal ID_MANUFACTURE_PHASE = new BigDecimal(1032);
  public static final BigDecimal ID_PROD_ORDER = new BigDecimal(3282);


  public static final String DISCOUNT_CUSTOMER = "C";
  public static final String DISCOUNT_CUSTOMER_HIERARCHY = "H";
  public static final String DISCOUNT_ITEM = "I";
  public static final String DISCOUNT_ITEM_HIERARCHY = "R";

  public static final String FILTER_COMPANY_FOR_INSERT = "FILTER_COMPANY_FOR_INSERT";

  public static final String PURCHASE_ORDER_DOC_TYPE = "P";
  public static final String PURCHASE_INVOICE_DOC_TYPE = "V";
  public static final String PURCHASE_GENERIC_INVOICE = "H";
  public static final String PURCHASE_INVOICE_FROM_DN_DOC_TYPE = "L";
  public static final String PURCHASE_INVOICE_FROM_PD_DOC_TYPE = "U";
  public static final String PURCHASE_DEBIT_NOTE_DOC_TYPE = "B";

  public static final String IN_DELIVERY_NOTE_DOC_TYPE = "I";
  public static final String OUT_DELIVERY_NOTE_DOC_TYPE = "O";

  public static final String SALE_ORDER_DOC_TYPE = "O";
  public static final String SALE_CONTRACT_DOC_TYPE = "C";
  public static final String SALE_ESTIMATE_DOC_TYPE = "E";
  public static final String SALE_DESK_DOC_TYPE = "D";
  public static final String SALE_INVOICE_DOC_TYPE = "I";
  public static final String SALE_GENERIC_INVOICE = "A"; // used in the filter of the expiration frame
  public static final String SALE_INVOICE_FROM_DN_DOC_TYPE = "N";
  public static final String SALE_INVOICE_FROM_SD_DOC_TYPE = "S";
  public static final String SALE_CREDIT_NOTE_DOC_TYPE = "R";


  public static final String DOC_TYPE = "DOC_TYPE";
  public static final String DOC_STATE = "DOC_STATE";
  public static final String DOC_YEAR = "DOC_YEAR";

  public static final String OPENED = "O";
  public static final String HEADER_BLOCKED = "B";
  public static final String CONFIRMED = "C";
  public static final String CLOSED = "D";
  public static final String INVOICED = "I";

  public static final String QTY_SIGN_PLUS = "+";
  public static final String QTY_SIGN_MINUS = "-";
  public static final String ITEM_GOOD = "G";
  public static final String ITEM_DAMAGED = "D";

  public static final String WAREHOUSE_MOTIVE_LOAD_BY_ORDER = "L";
  public static final String WAREHOUSE_MOTIVE_UNLOAD_BY_ORDER = "U";
  public static final String WAREHOUSE_MOTIVE_UNLOAD_BY_CONTRACT = "C";
  public static final String WAREHOUSE_MOTIVE_DIRECTLY_UNLOAD = "D";
  public static final String WAREHOUSE_MOTIVE_UNLOAD_BY_PRODUCTION = "P";
  public static final String WAREHOUSE_MOTIVE_LOAD_BY_PRODUCTION = "R";

  public static final String START_DAY_END_MONTH = "M";
  public static final String START_DAY_INVOICE_DATE = "I";

  public static final String EXPORT_PARAMS = "EXPORT_PARAMS";
  public static final String EXPORT_FORMAT = "EXPORT_FORMAT";
  public static final String PDF_FORMAT = "PDF_FORMAT";
  public static final String RTF_FORMAT = "RTF_FORMAT";
  public static final String HTML_FORMAT = "HTML_FORMAT";
  public static final String XLS_FORMAT = "XLS_FORMAT";
  public static final String CSV_FORMAT = "CSV_FORMAT";
  public static final String XML_FORMAT = "XML_FORMAT";

  public static final String PATRIMONIAL_ACCOUNT = "P";
  public static final String ECONOMIC_ACCOUNT = "E";

  public static final String VAT_REGISTER_SELLING = "1";
  public static final String VAT_REGISTER_RETAIL = "2";
  public static final String VAT_REGISTER_PURCHASE = "3";
  public static final String VAT_REGISTER_INTRA_SELLING = "4";
  public static final String VAT_REGISTER_INTRA_PURCHASE = "5";

  public static final String DEBIT_ACCOUNT = "D";
  public static final String CREDIT_ACCOUNT = "C";

  public static final String MOTIVE_SALE_INVOICE = "001";
  public static final String MOTIVE_SALE_RETAIL = "002";
  public static final String MOTIVE_PURCHASE_INVOICE = "003";
  public static final String MOTIVE_INVOICE_PROCEEDS = "110";
  public static final String MOTIVE_SALE_RETAIL_PROCEEDS = "008";
  public static final String MOTIVE_ACCOUNTS_OPENING = "009";
  public static final String MOTIVE_VAT_ENDORSING = "138";
  public static final String MOTIVE_PURCHASE_INVOICE_PAYED = "120";
  public static final String MOTIVE_LOSS_PROFIT_ENDORSING = "032";
  public static final String MOTIVE_LOSS_ENDORSING = "031";
  public static final String MOTIVE_PROFIT_ENDORSING = "030";
  public static final String MOTIVE_ACCOUNTS_CLOSING = "033";

  public static final String ACCOUNT_TYPE_ACCOUNT = "A";
  public static final String ACCOUNT_TYPE_CUSTOMER = "C";
  public static final String ACCOUNT_TYPE_SUPPLIER = "S";

  public static final String TYPE_TEXT = "T";
  public static final String TYPE_NUM = "N";
  public static final String TYPE_DATE = "D";
  public static final String TYPE_ENUM = "E";
  public static final String TYPE_PROG = "P";
  public static final String TYPE_WHERE = "W";

}
