package org.jallinone.warehouse.documents.server;

import org.openswing.swing.server.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import org.openswing.swing.message.receive.java.*;
import java.sql.*;
import org.openswing.swing.logger.server.Logger;
import org.jallinone.warehouse.documents.java.*;
import org.jallinone.system.server.JAIOUserSessionParameters;
import java.math.BigDecimal;
import org.jallinone.events.server.EventsManager;
import org.jallinone.events.server.GenericEvent;


/**
 * <p>Title: JAllInOne ERP/CRM application</p>
 * <p>Description: Action class used to (phisically) delete existing out delivery rows.</p>
 * <p>Copyright: Copyright (C) 2006 Mauro Carniel</p>
 *
 * <p> This file is part of JAllInOne ERP/CRM application.
 * This application is free software; you can redistribute it and/or
 * modify it under the terms of the (LGPL) Lesser General Public
 * License as published by the Free Software Foundation;
 *
 *                GNU LESSER GENERAL PUBLIC LICENSE
 *                 Version 2.1, February 1999
 *
 * This application is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *       The author may be contacted at:
 *           maurocarniel@tin.it</p>
 *
 * @author Mauro Carniel
 * @version 1.0
 */
public class DeleteOutDeliveryNoteRowsAction implements Action {

  private InsertOutSerialNumbersBean serialNumBean = new InsertOutSerialNumbersBean();


  public DeleteOutDeliveryNoteRowsAction() {
  }

  /**
   * @return request name
   */
  public final String getRequestName() {
    return "deleteOutDeliveryNoteRows";
  }


  /**
   * Business logic to execute.
   */
  public final Response executeCommand(Object inputPar,UserSessionParameters userSessionPars,HttpServletRequest request, HttpServletResponse response,HttpSession userSession,ServletContext context) {
    Connection conn = null;
    PreparedStatement pstmt = null;
    PreparedStatement pstmt2 = null;
    try {
      conn = ConnectionManager.getConnection(context);

      // fires the GenericEvent.CONNECTION_CREATED event...
      EventsManager.getInstance().processEvent(new GenericEvent(
        this,
        getRequestName(),
        GenericEvent.CONNECTION_CREATED,
        (JAIOUserSessionParameters)userSessionPars,
        request,
        response,
        userSession,
        context,
        conn,
        inputPar,
        null
      ));

      java.util.List list = (ArrayList)inputPar;
      OutDeliveryNoteRowPK rowPK = null;

      pstmt = conn.prepareStatement(
          "delete from DOC10_OUT_DELIVERY_NOTE_ITEMS where COMPANY_CODE_SYS01=? and DOC_TYPE=? and DOC_YEAR=? and DOC_NUMBER=? and DOC_TYPE_DOC01=? and DOC_YEAR_DOC01=? and DOC_NUMBER_DOC01=? and ROW_NUMBER=? and ITEM_CODE_ITM01=?"
      );

      pstmt2 = conn.prepareStatement(
       "delete from DOC12_OUT_SERIAL_NUMBERS where "+
       "COMPANY_CODE_SYS01=? and "+
       "DOC_TYPE=? and "+
       "DOC_YEAR=? and "+
       "DOC_NUMBER=? and "+
       "DOC_TYPE_DOC01=? and "+
       "DOC_YEAR_DOC01=? and "+
       "DOC_NUMBER_DOC01=? and "+
       "ROW_NUMBER=? and "+
       "ITEM_CODE_ITM01=?"
      );

      Response res = null;
      for(int i=0;i<list.size();i++) {
        rowPK = (OutDeliveryNoteRowPK)list.get(i);

        // delete previous serial numbers from DOC11...
        pstmt2.setString(1,rowPK.getCompanyCodeSys01DOC10());
        pstmt2.setString(2,rowPK.getDocTypeDOC10());
        pstmt2.setBigDecimal(3,rowPK.getDocYearDOC10());
        pstmt2.setBigDecimal(4,rowPK.getDocNumberDOC10());
        pstmt2.setString(5,rowPK.getDocTypeDoc01DOC10());
        pstmt2.setBigDecimal(6,rowPK.getDocYearDoc01DOC10());
        pstmt2.setBigDecimal(7,rowPK.getDocNumberDoc01DOC10());
        pstmt2.setBigDecimal(8,rowPK.getRowNumberDOC10());
        pstmt2.setString(9,rowPK.getItemCodeItm01DOC10());
        pstmt2.execute();
        pstmt2.close();

        // phisically delete the record in DOC10...
        pstmt.setString(1,rowPK.getCompanyCodeSys01DOC10());
        pstmt.setString(2,rowPK.getDocTypeDOC10());
        pstmt.setBigDecimal(3,rowPK.getDocYearDOC10());
        pstmt.setBigDecimal(4,rowPK.getDocNumberDOC10());
        pstmt.setString(5,rowPK.getDocTypeDoc01DOC10());
        pstmt.setBigDecimal(6,rowPK.getDocYearDoc01DOC10());
        pstmt.setBigDecimal(7,rowPK.getDocNumberDoc01DOC10());
        pstmt.setBigDecimal(8,rowPK.getRowNumberDOC10());
        pstmt.setString(9,rowPK.getItemCodeItm01DOC10());
        pstmt.execute();
      }

      Response answer =  new VOResponse(new Boolean(true));

      // fires the GenericEvent.BEFORE_COMMIT event...
      EventsManager.getInstance().processEvent(new GenericEvent(
        this,
        getRequestName(),
        GenericEvent.BEFORE_COMMIT,
        (JAIOUserSessionParameters)userSessionPars,
        request,
        response,
        userSession,
        context,
        conn,
        inputPar,
        answer
      ));

      conn.commit();

      // fires the GenericEvent.AFTER_COMMIT event...
      EventsManager.getInstance().processEvent(new GenericEvent(
        this,
        getRequestName(),
        GenericEvent.AFTER_COMMIT,
        (JAIOUserSessionParameters)userSessionPars,
        request,
        response,
        userSession,
        context,
        conn,
        inputPar,
        answer
      ));

      return answer;
    }
    catch (Throwable ex) {
      Logger.error(userSessionPars.getUsername(),this.getClass().getName(),"executeCommand","Error while deleting existing out delivery note rows",ex);
      try {
        conn.rollback();
      }
      catch (Exception ex3) {
      }
      return new ErrorResponse(ex.getMessage());
    }
    finally {
      try {
        pstmt.close();
      }
      catch (Exception ex2) {
      }
      try {
        pstmt2.close();
      }
      catch (Exception ex2) {
      }
      try {
        ConnectionManager.releaseConnection(conn, context);
      }
      catch (Exception ex1) {
      }
    }

  }



}
