package org.openswing.swing.form.model.client;

import java.util.EventObject;


/**
 * <p>Title: OpenSwing Framework</p>
 * <p>Description: Form controller, used to listener events generated by the Form panel and to execute operations related to the form (for example loading data).</p>
 * <p>Copyright: Copyright (C) 2006 Mauro Carniel</p>
 *
 * <p> This file is part of OpenSwing Framework.
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the (LGPL) Lesser General Public
 * License as published by the Free Software Foundation;
 *
 *                GNU LESSER GENERAL PUBLIC LICENSE
 *                 Version 2.1, February 1999
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *       The author may be contacted at:
 *           maurocarniel@tin.it</p>
 *
 * @author Mauro Carniel
 * @version 1.0
 */
public class ValueChangeEvent extends EventObject {

  /** attribute name */
  private String attributeName = null;

  /** old attribute value */
  private Object oldValue = null;

  /** new attribute value */
  private Object newValue = null;


  /**
   * Value change event for the specified value object attribute name.
   * @param source source component
   * @param attributeName attribute name in the vlaue object
   * @param oldValue old attribute value
   * @param newValue new attribute value
   */
  public ValueChangeEvent(Object source,String attributeName,Object oldValue,Object newValue) {
    super(source);
    this.attributeName = attributeName;
    this.oldValue = oldValue;
    this.newValue = newValue;
  }


  /**
   * @return attribute name in the vlaue object
   */
  public final String getAttributeName() {
      return attributeName;
  }


  /**
   * @return old attribute value
   */
  public final Object getNewValue() {
    return newValue;
  }


  /**
   * @return new attribute value
   */
  public final Object getOldValue() {
    return oldValue;
  }

}
