package org.openswing.swing.message.send.java;

import java.io.*;



/**
 * <p>Title: OpenSwing Framework</p>
 * <p>Description: Generic reuqest message generated by the client and sent to the server side.</p>
 * <p>Copyright: Copyright (C) 2006 Mauro Carniel</p>
 *
 * <p> This file is part of OpenSwing Framework.
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the (LGPL) Lesser General Public
 * License as published by the Free Software Foundation;
 *
 *                GNU LESSER GENERAL PUBLIC LICENSE
 *                 Version 2.1, February 1999
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *       The author may be contacted at:
 *           maurocarniel@tin.it</p>
 *
 * @author Mauro Carniel
 * @version 1.0
 */
public class Command implements Serializable {

  /** server method name to invoke */
  private String methodName = null;

  /** generic parameter object to pass to the server side method */
  private Object inputParam = null;

  /** client identifier, used on the server side to identify the client */
  private String sessionId = null;


  /**
   * Costructor.
   * @param sessionId client identifier, used on the server side to identify the client
   * @param methodName server method name to invoke
   * @param inputParam generic parameter object to pass to the server side method
   */
  public Command(String sessionId,String methodName,Object inputParam) {
    this.sessionId = sessionId;
    this.methodName = methodName;
    this.inputParam = inputParam;
  }


  /**
   * @return server method name to invoke
   */
  public final String getMethodName() {
    return methodName;
  }


  /**
   * @return generic parameter object to pass to the server side method
   */
  public final Object getInputParam() {
    return inputParam;
  }


  /**
   * @return client identifier, used on the server side to identify the client
   */
  public final String getSessionId() {
    return sessionId;
  }


}
