package sellwin.db;

import java.text.*;
import sellwin.utils.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * some simple routines to format java dates into
 * Oracle 8 or MYSQL compliant date and date-time strings
 * for use in building SQL statements in Java
 */
public class DateUtils {
    private static SimpleDateFormat mysqlFormatter = 
		new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat mysqlDateTimeFormatter = 
		new SimpleDateFormat("yyyy-MM-dd HH:mm");

    private static SimpleDateFormat oracleFormatter = 
		new SimpleDateFormat("dd-MMM-yy");
    private static SimpleDateFormat oracleDateTimeFormatter = 
		new SimpleDateFormat("dd-MMM-yyyy HH:mm");

	/**
	 * build a string in 'dd-mmm-yy' format using
	 * a Java date
	 * @param dt the java.util.Date to convert
	 * @return the formatted String
	 */
	public static String format(int DB_TYPE, java.util.Date dt) {
		if (DB_TYPE == Prefs.ORACLE)
			return oracleFormatter.format(dt);
		else
			return mysqlFormatter.format(dt);
	}

	/**
	 * build a formatted string that contains an
	 * Oracle date-time compliant string
	 *  e.g. insert into junk values (to_date('01-may-01 18:19', 'dd-mon-YY hh24:mi'));
	 * @param dt the Date to convert
	 * @return  the formatted String
	 */
	public static String formatDateTime(int DB_TYPE, java.util.Date dt) {
		if (DB_TYPE == Prefs.ORACLE)
			return "to_date('" + oracleDateTimeFormatter.format(dt) + "','dd-mon-yyyy hh24:mi')";
		else
			return "'" + mysqlDateTimeFormatter.format(dt) + "'";
	}
}
