package sellwin.db;

import sellwin.domain.*;
import sellwin.utils.*;

import java.sql.*;
import java.util.ArrayList;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class implements the DBInterface for
 * the Forecast class objects which are stored
 * in the forecast database table.
 */
public class ForecastDB extends DBType implements DBInterface {
	private Connection con;

	private final static String deleteQuery =
		"DELETE FROM forecast WHERE pk = ";

	private final static String deleteOppRowsQuery =
		"DELETE FROM forecast WHERE opp_pk = ";

	private final static String insertQuery =
		"INSERT INTO forecast " +
		"VALUES (";

	private final static String updateQuery =
		"UPDATE forecast SET " ;

	private final static String selectQuery =
			"SELECT "+
    		"opp_pk," +
    		"name," +
    		"close_date," +
    		"submitted," + "submitted_date," + "submitted_by," +
    		"revenue," +
    		"profit," +
    		"margin," +
    		"scenario," +
    		"amount_jan," + "amount_feb," + "amount_mar," + "q1," + 
			"amount_apr," + "amount_may," + "amount_jun," + "q2," + 
			"amount_jul," + "amount_aug," + "amount_sep," + "q3," + 
			"amount_oct," + "amount_nov," + "amount_dec," + "q4," + 
  			"modified_by, modified_date " +
			"FROM forecast "+
			"WHERE pk = ";

	private final static String selectForOppQuery =
			"SELECT "+
    		"pk," +
    		"name," +
    		"close_date," +
    		"submitted," + "submitted_date," + "submitted_by," +
    		"revenue," +
    		"profit," +
    		"margin," +
    		"scenario," +
    		"amount_jan," + "amount_feb," + "amount_mar," + "q1," + 
			"amount_apr," + "amount_may," + "amount_jun," + "q2," + 
			"amount_jul," + "amount_aug," + "amount_sep," + "q3," + 
			"amount_oct," + "amount_nov," + "amount_dec," + "q4," + 
  			"modified_by, modified_date " +
			"FROM forecast "+
			"WHERE opp_pk = ";

	/**
	 * a do-nothing constructor but necessary to
	 * do the operations offered by this class
	 */
	public ForecastDB() {
	}

	/**
	 * construct using a particular db type
	 * @param dbType the db type
	 */
	public ForecastDB(int dbType) {
		DB_TYPE = dbType;
	}

	/**
	 * a version of the constructor when a connection
	 * is already obtained from somewhere else
	 *
	 * @param con the Connection to use 
	 */
	public ForecastDB(Connection con) {
		this.con = con;
	}

	/**
	 * return the Connection in use
	 *
	 * @return the Connection in use
	 */
	public Connection getConnection() {
		return this.con;
	}

	/**
	 * set the Connection to use 
	 *
	 * @param con the Connection to use for any future IO's
	 */
	public final void setConnection(Connection con) 
		throws SQLException {

		this.con = con;
	}

	/**
	 * select a single forecast row using the passed
	 * primary key
	 * 
	 * @param pk the primary key we want to search with
	 * @return the Forecast row(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final Object selectRow(Object pk) 
		throws SQLException {

		Forecast sp = new Forecast();
		sp.setPK(((Long)pk).longValue());

		Statement stmt = null;
		ResultSet rs = null;
		String query = selectQuery + sp.getPK();

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			int i;

			while (rs.next()) {
				i=1;
				sp.setOppKey(rs.getLong(i)); i++;
				sp.setName(rs.getString(i)); i++;
				sp.setCloseDate(rs.getDate(i)); i++;
				String flag=rs.getString(i); i++;
				Boolean val;
				if (flag.equals("Y")) val=new Boolean(true); else val=new Boolean(false);
				sp.setSubmitted(val);
				sp.setSubmittedDate(rs.getDate(i)); i++;
				sp.setSubmittedBy(rs.getString(i)); i++;
				sp.setRevenue(new Integer(rs.getInt(i))); i++;
				sp.setProfit(new Integer(rs.getInt(i))); i++;
				sp.setMargin(new Double(rs.getDouble(i))); i++;
				sp.setScenario(rs.getString(i)); i++;
				sp.setAmountJan(new Integer(rs.getInt(i))); i++;
				sp.setAmountFeb(new Integer(rs.getInt(i))); i++;
				sp.setAmountMar(new Integer(rs.getInt(i))); i++;
				sp.setQ1(new Integer(rs.getInt(i))); i++;
				sp.setAmountApr(new Integer(rs.getInt(i))); i++;
				sp.setAmountMay(new Integer(rs.getInt(i))); i++;
				sp.setAmountJun(new Integer(rs.getInt(i))); i++;
				sp.setQ2(new Integer(rs.getInt(i))); i++;
				sp.setAmountJul(new Integer(rs.getInt(i))); i++;
				sp.setAmountAug(new Integer(rs.getInt(i))); i++;
				sp.setAmountSep(new Integer(rs.getInt(i))); i++;
				sp.setQ3(new Integer(rs.getInt(i))); i++;
				sp.setAmountOct(new Integer(rs.getInt(i))); i++;
				sp.setAmountNov(new Integer(rs.getInt(i))); i++;
				sp.setAmountDec(new Integer(rs.getInt(i))); i++;
				sp.setQ4(new Integer(rs.getInt(i))); i++;
				sp.setModifiedBy(rs.getString(i)); i++;
				sp.setModifiedDate(rs.getDate(i)); 
			}

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		return sp;
	}


	/**
	 * update a Forecast stored in the database using the
	 * passed parm 
	 * @param obj the Forecast we are updating
	 * @exception java.sql.SQLException 
	 */
	public final void updateRow(Object obj) 
		throws SQLException {

		Forecast fore = (Forecast)obj;

		StringBuffer query = new StringBuffer(updateQuery);
		Statement stmt = con.createStatement();

		query.append("name=");
		query.append(JDBC.quoteMore(fore.getName()));
		query.append("close_date=");
		query.append(JDBC.quoteMore(DateUtils.format(DB_TYPE, fore.getCloseDate())));
		query.append("submitted=");
		String x; if (fore.getSubmitted().booleanValue()) x="Y"; else x="N";
		query.append(JDBC.quoteMore(x));
		query.append("submitted_date=");
		query.append(JDBC.quoteMore(DateUtils.format(DB_TYPE, fore.getSubmittedDate())));
		query.append("submitted_by=");
		query.append(JDBC.quoteMore(fore.getSubmittedBy()));
		query.append("revenue=");
		query.append(fore.getRevenue().intValue()).append(",");
		query.append("profit=");
		query.append(fore.getProfit().intValue()).append(",");
		query.append("margin=");
		query.append(fore.getMargin().doubleValue()).append(",");
		query.append("scenario=");
		query.append(JDBC.quoteMore(fore.getScenario()));
		query.append("amount_jan=");
		query.append(fore.getAmountJan().intValue()).append(",");
		query.append("amount_feb=");
		query.append(fore.getAmountFeb().intValue()).append(",");
		query.append("amount_mar=");
		query.append(fore.getAmountMar().intValue()).append(",");
		query.append("q1=");
		query.append(fore.getQ1().intValue()).append(","); 
		query.append("amount_apr=");
		query.append(fore.getAmountApr().intValue()).append(",");
		query.append("amount_may=");
		query.append(fore.getAmountMay().intValue()).append(",");
		query.append("amount_jun=");
		query.append(fore.getAmountJun().intValue()).append(",");
		query.append("q2=");
		query.append(fore.getQ2().intValue()).append(",");
		query.append("amount_jul=");
		query.append(fore.getAmountJul().intValue()).append(",");
		query.append("amount_aug=");
		query.append(fore.getAmountAug().intValue()).append(",");
		query.append("amount_sep=");
		query.append(fore.getAmountSep().intValue()).append(",");
		query.append("q3=");
		query.append(fore.getQ3().intValue()).append(",");
		query.append("amount_oct=");
		query.append(fore.getAmountOct().intValue()).append(",");
		query.append("amount_nov=");
		query.append(fore.getAmountNov().intValue()).append(",");
		query.append("amount_dec=");
		query.append(fore.getAmountDec().intValue()).append(",");
		query.append("q4=");
		query.append(fore.getQ4().intValue()).append(",");
		query.append("modified_by=");
		query.append(JDBC.quoteMore(fore.getModifiedBy()));
		query.append("modified_date=");
		query.append(JDBC.quote(DateUtils.format(DB_TYPE, fore.getModifiedDate())));
		query.append(" WHERE pk=");
		query.append(fore.getPK()); 

		if (Prefs.DEBUG) LogWrite.write(query.toString());
		int updatedRows = stmt.executeUpdate(query.toString());
	}

	/**
	 * insert a new forecast row using the passed
	 * Forecast object as the column values.
	 * 
	 * @param obj the object we are trying to insert
	 * @param load true if the row is to be loaded, false if the
	 * row is to be added
	 * @return the newly assigned primary key of the new row
	 * @exception java.sql.SQLException 
	 */
	public final long insertRow(Object obj, boolean load) 
		throws SQLException {

		Forecast forecast = (Forecast)obj;

		if (!load)
			forecast.setPK(DBUtils.generatePK());

		StringBuffer query = new StringBuffer(insertQuery);
		Statement stmt = con.createStatement();

		query.append(forecast.getPK()).append(",");
		query.append(forecast.getOppKey()).append(",");
		query.append(JDBC.quoteMore(forecast.getName()));
		query.append(JDBC.quoteMore(DateUtils.format(DB_TYPE, forecast.getCloseDate())));
		String x; if (forecast.getSubmitted().booleanValue()) x = "Y"; else x="N";
		query.append(JDBC.quoteMore(x));
		query.append(JDBC.quoteMore(DateUtils.format(DB_TYPE, forecast.getSubmittedDate())));
		query.append(JDBC.quoteMore(forecast.getSubmittedBy()));
		query.append(forecast.getRevenue().intValue()).append(",");
		query.append(forecast.getProfit().intValue()).append(",");
		query.append(forecast.getMargin().doubleValue()).append(",");
		query.append(JDBC.quoteMore(forecast.getScenario()));
		query.append(forecast.getAmountJan().intValue()).append(",");
		query.append(forecast.getAmountFeb().intValue()).append(",");
		query.append(forecast.getAmountMar().intValue()).append(",");
		query.append(forecast.getQ1().intValue()).append(",");
		query.append(forecast.getAmountApr().intValue()).append(",");
		query.append(forecast.getAmountMay().intValue()).append(",");
		query.append(forecast.getAmountJun().intValue()).append(",");
		query.append(forecast.getQ2().intValue()).append(",");
		query.append(forecast.getAmountJul().intValue()).append(",");
		query.append(forecast.getAmountAug().intValue()).append(",");
		query.append(forecast.getAmountSep().intValue()).append(",");
		query.append(forecast.getQ3().intValue()).append(",");
		query.append(forecast.getAmountOct().intValue()).append(",");
		query.append(forecast.getAmountNov().intValue()).append(",");
		query.append(forecast.getAmountDec().intValue()).append(",");
		query.append(forecast.getQ4().intValue()).append(",");
		query.append(JDBC.quoteMore(forecast.getModifiedBy()));
		query.append(JDBC.quote(DateUtils.format(DB_TYPE, forecast.getModifiedDate())));
		query.append(")");

		if (Prefs.DEBUG) LogWrite.write(query.toString());
		int rc = stmt.executeUpdate(query.toString());

		return forecast.getPK();
	}

	/**
	 * delete a single forecast row using the passed
	 * primary key value
	 *
	 * @param ojb primary key stored in a Long
	 * @exception java.sql.SQLException 
	 */
	public final void deleteRow(Object obj) 
		throws SQLException {

		long pkValue = ((Long)obj).longValue();

		String query = deleteQuery + pkValue;

		Statement stmt = null;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);
		} catch (SQLException e) {
			LogWrite.write(e);
			throw e;
		} finally {
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}
	}


	/**
	 * delete all forecast rows using the passed
	 * opportunity primary key value
	 *
	 * @param ojb primary key stored in a Long
	 * @exception java.sql.SQLException 
	 */
	public final void deleteOpportunityRows(Object obj) 
		throws SQLException {

		long oppPK = ((Long)obj).longValue();

		String query = deleteOppRowsQuery + oppPK;

		Statement stmt = null;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);
		} catch (SQLException e) {
			LogWrite.write(e);
			throw e;
		} finally {
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}
	}

	/**
	 * select all forecast rows using the passed
	 * opportunity primary key
	 * 
	 * @param opp_pk the Opportunity primary key to search with
	 * @param forecasts the list of Forecasts the search will return
	 * its result set into
	 * @exception java.sql.SQLException 
	 */
	public final void selectByOppRow(long opp_pk, ArrayList forecasts) 
		throws SQLException {

		Forecast f = null;

		Statement stmt = null;
		ResultSet rs = null;
		String query = selectForOppQuery + opp_pk;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			int i;

			while (rs.next()) {
				i=1;
				f = new Forecast();
				f.setPK(rs.getLong(i)); i++;
				f.setName(rs.getString(i)); i++;
				f.setCloseDate(rs.getDate(i)); i++;
				String flag=rs.getString(i); i++;
				Boolean val;
				if (flag.equals("Y")) val=new Boolean(true); else val=new Boolean(false);
				f.setSubmitted(val);
				f.setSubmittedDate(rs.getDate(i)); i++;
				f.setSubmittedBy(rs.getString(i)); i++;
				f.setRevenue(new Integer(rs.getInt(i))); i++;
				f.setProfit(new Integer(rs.getInt(i))); i++;
				f.setMargin(new Double(rs.getDouble(i))); i++;
				f.setScenario(rs.getString(i)); i++;
				f.setAmountJan(new Integer(rs.getInt(i))); i++;
				f.setAmountFeb(new Integer(rs.getInt(i))); i++;
				f.setAmountMar(new Integer(rs.getInt(i))); i++;
				f.setQ1(new Integer(rs.getInt(i))); i++;
				f.setAmountApr(new Integer(rs.getInt(i))); i++;
				f.setAmountMay(new Integer(rs.getInt(i))); i++;
				f.setAmountJun(new Integer(rs.getInt(i))); i++;
				f.setQ2(new Integer(rs.getInt(i))); i++;
				f.setAmountJul(new Integer(rs.getInt(i))); i++;
				f.setAmountAug(new Integer(rs.getInt(i))); i++;
				f.setAmountSep(new Integer(rs.getInt(i))); i++;
				f.setQ3(new Integer(rs.getInt(i))); i++;
				f.setAmountOct(new Integer(rs.getInt(i))); i++;
				f.setAmountNov(new Integer(rs.getInt(i))); i++;
				f.setAmountDec(new Integer(rs.getInt(i))); i++;
				f.setQ4(new Integer(rs.getInt(i))); i++;
				f.setModifiedBy(rs.getString(i)); i++;
				f.setModifiedDate(rs.getDate(i)); 
				forecasts.add(f);
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}
	}
    /**
     * truncate the whole table
     *
     * @exception java.sql.SQLException
     */
    public final void truncate()
        throws SQLException {

        String query = "truncate table forecast";
   
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            if (Prefs.DEBUG) LogWrite.write(query);
            stmt.executeUpdate(query);
        } catch (SQLException e) {
            throw e;
        } finally {
            try { if (stmt != null) stmt.close();
            } catch (SQLException x) { }
        }
    }

}
