package sellwin.db;

import sellwin.domain.*;
import sellwin.utils.*;

import java.sql.*;
import java.util.ArrayList;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the DBInterface for
 * the RolePermission class objects which are stored
 * in the role_permission database table.
 */
public class RolePermissionDB extends DBType implements DBInterface {
	private Connection con;
	private final static String deleteQuery =
		"DELETE FROM role_permission WHERE pk = ";
	private final static String deleteUserRoleQuery=
		"DELETE FROM role_permission WHERE user_role_pk=";

	private final static String insertQuery =
		"INSERT INTO role_permission " +
		"VALUES (";
	private final static String updateQuery = 
			"UPDATE role_permission " +
			"SET ";
	private final static String selectQuery =
			"SELECT user_role_pk, name, r, " +
			"w, modified_by, modified_date "+
			"FROM role_permission "+
			"WHERE pk = ";
	private final static String selectAllQuery =
			"SELECT pk, name, r, " +
			"w, modified_by, modified_date "+
			"FROM role_permission "+
			"WHERE user_role_pk = ";

	/**
	 * a do-nothing constructor but necessary to
	 * do the operations offered by this class
	 */
	public RolePermissionDB() {
	}

	/**
	 * construct, use a db type
	 * @param dbType the db type to assume
	 */
	public RolePermissionDB(int dbType) {
		DB_TYPE = dbType;
	}

	/**
	 * a version of the constructor when a connection
	 * is alry obtained from somewhere else
	 *
	 * @param con the Connection to use 
	 */
	public RolePermissionDB(Connection con) {
		this.con = con;
	}

	/**
	 * return the Connection in use
	 *
	 * @return the Connection in use
	 */
	public Connection getConnection() {
		return this.con;
	}

	/**
	 * set the Connection to use 
	 *
	 * @param con the Connection to use for any future IO's
	 */
	public final void setConnection(Connection con) 
		throws SQLException {

		this.con = con;
	}

	/**
	 * select a single role_permission row using the passed
	 * primary key
	 * 
	 * @param name description
	 * @return the RolePermission row(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final Object selectRow(Object pk) 
		throws SQLException {

		RolePermission rp = new RolePermission();
		rp.setPK(((Long)pk).longValue());

		Statement stmt = null;
		ResultSet rs = null;
		String query = selectQuery + rp.getPK();

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			int i;

			while (rs.next()) {
				i=1;
				rp.setUserRolePK(rs.getLong(i)); i++;
				rp.setName(rs.getString(i)); i++;
				String x = rs.getString(i); i++;
				boolean val;
				if (x.charAt(0) == 'Y') val=true; else val=false;
				rp.setRead(val);
				x = rs.getString(i); i++;
				if (x.charAt(0) == 'Y') val=true; else val=false;
				rp.setWrite(val);
				rp.setModifiedBy(rs.getString(i)); i++;
				rp.setModifiedDate(rs.getDate(i)); 
			}

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		return rp;
	}


	/**
	 * update a single role_permission row using the passed
	 * RolePermission object's attributes.  All columns
	 * get updated by this routine regardless of whether
	 * an attribute was modified or not.
	 *
	 * @param name description
	 * @exception java.sql.SQLException 
	 */
	public final void updateRow(Object obj) 
		throws SQLException {

		RolePermission role_permission = (RolePermission)obj;

		StringBuffer query = new StringBuffer(updateQuery);
		Statement stmt = con.createStatement();

		query.append("name=");
		query.append(JDBC.quoteMore(role_permission.getName()));
		String x;
		query.append("r=");
		if (role_permission.getRead()) x="Y"; else x="N"; 
		query.append(JDBC.quoteMore(x));
		query.append("w=");
		if (role_permission.getWrite()) x="Y"; else x="N"; 
		query.append(JDBC.quoteMore(x));
		query.append("modified_by=");
		query.append(JDBC.quoteMore(role_permission.getModifiedBy()));
		query.append("modified_date=");
		if (DB_TYPE == Prefs.MYSQL)
			query.append("CURRENT_DATE");
		else
			query.append("SYSDATE");
		query.append(" WHERE pk=");
		query.append(role_permission.getPK());  

		if (Prefs.DEBUG) LogWrite.write(query.toString());
		int updatedRows = stmt.executeUpdate(query.toString());
	}

	/**
	 * insert a new role_permission row using the passed
	 * RolePermission object as the column values.
	 * 
	 * @param obj the RolePermission we are adding or loading
	 * @param load true if loading, false if adding
	 * @return the newly assigned primary key of the new row
	 * @exception java.sql.SQLException 
	 */
	public final long insertRow(Object obj, boolean load) 
		throws SQLException {

		RolePermission role_permission = (RolePermission)obj;

		if (!load)
			role_permission.setPK(DBUtils.generatePK());

		StringBuffer query = new StringBuffer(insertQuery);
		Statement stmt = con.createStatement();

		query.append(role_permission.getPK()).append(","); 
		query.append(role_permission.getUserRolePK()).append(","); 
		query.append(JDBC.quoteMore(role_permission.getName()));
		String x;
		if (role_permission.getRead()) x="Y"; else x="N"; 
		query.append(JDBC.quoteMore(x));
		if (role_permission.getWrite()) x="Y"; else x="N"; 
		query.append(JDBC.quoteMore(x));
		query.append(JDBC.quoteMore(role_permission.getModifiedBy()));
		if (DB_TYPE == Prefs.MYSQL)
			query.append("CURRENT_DATE");
		else
			query.append("SYSDATE");
		query.append(")");

		if (Prefs.DEBUG) LogWrite.write(query.toString());
		int rc = stmt.executeUpdate(query.toString());

		return role_permission.getPK();
	}

	/**
	 * delete a single role_permission row using the passed
	 * primary key value
	 *
	 * @param ojb primary key stored in a Long
	 * @exception java.sql.SQLException 
	 */
	public final void deleteRow(Object obj) 
		throws SQLException {

		long pkValue = ((Long)obj).longValue();

		String query = deleteQuery + pkValue;

		Statement stmt = null;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}
	}

	/**
	 * delete all role_permission rows for a given user role
	 * using the passed user_roleprimary key value
	 *
	 * @param ojb primary key stored in a Long
	 * @exception java.sql.SQLException 
	 */
	public final void deleteUserRoleRows(Object obj) 
		throws SQLException {

		long pkValue = ((Long)obj).longValue();

		String query = deleteUserRoleQuery + pkValue;

		Statement stmt = null;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}
	}

	/**
	 * select all role_permission rows using the passed
	 * user_role primary key
	 * 
	 * @param name description
	 * @return the List of RolePermission row(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final void selectRows(long user_role_pk, ArrayList perms) 
		throws SQLException {

		RolePermission rp;

		Statement stmt = null;
		ResultSet rs = null;
		String query = selectAllQuery + user_role_pk;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			int i;

			while (rs.next()) {
				i=1;
				rp = new RolePermission();
				rp.setPK(rs.getLong(i)); i++;
				rp.setUserRolePK(user_role_pk); //from the passed parm
				rp.setName(rs.getString(i)); i++;
				String x = rs.getString(i); i++;
				boolean val;
				if (x.charAt(0) == 'Y') val=true; else val=false;
				rp.setRead(val);
				x = rs.getString(i); i++;
				if (x.charAt(0) == 'Y') val=true; else val=false;
				rp.setWrite(val);
				rp.setModifiedBy(rs.getString(i)); i++;
				rp.setModifiedDate(rs.getDate(i)); 
				perms.add(rp);
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

	}
    /**
     * truncate the whole table
     *
     * @exception java.sql.SQLException
     */
    public final void truncate()
        throws SQLException {

        String query = "truncate table role_permission";
   
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            if (Prefs.DEBUG) LogWrite.write(query);
            stmt.executeUpdate(query);
        } catch (SQLException e) {
            throw e;
        } finally {
            try { if (stmt != null) stmt.close();
            } catch (SQLException x) { }
        }
    }

}
