package sellwin.db;

import sellwin.domain.*;
import sellwin.utils.*;

import java.sql.*;
import java.util.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the DBInterface for
 * the SalesPerson class objects which are stored
 * in the sales_person database table.
 */
public class SalesPersonDB extends DBType implements DBInterface {

	private Connection con;
	private final static String deleteAllQuery =
		"DELETE FROM sales_person ";

	private final static String deleteQuery =
		"DELETE FROM sales_person WHERE pk = ";

	private final static String insertQuery =
		"INSERT INTO sales_person " +
		"VALUES (";
	private final static String updateQuery = 
			"UPDATE sales_person " +
			"SET ";

	private final static String selectAllNamesQuery =
			"SELECT address.first_name, " +
			"address.last_name, address.middle_initial "+
			"FROM sales_person , address "+
			"WHERE sales_person.address_pk = address.pk " +
			"ORDER BY address.last_name, address.first_name";

	private final static String selectQuery =
			"SELECT id, password, address.pk, address.first_name, " +
			"address.last_name, address.middle_initial, "+
  			"address.address_line1, address.address_line2, "+
  			"address.title, address.phone, "+
  			"address.fax, address.pager, "+
  			"address.cell, address.email, "+
  			"address.city, address.state, "+
  			"address.country, address.zip, "+
  			"address.zip4, address.modified_by, "+
  			"address.modified_date, sales_person.modified_by, "+
			"sales_person.modified_date," +
			"sales_person.sync_date " +
			"FROM sales_person , address "+
			"WHERE sales_person.pk = ";

	private final static String selectAllIDQuery =
			"SELECT id " +
			"FROM sales_person " +
			"ORDER BY id";

	private final static String selectAllQuery =
			"SELECT sales_person.pk, id, password, address.pk, address.first_name, " +
			"address.last_name, address.middle_initial, "+
  			"address.address_line1, address.address_line2, "+
  			"address.title, address.phone, "+
  			"address.fax, address.pager, "+
  			"address.cell, address.email, "+
  			"address.city, address.state, "+
  			"address.country, address.zip, "+
  			"address.zip4, address.modified_by, "+
  			"address.modified_date, sales_person.modified_by, "+
			"sales_person.modified_date, " +
			"sales_person.sync_date " +
			"FROM sales_person , address "+
			"WHERE sales_person.address_pk = address.pk ";


	private final static String selectByLogonQuery =
			"SELECT sales_person.pk, address.pk, address.first_name, " +
			"address.last_name, address.middle_initial, "+
  			"address.address_line1, address.address_line2, "+
  			"address.title, address.phone, "+
  			"address.fax, address.pager, "+
  			"address.cell, address.email, "+
  			"address.city, address.state, "+
  			"address.country, address.zip, "+
  			"address.zip4, address.modified_by, "+
  			"address.modified_date, sales_person.modified_by, "+
			"sales_person.modified_date, " +
			"sales_person.sync_date " +
			"FROM sales_person , address "+
			"WHERE sales_person.id = ";


	/**
	 * a do-nothing constructor but necessary to
	 * do the operations offered by this class
	 */
	public SalesPersonDB() {
	}

	/**
	 * construct, use a db type
	 * @param dbType the db type to assume
	 */
	public SalesPersonDB(int dbType) {
		DB_TYPE = dbType;
	}

	/**
	 * a version of the constructor when a connection
	 * is already obtained from somewhere else
	 *
	 * @param con the Connection to use 
	 */
	public SalesPersonDB(Connection con) {
		this.con = con;
	}

	/**
	 * return the Connection in use
	 *
	 * @return the Connection in use
	 */
	public Connection getConnection() {
		return this.con;
	}

	/**
	 * set the Connection to use 
	 *
	 * @param con the Connection to use for any future IO's
	 */
	public final void setConnection(Connection con) 
		throws SQLException {

		this.con = con;
	}

	/**
	 * select a single sales_person row using the passed
	 * primary key
	 * 
	 * @param pk the primary key we are searching with
	 * @return the SalesPerson row(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final Object selectRow(Object pk) 
		throws SQLException {

		SalesPerson sp = new SalesPerson();
		long pkValue = ((Long)pk).longValue();
		Statement stmt = null;
		ResultSet rs = null;
		String query = selectQuery + pkValue + 
			" AND sales_person.address_pk = address.pk";

		try {

			UserGroupMemberDB userGroupMemberDB = new UserGroupMemberDB(DB_TYPE);
			userGroupMemberDB.setConnection(getConnection());

			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			int i;

			while (rs.next()) {
				i=1;
				sp.setID(rs.getString(i)); i++;
				sp.setPassword(rs.getString(i)); i++;
				sp.getAddress().setPK(rs.getLong(i)); i++;
				sp.getAddress().setFirstName(rs.getString(i)); i++;
				sp.getAddress().setLastName(rs.getString(i)); i++;
				sp.getAddress().setMiddleInitial(rs.getString(i)); i++;
				sp.getAddress().setAddressLine1(rs.getString(i)); i++;
				sp.getAddress().setAddressLine2(rs.getString(i)); i++;
				sp.getAddress().setTitle(rs.getString(i)); i++;
				sp.getAddress().setPhone(rs.getString(i)); i++;
				sp.getAddress().setFax(rs.getString(i)); i++;
				sp.getAddress().setPager(rs.getString(i)); i++;
				sp.getAddress().setCell(rs.getString(i)); i++;
				sp.getAddress().setEmail(rs.getString(i)); i++;
				sp.getAddress().setCity(rs.getString(i)); i++;
				sp.getAddress().setState(rs.getString(i)); i++;
				sp.getAddress().setCountry(rs.getString(i)); i++;
				sp.getAddress().setZip(rs.getString(i)); i++;
				sp.getAddress().setZip4(rs.getString(i)); i++;
				sp.getAddress().setModifiedBy(rs.getString(i)); i++;
				sp.getAddress().setModifiedDate(rs.getDate(i)); i++;
				sp.setModifiedBy(rs.getString(i)); i++;
				sp.setModifiedDate(rs.getDate(i)); i++;
				sp.setSyncDate(rs.getDate(i)); 

				//get all the user groups this dude belongs to and
				//add them to this object we are fetching
				ArrayList userGroups = userGroupMemberDB.selectGroupsForUser(sp.getPK());
				UserGroup ug;
				for (int x=0;x<userGroups.size();x++) {
					ug = (UserGroup)userGroups.get(x);
					sp.addUserGroup(ug);
				}

				//get all the roles for this user
				SalesPersonRoleDB salesPersonRoleDB = new SalesPersonRoleDB(
					getConnection());
				salesPersonRoleDB.selectRolesForUser(sp.getPK(), sp.getUserRoles());
				
			}

		} catch (SQLException e) {
			LogWrite.write(e);
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		return sp;
	}


	/**
	 * update a single sales_person row using the passed
	 * SalesPerson object's attributes.  All columns
	 * get updated by this routine regardless of whether
	 * an attribute was modified or not.
	 *
	 * @param obj the object we are updating 
	 * @exception java.sql.SQLException 
	 */
	public final void updateRow(Object obj) 
		throws SQLException {

		SalesPerson sales_person = (SalesPerson)obj;
		long pk = sales_person.getPK();

		//update the Address component of the Sales Person
		AddressDB addr = new AddressDB(DB_TYPE);
		addr.setConnection(getConnection());
		addr.updateRow(sales_person.getAddress());

		StringBuffer query = new StringBuffer(updateQuery);
		Statement stmt = con.createStatement();

		query.append("id=");
		query.append(JDBC.quoteMore(sales_person.getID()));
		query.append("sync_date=");
		if (sales_person.getSyncDate() == null)
			query.append("null,");
		else {
			if (DB_TYPE == Prefs.MYSQL) {
				query.append(DateUtils.formatDateTime(DB_TYPE, 
					sales_person.getSyncDate()));
				query.append(",");
			} else {
        		query.append("to_date(");
				query.append(DateUtils.formatDateTime(DB_TYPE, 
					sales_person.getSyncDate()));
				query.append(",'yyyy-mm-dd hh24:mi'),");
			}
		}
		query.append("password=");
		query.append(JDBC.quote(sales_person.getPassword()));
		query.append(" WHERE pk=").append(sales_person.getPK()); 

		if (Prefs.DEBUG) LogWrite.write(query.toString());
		int updatedRows = stmt.executeUpdate(query.toString());

		//delete all the user's roles and then add the
		//ones that are present, this is a dumb but easy
		//way to update the list of roles for this user
		SalesPersonRoleDB spRoleDB = new SalesPersonRoleDB(DB_TYPE);
		spRoleDB.setConnection(getConnection());
		spRoleDB.deleteSalesPersonRows(new Long(sales_person.getPK()));
		ArrayList roles = sales_person.getUserRoles();
		UserRole role;
		SalesPersonRole spRole;
		for (int j=0;j<roles.size();j++) {
			role = (UserRole)roles.get(j);
			spRole = new SalesPersonRole();
			spRole.setSalesPersonPK(sales_person.getPK());
			spRole.setUserRolePK(role.getPK());
			spRole.setModifiedBy(sales_person.getModifiedBy());
			spRoleDB.insertRow(spRole, false);
		}
	}

	/**
	 * insert a new sales_person row using the passed
	 * SalesPerson object as the column values.
	 * 
	 * @param obj the object we are inserting
	 * @param load true if loading, false if adding
	 * @return the newly assigned primary key of the new row
	 * @exception java.sql.SQLException 
	 */
	public final long insertRow(Object obj, boolean load) 
		throws SQLException {

		SalesPerson sales_person = (SalesPerson)obj;

		//insert the Address first
		AddressDB a= new AddressDB(DB_TYPE);
		a.setConnection(getConnection());
		sales_person.getAddress().setModifiedBy(sales_person.getModifiedBy());
		sales_person.getAddress().setPK(a.insertRow(sales_person.getAddress(), load));

		if (!load)
			sales_person.setPK(DBUtils.generatePK());

		StringBuffer query = new StringBuffer(insertQuery);
		Statement stmt = con.createStatement();

		query.append(sales_person.getPK()); 
		query.append(",");
		query.append(JDBC.quoteMore(sales_person.getID()));
		query.append(JDBC.quoteMore(sales_person.getPassword()));
		query.append(sales_person.getAddress().getPK()).append(",");
		query.append(JDBC.quoteMore(sales_person.getModifiedBy()));
		if (DB_TYPE == Prefs.MYSQL)
			query.append("CURRENT_DATE,");
		else
			query.append("SYSDATE,");
		query.append("null"); //sync date
		query.append(")");

		if (Prefs.DEBUG) LogWrite.write(query.toString());
		int rc = stmt.executeUpdate(query.toString());

		return sales_person.getPK();
	}

	/**
	 * delete a single sales_person row using the passed
	 * primary key value
	 *
	 * @param ojb primary key stored in a Long
	 * @exception java.sql.SQLException 
	 */
	public final void deleteRow(Object obj) 
		throws SQLException {

		SalesPerson sp = (SalesPerson)obj;


		String query = deleteQuery + sp.getPK();

		Statement stmt = null;

		try {

			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);

			//delete this person's address 
			AddressDB addr = new AddressDB(DB_TYPE);
			addr.setConnection(getConnection());
			addr.deleteRow(new Long(sp.getAddress().getPK()));
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}
	}

	/**
	 * select a single sales_person row using the passed
	 * id and password (logon credentials)
	 * 
	 * @param id the login id of the sales person we are searching for
	 * @param password the login password of the sales person we are searching for
	 * @return the SalesPerson row(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final SalesPerson selectRow(String id, String password) 
		throws SQLException, SellwinNotFoundException {

		SalesPerson sp = null;
		Statement stmt = null;
		ResultSet rs = null;
		String query = selectByLogonQuery + "'" + id + "'" +
			" AND password = " + "'" + password + "'" +
			" AND sales_person.address_pk = address.pk";

		try {
			stmt = con.createStatement();

			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			int i;

			while (rs.next()) {
				i=1;
				sp = new SalesPerson();
				sp.setID(id);
				sp.setPassword(password);
				sp.setPK(rs.getLong(i)); i++;
				sp.getAddress().setPK(rs.getLong(i)); i++;
				sp.getAddress().setFirstName(rs.getString(i)); i++;
				sp.getAddress().setLastName(rs.getString(i)); i++;
				sp.getAddress().setMiddleInitial(rs.getString(i)); i++;
				sp.getAddress().setAddressLine1(rs.getString(i)); i++;
				sp.getAddress().setAddressLine2(rs.getString(i)); i++;
				sp.getAddress().setTitle(rs.getString(i)); i++;
				sp.getAddress().setPhone(rs.getString(i)); i++;
				sp.getAddress().setFax(rs.getString(i)); i++;
				sp.getAddress().setPager(rs.getString(i)); i++;
				sp.getAddress().setCell(rs.getString(i)); i++;
				sp.getAddress().setEmail(rs.getString(i)); i++;
				sp.getAddress().setCity(rs.getString(i)); i++;
				sp.getAddress().setState(rs.getString(i)); i++;
				sp.getAddress().setCountry(rs.getString(i)); i++;
				sp.getAddress().setZip(rs.getString(i)); i++;
				sp.getAddress().setZip4(rs.getString(i)); i++;
				sp.getAddress().setModifiedBy(rs.getString(i)); i++;
				sp.getAddress().setModifiedDate(rs.getDate(i)); i++;
				sp.setModifiedBy(rs.getString(i)); i++;
				sp.setModifiedDate(rs.getDate(i)); i++;
				sp.setSyncDate(rs.getDate(i)); 

				//get all the roles for this user
				SalesPersonRoleDB salesPersonRoleDB = new SalesPersonRoleDB(DB_TYPE);
				salesPersonRoleDB.setConnection(getConnection());
				salesPersonRoleDB.selectRolesForUser(sp.getPK(), sp.getUserRoles());
			}

			if (sp == null)
				throw new SellwinNotFoundException("Logon failed.");

		} catch (SellwinNotFoundException x) {
			throw x;
		} catch (SQLException e) {
			LogWrite.write(e);
			throw e;
		} catch (Exception f) {
			LogWrite.write(f);
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		if (Prefs.DEBUG) LogWrite.write("returning an sp");
		return sp;
	}

	/**
	 * select all sales_person names 
	 * 
	 * @return the SalesPerson row(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final ArrayList selectAllNames() 
		throws SQLException {

		ArrayList names = new ArrayList();
		Statement stmt = null;
		ResultSet rs = null;
		String query = selectAllNamesQuery;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			int i;
			SalesPerson sp;

			while (rs.next()) {
				i=1;
				sp = new SalesPerson();
				sp.getAddress().setFirstName(rs.getString(i)); i++;
				sp.getAddress().setLastName(rs.getString(i)); i++;
				sp.getAddress().setMiddleInitial(rs.getString(i)); i++;
				names.add(sp.getAddress().getFormattedName());
			}

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		return names;
	}

	/**
	 * select all sales_person rows 
	 * 
	 * @param lastSyncDate a user's last sync date or null, used to
	 * limit the query
	 * @return the SalesPerson row(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final TreeMap selectAllRows(java.util.Date lastSyncDate) 
		throws SQLException {

		TreeMap users = new TreeMap();
		SalesPerson sp;
		Statement stmt = null;
		ResultSet rs = null;
		StringBuffer query = new StringBuffer();
		query.append(selectAllQuery);
		if (lastSyncDate != null) {
            query.append(" AND sales_person.modified_date > ");
            query.append(DateUtils.formatDateTime(DB_TYPE, lastSyncDate));
		}
		query.append(" ORDER BY id");

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query.toString());
			rs = stmt.executeQuery(query.toString());

			int i;
			UserGroupMemberDB userGroupMemberDB = new UserGroupMemberDB(DB_TYPE);
			userGroupMemberDB.setConnection(getConnection());
			ArrayList userGroups;
			UserGroup ug;

			while (rs.next()) {
				i=1;
				sp = new SalesPerson();
				sp.setPK(rs.getLong(i)); i++;
				sp.setID(rs.getString(i)); i++;
				sp.setPassword(rs.getString(i)); i++;
				sp.getAddress().setPK(rs.getLong(i)); i++;
				sp.getAddress().setFirstName(rs.getString(i)); i++;
				sp.getAddress().setLastName(rs.getString(i)); i++;
				sp.getAddress().setMiddleInitial(rs.getString(i)); i++;
				sp.getAddress().setAddressLine1(rs.getString(i)); i++;
				sp.getAddress().setAddressLine2(rs.getString(i)); i++;
				sp.getAddress().setTitle(rs.getString(i)); i++;
				sp.getAddress().setPhone(rs.getString(i)); i++;
				sp.getAddress().setFax(rs.getString(i)); i++;
				sp.getAddress().setPager(rs.getString(i)); i++;
				sp.getAddress().setCell(rs.getString(i)); i++;
				sp.getAddress().setEmail(rs.getString(i)); i++;
				sp.getAddress().setCity(rs.getString(i)); i++;
				sp.getAddress().setState(rs.getString(i)); i++;
				sp.getAddress().setCountry(rs.getString(i)); i++;
				sp.getAddress().setZip(rs.getString(i)); i++;
				sp.getAddress().setZip4(rs.getString(i)); i++;
				sp.getAddress().setModifiedBy(rs.getString(i)); i++;
				sp.getAddress().setModifiedDate(rs.getDate(i)); i++;
				sp.setModifiedBy(rs.getString(i)); i++;
				sp.setModifiedDate(rs.getDate(i)); i++;
				sp.setSyncDate(rs.getDate(i)); 

				//get all the user groups this dude belongs to and
				//add them to this object we are fetching
				userGroups = userGroupMemberDB.selectGroupsForUser(sp.getPK());
				for (int x=0;x<userGroups.size();x++) {
					ug = (UserGroup)userGroups.get(x);
					sp.addUserGroup(ug);
				}
				users.put(sp.getID(), sp);

				//get all the roles for this user
				SalesPersonRoleDB salesPersonRoleDB = new SalesPersonRoleDB(
					getConnection());
				salesPersonRoleDB.selectRolesForUser(sp.getPK(), sp.getUserRoles());
			}

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		return users;
	}

	/**
	 * select all sales_person IDs 
	 * 
	 * @return the SalesPerson row(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final ArrayList selectAllIDs() 
		throws SQLException {

		ArrayList idList = new ArrayList();
		Statement stmt = null;
		ResultSet rs = null;
		String query = selectAllIDQuery ;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			while (rs.next()) {
				idList.add(rs.getString(1));
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		return idList;
	}

	/**
	 * delete all sales_person rows
	 *
	 * @exception java.sql.SQLException 
	 */
	public final void deleteAllRows() 
		throws SQLException {

		String query = deleteAllQuery;

		Statement stmt = null;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}
	}
    /**
     * truncate the whole table
     *
     * @exception java.sql.SQLException
     */
    public final void truncate()
        throws SQLException {

        String query = "truncate table sales_person";
   
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            if (Prefs.DEBUG) LogWrite.write(query);
            stmt.executeUpdate(query);
        } catch (SQLException e) {
            throw e;
        } finally {
            try { if (stmt != null) stmt.close();
            } catch (SQLException x) { }
        }
    }

	/**
	 * update a single sales_person row's sync date
	 *
	 * @param pk the pk of the sales person we are to update
	 * @exception java.sql.SQLException 
	 */
	public final void updateSyncDate(long pk)
		throws SQLException {

		StringBuffer query = new StringBuffer(updateQuery);
		Statement stmt = con.createStatement();

		query.append("sync_date=");
		query.append(DateUtils.formatDateTime(DB_TYPE, new java.util.Date()));
		query.append(" WHERE pk=").append(pk);

		if (Prefs.DEBUG) LogWrite.write(query.toString());
		int updatedRows = stmt.executeUpdate(query.toString());
	}
}
