package sellwin.db;

import sellwin.domain.*;
import sellwin.utils.*;

import java.util.ArrayList;
import java.sql.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the DBInterface for
 * the SalesPersonRole class objects which are stored
 * in the sales_person_role database table.
 */
public class SalesPersonRoleDB extends DBType implements DBInterface {

	private Connection con;

	private final static String deleteQuery =
		"DELETE FROM sales_person_role WHERE pk = ";

	private final static String deleteSalesPersonQuery=
		"DELETE FROM sales_person_role WHERE sp_pk=";

	private final static String insertQuery =
		"INSERT INTO sales_person_role " +
		"VALUES (";

	private final static String selectQuery =
			"SELECT sp_pk, user_role_pk, " +
  			"modified_by, modified_date " +
			"FROM sales_person_role " +
			"WHERE pk = ";

	private final static String selectRolesForUserQuery =
			"SELECT user_role.pk, " +
			"user_role.name, user_role.modified_by, " +
			"user_role.modified_date " +
			"FROM sales_person_role, user_role " +
			"WHERE user_role.pk = sales_person_role.user_role_pk AND " +
			"sales_person_role.sp_pk = ";

	/**
	 * a do-nothing constructor but necessary to
	 * do the operations offered by this class
	 */
	public SalesPersonRoleDB() {
	}

	/**
	 * construct using a db type
	 * @param dbType the db type to assume
	 */
	public SalesPersonRoleDB(int dbType) {
		DB_TYPE = dbType;
	}

	/**
	 * a version of the constructor when a connection
	 * is already obtained from somewhere else
	 *
	 * @param con the Connection to use 
	 */
	public SalesPersonRoleDB(Connection con) {
		this.con = con;
	}

	/**
	 * return the Connection in use
	 *
	 * @return the Connection in use
	 */
	public Connection getConnection() {
		return this.con;
	}

	/**
	 * set the Connection to use 
	 *
	 * @param con the Connection to use for any future IO's
	 */
	public final void setConnection(Connection con) 
		throws SQLException {

		this.con = con;
	}

	/**
	 * select a single sales_person_role row using the passed
	 * primary key
	 * 
	 * @param pk the primary key to search with
	 * @return the SalesPersonRole row(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final Object selectRow(Object pk) 
		throws SQLException {

		SalesPersonRole sp = new SalesPersonRole();
		sp.setPK(((Long)(pk)).longValue());
		Statement stmt = null;
		ResultSet rs = null;
		String query = selectQuery + sp.getPK();

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			int i;

			while (rs.next()) {
				i=1;
				sp.setSalesPersonPK(rs.getLong(i)); i++;
				sp.setUserRolePK(rs.getLong(i)); i++;
				UserRoleDB udb = new UserRoleDB(DB_TYPE);
				udb.setConnection(getConnection());
				UserRole u = (UserRole)udb.selectRow(new Long(sp.getUserRolePK()));
				sp.setUserRole(u);
				sp.setModifiedBy(rs.getString(i)); i++;
				sp.setModifiedDate(rs.getDate(i)); 
			}

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		return sp;
	}


	/**
	 * currently not necessary for this table
	 *
	 * @param name description
	 * @exception java.sql.SQLException 
	 */
	public final void updateRow(Object obj) 
		throws SQLException {

		//currently not necessary
	}

	/**
	 * insert a new sales_person_role row using the passed
	 * SalesPersonRole object as the column values.
	 * 
	 * @param obj the object to insert
	 * @param load true if loading, false if adding
	 * @return the newly assigned primary key of the new row
	 * @exception java.sql.SQLException 
	 */
	public final long insertRow(Object obj, boolean load) 
		throws SQLException {

		SalesPersonRole sales_person_role = (SalesPersonRole)obj;

		if (!load)
			sales_person_role.setPK(DBUtils.generatePK());

		StringBuffer query = new StringBuffer(insertQuery);
		Statement stmt = con.createStatement();

		int i=1;
		query.append(sales_person_role.getPK()).append(",");
		query.append(sales_person_role.getSalesPersonPK()).append(",");
		query.append(sales_person_role.getUserRolePK()).append(",");
		query.append(JDBC.quoteMore(sales_person_role.getModifiedBy()));
		if (DB_TYPE == Prefs.MYSQL)
			query.append("CURRENT_DATE");
		else
			query.append("SYSDATE");
		query.append(")");

		if (Prefs.DEBUG) LogWrite.write(query.toString());
		int rc = stmt.executeUpdate(query.toString());

		return sales_person_role.getPK();
	}

	/**
	 * delete a single sales_person_role row using the passed
	 * primary key value
	 *
	 * @param ojb primary key stored in a Long
	 * @exception java.sql.SQLException 
	 */
	public final void deleteRow(Object obj) 
		throws SQLException {

		long pkValue = ((Long)obj).longValue();

		String query = deleteQuery + pkValue;

		Statement stmt = null;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}
	}

	/**
	 * delete all sales_person_role rows using the passed
	 * sales person primary key value
	 *
	 * @param ojb primary key stored in a Long
	 * @exception java.sql.SQLException 
	 */
	public final void deleteSalesPersonRows(Object obj) 
		throws SQLException {

		long pkValue = ((Long)obj).longValue();

		String query = deleteSalesPersonQuery + pkValue;

		Statement stmt = null;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}
	}

	/**
	 * select all user_role rows using the passed
	 * sales person primary key...this requires a join
	 * of the user_role and sales_person_role tables so 
	 * I placed the query here. 
	 * 
	 * @param spPK the sales person primary key to search with
	 * @param roles an array that gets the search results from
	 * this query
	 * @exception java.sql.SQLException 
	 */
	public final void selectRolesForUser(long spPK, ArrayList roles) 
		throws SQLException {

		Statement stmt = null;
		ResultSet rs = null;
		String query = selectRolesForUserQuery + spPK;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			int i;
			UserRole ur;
			RolePermissionDB rolePermDB = new RolePermissionDB();
			rolePermDB.setConnection(getConnection());

			while (rs.next()) {
				i=1;
				ur = new UserRole();
				ur.setPK(rs.getLong(i)); i++;
				ur.setName(rs.getString(i)); i++;
				ur.setModifiedBy(rs.getString(i)); i++;
				ur.setModifiedDate(rs.getDate(i)); 

				//get the permissions for the new row
				rolePermDB.selectRows(ur.getPK(), ur.getPermissions());
				roles.add(ur);
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}
	}
    /**
     * truncate the whole table
     *
     * @exception java.sql.SQLException
     */
    public final void truncate()
        throws SQLException {

        String query = "truncate table sales_person_role";
   
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            if (Prefs.DEBUG) LogWrite.write(query);
            stmt.executeUpdate(query);
        } catch (SQLException e) {
            throw e;
        } finally {
            try { if (stmt != null) stmt.close();
            } catch (SQLException x) { }
        }
    }

}
