package sellwin.db;

import sellwin.domain.*;
import sellwin.utils.*;

import java.sql.*;
import java.util.ArrayList;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the DBInterface for
 * the UserRole class objects which are stored
 * in the user_role database table.
 */
public class UserRoleDB extends DBType implements DBInterface {
	private Connection con;
	private final static String deleteByNameQuery =
		"DELETE FROM user_role WHERE name = ";
	private final static String deleteQuery =
		"DELETE FROM user_role WHERE pk = ";
	private final static String deleteAllQuery =
		"DELETE FROM user_role";
	private final static String insertQuery =
		"INSERT INTO user_role " +
		"VALUES (";
	private final static String updateQuery = 
			"UPDATE user_role " +
			"SET ";
	private final static String selectAllQuery =
			"SELECT pk, name, "+
  			"modified_by, modified_date " +
			"FROM user_role ";
	private final static String selectQuery =
			"SELECT name, "+
  			"modified_by, modified_date " +
			"FROM user_role "+
			"WHERE pk = ";

	private final static String selectByNameQuery =
			"SELECT pk, "+
  			"modified_by, modified_date " +
			"FROM user_role "+
			"WHERE name = ";

	/**
	 * a do-nothing constructor but necessary to
	 * do the operations offered by this class
	 *
	 */
	public UserRoleDB() {
	}

	/**
	 * construct, specifying a particular db type
	 */
	public UserRoleDB(int dbType) {
		DB_TYPE = dbType;
	}
	

	/**
	 * a version of the constructor when a connection
	 * is already obtained from somewhere else
	 *
	 * @param con the Connection to use 
	 */
	public UserRoleDB(Connection con) {
		this.con = con;
	}

	/**
	 * return the Connection in use
	 *
	 * @return the Connection in use
	 */
	public Connection getConnection() {
		return this.con;
	}

	/**
	 * set the Connection to use 
	 *
	 * @param con the Connection to use for any future IO's
	 */
	public final void setConnection(Connection con) 
		throws SQLException {

		this.con = con;
	}

	/**
	 * select a single user_role row using the passed
	 * primary key
	 * 
	 * @param pk the primary key to search with
	 * @return the UserRole row(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final Object selectRow(Object pk) 
		throws SQLException {

		UserRole role = new UserRole("");
		role.setPK(((Long)pk).longValue());

		Statement stmt = null;
		ResultSet rs = null;
		String query = selectQuery + role.getPK();

		try {

			RolePermissionDB rolePermDB = new RolePermissionDB(DB_TYPE);
			rolePermDB.setConnection(getConnection());

			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			int i;

			while (rs.next()) {
				i=1;
				role.setName(rs.getString(i)); i++;
				role.setModifiedBy(rs.getString(i)); i++;
				role.setModifiedDate(rs.getDate(i)); 
				rolePermDB.selectRows(role.getPK(), role.getPermissions());
			}

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		return role;
	}


	/**
	 * update a single user_role row using the passed
	 * UserRole object's attributes.  All columns
	 * get updated by this routine regardless of whether
	 * an attribute was modified or not.
	 *
	 * @param obj the object we are updating
	 * @exception java.sql.SQLException 
	 */
	public final void updateRow(Object obj) 
		throws SQLException {

		UserRole user_role = (UserRole)obj;

		StringBuffer query = new StringBuffer(updateQuery);

		Statement stmt = con.createStatement();

		query.append("name=");
		query.append(JDBC.quoteMore(user_role.getName()));
		query.append("modified_by=");
		query.append(JDBC.quoteMore(user_role.getModifiedBy()));
		query.append("modified_date=");
		if (DB_TYPE == Prefs.MYSQL)
			query.append("CURRENT_DATE ");
		else
			query.append("SYSDATE ");
		query.append("WHERE pk = ").append(user_role.getPK());

		if (Prefs.DEBUG) LogWrite.write(query.toString());
		int updatedRows = stmt.executeUpdate(query.toString());
	}

	/**
	 * insert a new user_role row using the passed
	 * UserRole object as the column values.
	 * 
	 * @param obj the object we are inserting
	 * @param load true if loading, false if adding
	 * @return the newly assigned primary key of the new row
	 * @exception java.sql.SQLException 
	 */
	public final long insertRow(Object obj, boolean load) 
		throws SQLException {

		UserRole user_role = (UserRole)obj;

		if (!load)
			user_role.setPK(DBUtils.generatePK());

		StringBuffer query = new StringBuffer(insertQuery);
		Statement stmt = con.createStatement();

		query.append(user_role.getPK()).append(",");
		query.append(JDBC.quoteMore(user_role.getName()));
		query.append(JDBC.quoteMore(user_role.getModifiedBy()));
		if (DB_TYPE == Prefs.MYSQL)
			query.append("CURRENT_DATE");
		else
			query.append("SYSDATE");
		query.append(")");

		if (Prefs.DEBUG) LogWrite.write(query.toString());
		int rc = stmt.executeUpdate(query.toString());

		return user_role.getPK();
	}

	/**
	 * delete a single user_role row using the passed
	 * primary key value
	 *
	 * @param ojb primary key stored in a Long
	 * @exception java.sql.SQLException 
	 */
	public final void deleteRow(Object obj) 
		throws SQLException {

		long pkValue = ((Long)obj).longValue();

		String query = deleteQuery + pkValue;

		Statement stmt = null;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}
	}

	/**
	 * select all user_role rows
	 * 
	 * @param lastSyncDate a user's last sync date to compare against,
	 * if value is null, then don't use it
	 * @return the UserRole row(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final ArrayList selectAllRows(java.util.Date lastSyncDate) 
		throws SQLException {

		ArrayList roles = new ArrayList();
		Statement stmt = null;
		ResultSet rs = null;
		StringBuffer query = new StringBuffer();
		query.append(selectAllQuery);
		if (lastSyncDate != null) {
            query.append(" WHERE user_role.modified_date > ");
            query.append(DateUtils.formatDateTime(DB_TYPE, lastSyncDate));
		}

		query.append(" ORDER BY name");

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query.toString());
			rs = stmt.executeQuery(query.toString());

			int i;
			UserRole ur = null;

			while (rs.next()) {
				i=1;
				ur = new UserRole("");
				ur.setPK(rs.getLong(i)); i++;
				ur.setName(rs.getString(i)); i++;
				ur.setModifiedBy(rs.getString(i)); i++;
				ur.setModifiedDate(rs.getDate(i)); 
				roles.add(ur);
			}

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		return roles;
	}

	/**
	 * delete a single user_role row using the passed
	 * name key
	 *
	 * @param name the name of the UserRole we are deleting 
	 * @exception java.sql.SQLException 
	 */
	public final void deleteRowByName(String name) 
		throws SQLException {

		String query = deleteByNameQuery + "'" + name + "'";

		Statement stmt = null;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}
	}

	/**
	 * select a single user_role row using the passed
	 * primary key
	 * 
	 * @param name the name of the UserRole we are selecting
	 * @return the UserRole row(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final UserRole selectRowByName(String name) 
		throws SQLException {

		UserRole ur = new UserRole("");
		ur.setName(name);

		Statement stmt = null;
		ResultSet rs = null;
		String query = selectByNameQuery + "'" + name + "'";

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			int i;

			while (rs.next()) {
				i=1;
				ur.setPK(rs.getLong(i)); i++;
				ur.setModifiedBy(rs.getString(i)); i++;
				ur.setModifiedDate(rs.getDate(i)); 
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		return ur;
	}

	/**
	 * delete all user_role rows 
	 *
	 * @exception java.sql.SQLException 
	 */
	public final void deleteAllRows() 
		throws SQLException {

		String query = deleteAllQuery;

		Statement stmt = null;

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}
	}
    /**
     * truncate the whole table
     *
     * @exception java.sql.SQLException
     */
    public final void truncate()
        throws SQLException {

        String query = "truncate table user_role";
   
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            if (Prefs.DEBUG) LogWrite.write(query);
            stmt.executeUpdate(query);
        } catch (SQLException e) {
            throw e;
        } finally {
            try { if (stmt != null) stmt.close();
            } catch (SQLException x) { }
        }
    }

}
