package sellwin.domain;

import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class represents a 'person', 'contact', or physical mailing
 * address in the system.  Its goal is to capture all info about a user
 * or person in a consistent way.
 * This class holds column values found in the 'address' table.
 */
public class Address implements Serializable {
	public final static String[] STATES = {
"AL", "AK", "AZ", "AR",
"CA", "CO", "CT", "DE",
"DC", "FL", "GA", "HI",
"ID", "IL", "IN", "IA",
"KS", "KY", "LA", "ME",
"MD", "MA", "MI", "MN",
"MS", "MO", "MT", "NE",
"NV", "NH", "NJ", "NM",
"NY", "NC", "ND", "OH",
"OK", "OR", "PA", "RI",
"SC", "SD", "TN", "TX",
"UT", "VT", "VA", "WA",
"WV", "WI", "WY"
	};

	private long pk;
    private String firstName;
    private String lastName;
    private String middleInitial;
    private String addressLine1;
    private String addressLine2;
    private String title;
    private String phone;
    private String fax;
    private String pager;
    private String cell;
    private String email;
    private String city;
    private String state;
    private String country;
    private String zip;
    private String zip4;
    private String modifiedBy;
    private Date modifiedDate;
	private boolean modified=false;

	public Address() {
		pk=0;
    	firstName="";
    	lastName="";
	    middleInitial=" ";
   	 	addressLine1=" ";
   	 	addressLine2=" ";
   	 	title=" ";
   	 	phone=" ";
   	 	fax=" ";
   	 	pager=" ";
   	 	cell=" ";
   	 	email=" ";
   	 	city=" ";
   	 	state=" ";
   	 	country="USA";
   	 	zip=" ";
   	 	zip4=" ";
   	 	modifiedBy="";
		modifiedDate = new Date();
	}

	public final void setPK(long p) { pk = p; }
	public final void setCity(String s) { city = s; }
	public final void setState(String s) { state = s; }
	public final void setCountry(String s) { country = s; }
	public final void setZip(String s) { zip = s; }
	public final void setZip4(String s) { zip4 = s; }
	public final void setAddressLine1(String s) { addressLine1 = s; }
	public final void setAddressLine2(String s) { addressLine2 = s; }
	public final void setFirstName(String s) { firstName = s; }
	public final void setLastName(String s) { lastName = s; }
	public final void setMiddleInitial(String s) { middleInitial = s; }
	public final void setTitle(String s) { title = s; }
	public final void setPhone(String s) { phone = s; }
	public final void setFax(String s) { fax = s; }
	public final void setPager(String s) { pager = s; }
	public final void setCell(String s) { cell = s; }
	public final void setEmail(String s) { email = s; }
	public final void setModifiedBy(String s) { modifiedBy = s; }
	public final void setModifiedDate(Date s) { modifiedDate = s; }
	public final void setModified(boolean b) { modified = b; }

	public final long getPK() { return pk; }
	public final String getAddressLine1() { return addressLine1; }
	public final String getAddressLine2() { return addressLine2; }
	public final String getCity() { return city; }
	public final String getState() { return state; }
	public final String getCountry() { return country; }
	public final String getZip() { return zip; }
	public final String getZip4() { return zip4; }
	public final String getFirstName() { return firstName; }
	public final String getLastName() { return lastName ; }
	public final String getMiddleInitial() { return middleInitial; }
	public final String getTitle() { return title;}
	public final String getPhone() { return phone; }
	public final String getFax() { return fax; }
	public final String getPager() { return pager;}
	public final String getCell() { return cell; }
	public final String getEmail() { return email; }
	public final String getModifiedBy() { return modifiedBy; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final boolean isModified() { return modified; }

	public final String getFormattedName() {
		StringBuffer str = new StringBuffer();

		if (getLastName() == null) {
			;
		} else {
			str.append(getLastName()).append(", ");
		}

		if (getFirstName() == null) {
			;
		} else {
			str.append(getFirstName()).append(" ");
		}

		if (getMiddleInitial() == null) {
			;
		} else {
			str.append(getMiddleInitial());
		}

		return str.toString();
		//return getLastName() + ", " + getFirstName() + " " + getMiddleInitial();
	}

	public final void print() {
		System.out.println(" ADDRESS--->");
		System.out.println(" pk=" + pk);
    	System.out.println(" fname=["+ firstName + "]");
		System.out.println(" lname=["+ lastName + "]");
		System.out.println(" mi=["+ middleInitial + "]");
		System.out.println(" line1=["+ addressLine1 + "]");
		System.out.println(" line2=["+ addressLine2 + "]");
		System.out.println(" title=["+ title + "]");
		System.out.println(" phone=["+ phone + "]");
		System.out.println(" fax=["+ fax + "]");
		System.out.println(" pager=["+ pager + "]");
		System.out.println(" cell=["+ cell + "]");
		System.out.println(" email=["+ email + "]");
		System.out.println(" city=["+ city + "]");
		System.out.println(" state=["+ state + "]");
		System.out.println(" country=["+ country + "]");
		System.out.println(" zip=[" + zip + "]");
		System.out.println(" zip4=["+ zip4 + "]");
	}

	public final Address copy() {
		Address copy = new Address();
		copy.pk = pk;
		if (firstName != null)
    		copy.firstName = new String(firstName);
		if (lastName != null)
	    	copy.lastName = new String(lastName);
		if (middleInitial != null)
   		 	copy.middleInitial = new String(middleInitial);
		if (addressLine1 != null)
   		 	copy.addressLine1 = new String(addressLine1);
		if (addressLine2 != null)
   		 	copy.addressLine2 = new String(addressLine2);
		if (title != null)
   		 	copy.title = new String(title);
		if (phone != null)
   		 	copy.phone = new String(phone);
		if (fax != null)
   		 	copy.fax = new String(fax);
		if (pager != null)
   		 	copy.pager = new String(pager);
		if (cell != null)
   		 	copy.cell = new String(cell);
		if (email != null)
   		 	copy.email = new String(email);
		if (city != null)
   		 	copy.city = new String(city);
		if (state != null)
   		 	copy.state = new String(state);
		if (country != null)
   		 	copy.country = new String(country);
		if (zip != null)
   		 	copy.zip = new String(zip);
		if (zip4 != null)
   		 	copy.zip4 = new String(zip4);
		copy.modifiedDate = new Date(modifiedDate.getTime());
		copy.modified = modified;
		if (modifiedBy != null)
			copy.modifiedBy = new String(modifiedBy);

		return copy;
	}

	public static void copyFields(Address to, Address from) {
		to.setAddressLine1(from.getAddressLine1());
		to.setAddressLine2(from.getAddressLine2());
		to.setCity(from.getCity());
		to.setState(from.getState());
		to.setCountry(from.getCountry());
		to.setZip(from.getZip());
		to.setZip4(from.getZip4());
		to.setFirstName(from.getFirstName());
		to.setLastName(from.getLastName());
		to.setMiddleInitial(from.getMiddleInitial());
		to.setTitle(from.getTitle());
		to.setPhone(from.getPhone());
		to.setFax(from.getFax());
		to.setPager(from.getPager());
		to.setCell(from.getCell());
		to.setEmail(from.getEmail());
		to.setModified(from.isModified());
	}

	public final boolean diff(Address from) {
		if (!getAddressLine1().equals(from.getAddressLine1()))
			return true;
		if (!getAddressLine2().equals(from.getAddressLine2()))
			return true;
		if (!getCity().equals(from.getCity()))
			return true;
		if (!getState().equals(from.getState()))
			return true;
		if (!getCountry().equals(from.getCountry()))
			return true;
		if (!getZip().equals(from.getZip()))
			return true;
		if (!getZip4().equals(from.getZip4()))
			return true;
		if (!getFirstName().equals(from.getFirstName()))
			return true;
		if (!getLastName().equals(from.getLastName()))
			return true;
		if (!getMiddleInitial().equals(from.getMiddleInitial()))
			return true;
		if (!getTitle().equals(from.getTitle()))
			return true;
		if (!getPhone().equals(from.getPhone()))
			return true;
		if (!getFax().equals(from.getFax()))
			return true;
		if (!getPager().equals(from.getPager()))
			return true;
		if (!getCell().equals(from.getCell()))
			return true;
		if (!getEmail().equals(from.getEmail()))
			return true;

		return false;
	}
}
