package sellwin.domain;

import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class represents a person that is acting as an attendee to 
 * some activity (e.g. a meeting in a conference room).  This 
 * class holds data found in the 'attendee' database table.
 */
public class Attendee implements Serializable {
	private long pk;
	private long activity_pk;
	private long person_pk;
	private Address person;
	private String modifiedBy;
	private Date modifiedDate;


	public Attendee() {
		modifiedDate = new Date();
		pk=0;
		activity_pk=0;
		person_pk=0;
		modifiedBy="";
	}

	public final long getPK() { return pk; }
	public final void setPK(long pk) { this.pk = pk; }

	public final Address getPerson() { return person; }
	public final void setPerson(Address a) { person = a; }

	public final long getActivityPK() { return activity_pk; }
	public final void setActivityPK(long pk) { activity_pk = pk; }

	public final long getPersonPK() { return person_pk; }
	public final void setPersonPK(long pk) { person_pk = pk; }

	public final String getModifiedBy() { return modifiedBy; }
	public final void setModifiedBy(String s) { modifiedBy = s; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final void setModifiedDate(Date d) { modifiedDate=d; }

	public final void print() {
		System.out.println("Attendee");
		System.out.println("pk="+getPK());
		System.out.println("activity pk="+activity_pk);
		System.out.println("person pk="+person_pk);
		System.out.println("modified by ="+getModifiedBy());
		System.out.println("modified date ="+getModifiedDate());
	}

	public final Attendee copy() {
		Attendee copy = new Attendee();	
		copy.pk =  pk;
		copy.activity_pk =  activity_pk;
		copy.person_pk =  person_pk;
		if (modifiedBy != null)
			copy.modifiedBy = new String(modifiedBy);
		if (modifiedDate != null)
			copy.modifiedDate = new Date(modifiedDate.getTime());

		return copy;
	}
	
}
