package sellwin.domain;

import java.util.*;
import java.io.*;
import java.text.*;
import javax.swing.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class represents a marketing campaign and contains a list
 * of "leads".  Leads can eventually be converted into opportunities.
 * This class holds column values found in the 'campaign' database
 * table.
 */
public class Campaign implements  Serializable {
	private long pk;
	private String name;
	private String type;
	private String productGroup;
	private String productLine;
	private Integer leadCount; //conviently holds the count 
	private ArrayList leads = new ArrayList();
	private String modifiedBy;
	private Date modifiedDate;

	public Campaign() {
		modifiedDate = new Date();
	}

	public final void setPK(long pk) { this.pk = pk; }
	public final void setName(String n) { name = n;}
	public final void setType(String t) { type = t; }
	public final void setProductGroup(String d) { productGroup=d; }
	public final void setProductLine(String d) { productLine=d; }
	public final void setLeadCount(Integer d) { leadCount = d; }
	public final void addLead(Lead s) { leads.add(s); }
	public final void setModifiedBy(String d) { modifiedBy=d; }
	public final void setModifiedDate(Date d) { modifiedDate=d; }

	public final long getPK() { return pk; }
	public final String getName() { return name; }
	public final String getType() { return type; }
	public final String getProductGroup() { return productGroup; }
	public final String getProductLine() { return productLine; }
	public final Integer getLeadCount() { return leadCount; }
	public final ArrayList getLeads() { return leads; }
	public final String getModifiedBy() { return modifiedBy; }
	public final Date getModifiedDate() { return modifiedDate; }

	public final Campaign copy() {
		Campaign copy = new Campaign();
		copy.setPK(getPK());
		if (name != null)
			copy.name = new String(name);
		if (type != null)
			copy.type = new String(type);
		if (productGroup != null)
			copy.productGroup = new String(productGroup);
		if (productLine != null)
			copy.productLine = new String(productLine);
		if (leadCount != null)
			copy.leadCount = new Integer(leadCount.intValue());

		Lead leadCopy, lead;
		for (int i=0;i<leads.size();i++) {
			lead = (Lead)leads.get(i);
			leadCopy = lead.copy();
			copy.leads.add(leadCopy);
		}
		if (modifiedBy != null)
			copy.modifiedBy = new String(modifiedBy);
		copy.modifiedDate = new Date(modifiedDate.getTime());

		return copy;
	}

	public final void print() {
		System.out.println("<<Campaign>>");
		System.out.println("pk=["+getPK()+"]");
		System.out.println("Name=["+getName()+"]");
		System.out.println("Type="+getType());
		System.out.println("Group="+getProductGroup());
		System.out.println("Line="+getProductLine());
		System.out.println("Lead Count="+getLeadCount());
		System.out.println("ModifiedBy/Date="+getModifiedBy()+getModifiedDate());
	}
}
