package sellwin.domain;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


import java.io.*;
import java.net.*;
import java.util.*;

/**
 * information about a Chat user's connection, this class
 * is stored in a global list by the ChatServer and is used
 * as a reference to see who is logged on and who is not
 */
public class ChatConnInfo {
	/** the sender or user ID of a chat client */
	public String sender;

	public String getSender() { return sender; }

	/** the sender's output stream, used to write back messages */
    public ObjectOutputStream oos;
	public ObjectOutputStream getOOS() { return oos; }

	/** the last date known about a chat user's connection */
    public java.util.Date connectedSince;
	public java.util.Date getConnectedSince() { return connectedSince; }

	/**
	* construct the chat info
	*/
    public ChatConnInfo(String sender, ObjectOutputStream oos, java.util.Date dt) {
		this.sender = sender;
       	this.oos = oos;
        connectedSince = dt;
	}

	/**
	* test to see if the user is still connected, compare
	* against the last known time and a maximum
	* @return true if the user is deemed as still connected and
	* online, false if not	
	*/
    public boolean stillConnected() {
    	java.util.Date rightNow = new java.util.Date();
        long TIME_MAX = 1000 * 60 * 2; //2 minute
		long rightNowMillis = rightNow.getTime();
		long connectedMillis = connectedSince.getTime();
		long diff = rightNowMillis - connectedMillis;
		if (diff > TIME_MAX) 
			return false;
		else
			return true;
    }
}
