package sellwin.domain;

import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class represents a customer in the system.
 * This class holds column values found in the 'customer' database
 * table.
 */
public class Customer implements Serializable {

	public final static String UNASSIGNED = "Unassigned";

	private long pk; //primary key
	private String name;  //unique 
	private Address shipAddress;
	private Address billAddress;
	private int annualSales;
	private String industry;
	private String channel;
	private Address contact;
	private String modifiedBy;
	private Date modifiedDate;
	private boolean updatedLocally=false;
	private boolean addedLocally=false;
	private ArrayList inventory = new ArrayList(); //array of CustomerInventory objects

	public Customer() {
		annualSales = 0;
		industry="";
		channel="";
		modifiedDate = new Date();
		shipAddress = new Address();
		billAddress = new Address();
		contact = new Address();
	}

	public final void clear() {
		name = UNASSIGNED;
		annualSales = 0;
		industry = "";	
		channel = "";
		for (int i = 0; i < inventory.size(); i++) {
			inventory.remove(i);
		}
	}

	public final void setPK(long l) { pk = l; }
	public final long getPK() { return pk; }

	public final void setBillAddress(Address a) { billAddress = a; }
	public final Address getBillAddress() { return billAddress; }
	public final void setShipAddress(Address a) { shipAddress = a; }
	public final Address getShipAddress() { return shipAddress; }

	public final void setModifiedDate(Date d) { 
		modifiedDate = d; 
		getBillAddress().setModifiedDate(d);
		getShipAddress().setModifiedDate(d);
		getContact().setModifiedDate(d);
	}
	public final Date getModifiedDate() { return modifiedDate; }

	public final void setModifiedBy(String b) { 
		modifiedBy = b; 
		getBillAddress().setModifiedBy(b);
		getShipAddress().setModifiedBy(b);
		getContact().setModifiedBy(b);
	}
	public final String getModifiedBy() { return modifiedBy; }

	public final void addInventory(CustomerInventory inv) {
		inventory.add(inv);
	}

	public final ArrayList getInventory() { return inventory; }

	public final void setName(String name) {
		this.name = name;
	}

	public final String getName() { return name; }

	public final void setAnnualSales(int x) {
		annualSales = x;
	}

	public final int getAnnualSales() { return annualSales; }

	public final void setChannel(String s) {
		channel = s;
	}

	public final String getChannel() { return channel; }

	public final void setIndustry(String s) {
		industry = s;
	}

	public final String getIndustry() { return industry; }

	public final void setContact(Address s) {
		contact = s;
	}

	public final Address getContact() { return contact; }

	public final void setInventory(ArrayList p) {
		inventory = p;
	}

	public final void setUpdatedLocally(boolean b) { updatedLocally=b; }
	public final void setAddedLocally(boolean b) { addedLocally=b; }
	public final boolean getUpdatedLocally() { return updatedLocally; }
	public final boolean getAddedLocally() { return addedLocally; }

	public final Customer copy() {
		Customer copy = new Customer();

		copy.pk = pk;

		if (billAddress != null)
			copy.billAddress = billAddress.copy();
		if (shipAddress != null)
			copy.shipAddress = shipAddress.copy();
		if (name != null)
			copy.name = new String(name);
		copy.annualSales = annualSales;
		if (industry != null)
			copy.industry = new String(industry);
		if (channel != null)
			copy.channel = new String(channel);
		if (contact != null)
			copy.contact = contact.copy();

		CustomerInventory product, productCopy;	
		ArrayList inventory = getInventory();
		for (int i=0;i<inventory.size();i++) {
			product = (CustomerInventory)inventory.get(i);
			productCopy = product.copy();
			copy.addInventory(productCopy);
		}
		return copy;
	}
	
	public final void print() {
		System.out.println("<<CUSTOMER"+name+">>");
		System.out.println("pk ="+ pk);
		System.out.println("Annual Sales="+ annualSales);
		System.out.println("Industry="+industry);
		System.out.println("Channel="+channel);
		CustomerInventory inv=null;
		for (int i=0;i<inventory.size();i++) {
			inv = (CustomerInventory)inventory.get(i);
			inv.print();
		}
	}
}
