package sellwin.domain;

import java.math.*;
import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class represents product inventory that is known to be  
 * owned by a customer.  This info might be derived from previous
 * sales to a customer.  This class holds column values found in the
 * database table 'customer_inventory'.
 */
public class CustomerInventory implements Serializable {
	private long pk;
	private Product product;
	private Integer cnt;
	private String modifiedBy;
	private Date modifiedDate;
	private boolean addedLocally=false;

	//next attribute is a convient way to get the parent
	private long customerPK; //pointer to parent
	
	public CustomerInventory() {
		product = null; //null cuz it is illogical to have a dummy prod
		cnt = new Integer(0);
		modifiedDate = new Date();
		customerPK = 0;
	}

	public CustomerInventory(Product n, Integer ct) {
		product = n;
		cnt = ct;
	}

	public final void setPK(long pk) { this.pk = pk; }
	public final void setCustomerPK(long pk) { this.customerPK = pk; }
	public final void setProduct(Product n) { product = n; }
	public final void setCount(Integer i) { cnt = i; }
	public final void setModifiedBy(String s) { modifiedBy = s; }
	public final void setModifiedDate(Date d) { modifiedDate = d; }
	public final void setAddedLocally(boolean t) { addedLocally = t; }

	public final long getPK() { return pk; }
	public final long getCustomerPK() { return customerPK; }
	public final Product getProduct() { return product; }
	public final Integer getCount() { return cnt; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final String getModifiedBy() { return modifiedBy; }
	public final boolean getAddedLocally() { return addedLocally; }

	public final CustomerInventory copy() {
		Product copyProd = getProduct().copy();
		Integer copyCnt = new Integer(getCount().intValue());
		CustomerInventory copy = new CustomerInventory(copyProd, copyCnt);
		copy.modifiedBy = new String(modifiedBy);
		copy.modifiedDate = new Date(modifiedDate.getTime());
		copy.customerPK = customerPK;
		return copy;
	}

	public final void print() {
		System.out.println("<<Customer Inventory>>");
        System.out.println("pk=["+getPK()+"]");
		getProduct().print();
        System.out.println("Count="+getCount());
        System.out.println("ModifiedDate="+getModifiedDate());
        System.out.println("ModifiedBy="+getModifiedBy());
	}
}
