package sellwin.domain;

import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class represents the information about a deleted
 * object that is important to us.  This is necessary since
 * we can delete objects on the local client in 'disconnected'
 * mode and then resync these deletes back to the server.
 *
 * This information is recorded when an object is deleted.  It
 * is used at 'sync' time.
 */
public class DeleteInfo implements Serializable {

	public long pk; //primary key
	public String className; 

	public DeleteInfo(long pk, String clname) {
		this.pk=pk;
		className = clname;
	}

}
