package sellwin.domain;

import java.util.*;
import java.io.*;
import java.text.*;
import javax.swing.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class represents a 'lead' in SellWin.  A lead
 * is stored in the 'lead' table in the database.
 */
public class Lead implements  Serializable {
	private long pk;
	private long campaignKey;
	private Address address;
	private String company;
	private String interestLevel;
	private SalesPerson contactedBy;
	private Date contactDate;
	private Boolean convertedToOpp;
	private String modifiedBy;
	private Date modifiedDate;
	private boolean updatedLocally=false;
	private boolean addedLocally=false;

	public Lead() {
		pk=0; campaignKey=0; 
		address = new Address();
		company="";
		interestLevel="";
		contactedBy = new SalesPerson();
		contactDate = null;
		convertedToOpp = new Boolean(false);
		modifiedDate = new Date();
		modifiedBy = "";
	}

	public final void setPK(long pk) { this.pk = pk; }
	public final void setCampaignKey(long pk) { campaignKey = pk; }
	public final void setAddress(Address n) { address = n;}
	public final void setCompany(String t) { company = t; }
	public final void setInterestLevel(String d) { interestLevel=d; }
	public final void setContactedBy(SalesPerson d) { contactedBy=d; }
	public final void setContactDate(Date d) { contactDate = d; }
	public final void setConverted(Boolean d) { convertedToOpp = d; }
	public final void setModifiedDate(Date d) { modifiedDate = d; }
	public final void setModifiedBy(String d) { modifiedBy = d; }
	public final void setUpdatedLocally(boolean b) { updatedLocally=b; }
	public final void setAddedLocally(boolean b) { addedLocally=b; }

	public final long getPK() { return pk; }
	public final long getCampaignKey() { return campaignKey; }
	public final Address getAddress() { return address; }
	public final String getCompany() { return company; }
	public final String getInterestLevel() { return interestLevel; }
	public final SalesPerson getContactedBy() { return contactedBy; }
	public final Date getContactDate() { return contactDate; }
	public final Boolean getConverted() { return convertedToOpp; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final String getModifiedBy() { return modifiedBy; }
	public final boolean getUpdatedLocally() { return updatedLocally; }
	public final boolean getAddedLocally() { return addedLocally; }


	public final Lead copy() {
		Lead copy = new Lead();
		copy.setPK(getPK());
		if (address != null)
			copy.address = address.copy();
		if (company != null)
			copy.company = new String(company);
		if (interestLevel != null)
			copy.interestLevel = new String(interestLevel);
		if (contactedBy != null)
			copy.contactedBy = contactedBy.copy();
		if (contactDate != null)
			copy.contactDate = new Date(contactDate.getTime());
		copy.convertedToOpp = new Boolean(convertedToOpp.booleanValue());
		if (modifiedBy != null)
			copy.modifiedBy = new String(modifiedBy);
		copy.modifiedDate = new Date(modifiedDate.getTime());

		return copy;
	}

	public final void print() {
		System.out.println("<<Lead>>");
		System.out.println("pk=["+getPK()+"]");
		address.print();
		System.out.println("company=["+getCompany()+"]");
		System.out.println("InterestLevel="+getInterestLevel());
		contactedBy.print();
		System.out.println("ContactDate="+getContactDate());
		System.out.println("Converted="+getConverted());
		System.out.println("Modified By/Date="+modifiedBy + modifiedDate);
	}
}
