package sellwin.domain;

import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class contains data about an opportunity
 * in a minimal form to be used to prompt the user
 * in the OppIndex dialog.  This way we don't have
 * to read in all Opportunity data prior to it being used
 */
public class OppIndex implements Serializable {
	private String name;
	private String stage;
	private long pk;

	public OppIndex() {
	}

	public OppIndex(String name, String stage, long pk) {
		this.name = name;
		this.stage = stage;
		this.pk = pk;
	}

	public final String getName() { return name; }
	public final void setName(String s) { name = s; }

	public final String getStage() { return stage; }
	public final void setStage(String s) { stage = s; }

	public final long getPK() { return pk; }
	public final void setPK(long pk) { this.pk = pk; }

	public final void print() {
		System.out.println("<<OPP INDEX>>");
		System.out.println("name=["+name+"]");
		System.out.println("stage=["+stage+"]");
		System.out.println("pk="+pk);
	}
}
