package sellwin.domain;

import java.util.*;
import java.io.*;
import java.text.*;
import javax.swing.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class represents an Order in Sellwin, an order is
 * owned by a particular Opportunity.  Order objects relate
 * to the Order table in the database.
 */
public class Order implements  Serializable {

	public static final String[] METHODS =  { 
		"VISA Card", "Send Bill", "American Express" };

	public static final String STATUS_OPEN = "Open";
	public static final String STATUS_CLOSED = "Closed";
	public static final String STATUS_SUBMITTED = "Submitted";
	public static final String STATUS_CANCELLED = "Cancelled";

	public static final String[] STATUS =  { 
		STATUS_OPEN, STATUS_CLOSED, STATUS_SUBMITTED, STATUS_CANCELLED };

	private long pk;
	private long oppPK;
	private Long orderNumber;
	private Quote quote;
	private long quotePK;
	private long shipAddressPK;
	private Address shipAddress;
	private long billAddressPK;
	private Address billAddress;
	private String status;
	private String paymentForm;
	private double subTotal=0.00;
	private double tax=0.00;
	private double shipping=0.00;
	private double total=0.00;
	private String modifiedBy;
	private Date modifiedDate;
	private boolean updatedLocally=false;
	private boolean addedLocally=false;

	public Order() {
		status = STATUS_OPEN;
		modifiedDate = new Date();
		paymentForm = METHODS[0];
	}

	public final void setPK(long pk) { this.pk = pk; }
	public final void setOppKey(long pk) { oppPK = pk; }
	public final void setOrderNumber(Long o) { orderNumber = o; }
	public final void setModifiedBy(String n) { modifiedBy = n;}
	public final void setModifiedDate(Date n) { modifiedDate = n;}
	public final void setStatus(String n) { status = n;}
	public final void setPaymentForm(String s) { paymentForm = s; }
	public final void setSubTotal(double d) { subTotal = d; }
	public final void setTax(double d) { tax = d; }
	public final void setShipping(double d) { shipping = d; }
	public final void setTotal(double d) { total = d; }
	public final void setQuote(Quote q) { 
		quote = q; }
	public final void setQuoteKey(long q) { quotePK = q; }
	public final void setShipAddress(Address a) { shipAddress = a; }
	public final void setBillAddress(Address a) { billAddress = a; }
	public final void setBillAddressKey(long q) { billAddressPK = q; }
	public final void setShipAddressKey(long q) { shipAddressPK = q; }
	public final void setUpdatedLocally(boolean b) { updatedLocally=b; }
	public final void setAddedLocally(boolean b) { addedLocally=b; }


	public final long getPK() { return pk; }
	public final long getOppKey() { return oppPK; }
	public final Long getOrderNumber() { return orderNumber; }
	public final String getStatus() { return status; }
	public final String getModifiedBy() { return modifiedBy; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final String getPaymentForm() { return paymentForm; }
	public final double getSubTotal() { return subTotal; }
	public final double getTax() { return tax; }
	public final double getShipping() { return shipping; }
	public final double getTotal() { return total; }
	public final Quote getQuote() { return quote; }
	public final long getQuoteKey() { return quotePK; }
	public final Address getShipAddress() { return shipAddress; }
	public final Address getBillAddress() { return billAddress; }
	public final long getShipAddressKey() { return billAddressPK; }
	public final long getBillAddressKey() { return billAddressPK; }
	public final boolean getUpdatedLocally() { return updatedLocally; }
	public final boolean getAddedLocally() { return addedLocally; }

	public final Order copy() {
		Order copy = new Order();
		copy.setPK(getPK());
		copy.setOrderNumber(new Long(getOrderNumber().longValue()));
		copy.setShipAddress(shipAddress.copy());
		copy.setBillAddress(billAddress.copy());
		copy.status = new String(status);
		if (modifiedBy != null)
			copy.modifiedBy = new String(modifiedBy);
		if (modifiedDate != null)
			copy.modifiedDate = new Date(modifiedDate.getTime());

		copy.setSubTotal(subTotal);
		copy.setTax(tax);
		copy.setShipping(shipping);
		copy.setTotal(total);

		if (quote != null) 
			copy.quote = quote.copy();

		if (paymentForm != null)
			copy.paymentForm = new String(paymentForm);

		return copy;
	}

	public final void print() {
		System.out.println("<<Order>>");
		System.out.println("pk=["+getPK()+"]");
		System.out.println("orderNumber=["+getOrderNumber()+"]");
		System.out.println("status=["+getStatus()+"]");
		System.out.println("subTotal=["+getSubTotal()+"]");
		System.out.println("tax=["+getTax()+"]");
		System.out.println("Shipping=["+getShipping()+"]");
		System.out.println("Total=["+getTotal()+"]");
		System.out.println("ship addr pk="+getShipAddress().getPK());
		System.out.println("bill addr pk="+getBillAddress().getPK());
		System.out.println("Modified By=["+getModifiedBy()+"]");
		System.out.println("Modified On=["+getModifiedDate()+"]");
	}
}
