package sellwin.domain;

import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * represents the permissions that are associated to a role
 * since a 'user role' has a 1-->many relationship to this class
 * we carry the 'user role' pk in this child class for a convienience
 */
public class RolePermission implements Serializable {
	final public static String PERM_FORECAST="Forecast";
	final public static String PERM_QUOTE="Quote";
	final public static String PERM_ACTIVITY="Activity";
	final public static String PERM_BASIC_ADMIN="Basic Admin";
	final public static String PERM_USER_ADMIN="User Admin";
	final public static String PERM_ORDER="Order";

	private long pk;
	private long user_role_pk; //parent user role
	private String name;
	private boolean read;
	private boolean write;
	private String modifiedBy;
	private Date modifiedDate;

	public RolePermission() {
		pk=0; 
		user_role_pk=0;
		name = "";	
		read = false;
		write = false;
		modifiedBy="";
		modifiedDate=new Date();
	}

	final public void print() {
		System.out.print("Perm="+name+"\t:");
		if (isReadable())
			System.out.print("r");
		if (isWritable())
			System.out.println("w");
		System.out.println("");
	}

	public final long getPK() { return pk; }
	public final void setPK(long pk) { this.pk = pk; }
	public final long getUserRolePK() { return user_role_pk; }
	public final void setUserRolePK(long pk) { user_role_pk = pk; }

	public final void setName(String r) { name=r; }
	public final String getName() { return name; }

	public final boolean getRead() { return read; }
	public final void setRead(boolean b) { read=b; }
	public final boolean getWrite() { return write; }
	public final void setWrite(boolean b) { write=b; }
	public final boolean isReadable() { return read; }
	public final boolean isWritable() { return write; }

	public final String getModifiedBy() { return modifiedBy; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final void setModifiedBy(String by) { modifiedBy = by; }
	public final void setModifiedDate(Date dt) { modifiedDate = dt; }

	public final RolePermission copy() {
		RolePermission copy = new RolePermission();
		copy.name = new String(name);
		copy.pk = pk;
		copy.read = read;
		copy.write = write;
		copy.user_role_pk = user_role_pk;
		copy.setModifiedBy(new String(modifiedBy));
		copy.setModifiedDate(new Date(modifiedDate.getTime()));

		return copy;
	}
}
