package sellwin.domain;

import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class relates to the 'sales_person' table in
 * the database.
 */
public class SalesPerson implements Serializable {
	public static final String UNASSIGNED="Unassigned";
	private long pk;
	private String id;
	private String password;
	private Address address;
	private Date syncDate;
	private String modifiedBy;
	private Date modifiedDate;
	private ArrayList userGroups = new ArrayList();
	private ArrayList roles = new ArrayList();

	public SalesPerson() {
		pk = new java.util.Date().getTime();
		id = "";
		password = "changeme";
		address = new Address();
		modifiedDate = new Date();
	}

	public SalesPerson(String id, String psw, UserGroup g) {
		pk = new java.util.Date().getTime();
		this.id = id;
		this.password = psw;
		userGroups.add(g);
		address = new Address();
		modifiedDate = new Date();
	}

	public final void setModifiedBy(String s) { modifiedBy = s; }
	public final String getModifiedBy() { return modifiedBy; }
	public final void setSyncDate(Date s) { syncDate = s; }
	public final void setModifiedDate(Date s) { modifiedDate = s; }

	public final Date getSyncDate() { return syncDate; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final void setPK(long p) { pk = p; }
	public final void setAddress(Address s) { address = s; }
	public final Address getAddress() { return address; }

	public final void addUserRole(UserRole g) 
		throws AngError {

		UserRole role;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			if (role.getName().equals(g.getName())) 
				throw new AngError("That role has already been added.");
		}
		roles.add(g);
	}

	public final void removeUserRole(String name) {
		UserRole role;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			if (role.getName().equals(name)) {
				roles.remove(i);
				return;
			}
		}
	}

	public final void addUserGroup(UserGroup g) { 
		userGroups.add(g);
	}

	public final long getPK() { return pk; }

	public final ArrayList getUserRoles() {
		return roles;
	}

	public final ArrayList getUserGroups() {
		return userGroups;
	}


	public final String getID() {
		return id;
	}

	public final void setID(String id) {
		this.id = id;
	}

	public final String getPassword() {
		return password;
	}

	public final void setPassword(String psw) {
		password = psw;
	}

	public final void print() {
		System.out.println("SalesPerson "+pk);
		System.out.println( "id="+id);
		System.out.println( "password="+password);
		System.out.println( "syncDate="+syncDate);
		getAddress().print();
		UserGroup userGroup = null;
		System.out.println("UserGroups");
		for (int i=0;i<userGroups.size();i++) {
			userGroup = (UserGroup)userGroups.get(i);
			userGroup.print();
		}

		System.out.println("UserRoles");
		UserRole role = null;
		for (int j=0;j<roles.size();j++) {
			role = (UserRole)roles.get(j);
			role.print();
		}
	}

	public final SalesPerson copy() {
		SalesPerson copy = new SalesPerson();
		copy.pk = pk;
		if (id != null)
			copy.id = new String(id);
		if (password != null)
			copy.password = new String(password);
		copy.setAddress(getAddress().copy());

		UserGroup userGroupCopy, userGroup;
		for (int i=0;i<userGroups.size();i++) {
			userGroup = (UserGroup)userGroups.get(i);
			copy.addUserGroup(userGroup.copy());
		}

		UserRole roleCopy, role;
		for (int i = 0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			try {
				copy.addUserRole(role.copy());
			} catch (AngError e) {}
		}

		copy.syncDate = new Date(syncDate.getTime());
		copy.modifiedDate = new Date(modifiedDate.getTime());
		copy.modifiedBy = new String(modifiedBy);
		return copy;
	}

}
