package sellwin.domain;

import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class relates aa predefined 'user_role' to an individual
 * sales person.  A sales person can have multiple roles in Sellwin.
 * this object holds column values from the 'sales_person_role' database
 * table
 */
public class SalesPersonRole implements Serializable {
	private long pk;
	private long salesPersonPK; //parent sales person key
	private long userRolePK; 
	private UserRole role;
	private String modifiedBy;
	private Date modifiedDate;

	public SalesPersonRole() {
		pk=0; 
		salesPersonPK=0;	
		userRolePK=0;	
		modifiedBy="";
		modifiedDate=new Date();
	}

	public final long getPK() { return pk; }
	public final void setPK(long pk) { this.pk = pk; }
	public final long getSalesPersonPK() { return salesPersonPK; }
	public final void setSalesPersonPK(long pk) { salesPersonPK = pk; }
	public final long getUserRolePK() { return userRolePK; }
	public final void setUserRolePK(long pk) { userRolePK = pk; }

	public final void setUserRole(UserRole r) { role=r; }
	public final UserRole getUserRole() { return role; }

	public final String getModifiedBy() { return modifiedBy; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final void setModifiedBy(String by) { modifiedBy = by; }
	public final void setModifiedDate(Date dt) { modifiedDate = dt; }

	public final void print() {
		System.out.println("SalesPersonRole");
		System.out.println("pk="+pk + " salesPersonPK="+salesPersonPK);
		role.print();
		System.out.println("Modified = "+modifiedDate + modifiedBy);
	}

	public final SalesPersonRole copy() {
		SalesPersonRole copy = new SalesPersonRole();
		copy.role = role.copy();
		copy.pk = pk;
		copy.salesPersonPK = salesPersonPK;
		copy.userRolePK = userRolePK;
		copy.setModifiedBy(new String(modifiedBy));
		copy.setModifiedDate(new Date(modifiedDate.getTime()));

		return copy;
	}
}
