package sellwin.domain;

import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class represents info about a U.S. State
 * including name, long name, and tax rate.
 */
public class StateTax implements Serializable {

    private String code;
	private double rate;
    private String fullName;
    private String modifiedBy;
    private Date modifiedDate;

	public StateTax() {
	}

	public final String getCode() { return code; }
	public final void setCode(String c) { code = c; }

	public final double getRate() { return rate; }
	public final void setRate(double r) { rate = r; }

	public final String getFullName() { return fullName; }
	public final void setFullName(String s) { fullName = s; }

	public final void setModifiedBy(String s) { modifiedBy = s; }
	public final String getModifiedBy() { return modifiedBy; }

	public final void setModifiedDate(Date s) { modifiedDate = s; }
	public final Date getModifiedDate() { return modifiedDate; }

	public final void print() {
		System.out.println(" code=[" + code + "]");
		System.out.println(" rate=[" + rate + "]");
    	System.out.println(" fullName=["+ fullName + "]");
		System.out.println(" modifiedBy=[" + modifiedBy + "]");
		System.out.println(" modifiedDate=["+ modifiedDate + "]");
	}
}
