package sellwin.domain;

import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class represents the relationship between a 'user_group'
 * and an individual sales person.  This class holds columns found
 * in the 'user_group_member' database table;
 */
public class UserGroupMember implements Serializable {
	private long pk;
	private long user_group_pk;
	private long user_pk;
	private SalesPerson user;
	private String modifiedBy;
	private Date modifiedDate;

	public UserGroupMember() {
		pk=0;
		user_group_pk=0;
		user_pk=0;
		modifiedDate = new Date();
		modifiedBy = "";
	}

	public final void setPK(long pk) { this.pk = pk; }
	public final long getPK() { return pk; }
	public final void setUser(SalesPerson s) { user = s; }
	public final SalesPerson getUser() { return user; }
	public final void setModifiedBy(String by) { modifiedBy = by; }
	public final void setModifiedDate(Date dt) { modifiedDate = dt; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final String getModifiedBy() { return modifiedBy; }

	public final void setUserGroupPK(long pk) { user_group_pk = pk; }
	public final long getUserGroupPK() { return user_group_pk; }
	public final void setUserPK(long pk) { user_pk = pk; }
	public final long getUserPK() { return user_pk; }

	public final void print() {
		System.out.println("UserGroupMember");
		System.out.println("pk="+pk);
		System.out.println("ug pk="+ user_group_pk);
		System.out.println("u pk="+ user_pk);
	}

	public final UserGroupMember copy() {
		UserGroupMember copy = new UserGroupMember();
		copy.pk = pk;
		copy.user_group_pk = user_group_pk;
		copy.user_pk = user_pk;
		copy.setModifiedBy(new String(modifiedBy));
		copy.setModifiedDate(new Date(modifiedDate.getTime()));
		return copy;
	}
}

