package sellwin.domain;

import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class represents an individual role defined in the system.
 * This class holds column values in the 'user_role' database table
 */
public class UserRole implements Serializable {

	final public static String ROLE_SALES_REP="Sales Rep";
	final public static String ROLE_SALES_MGR="Sales Mgr";
	final public static String ROLE_SALES_SUPPORT="Sales Support";
	final public static String ROLE_SYSTEM_ADMIN="System Admin";
	final public static String ROLE_MKT_REP="Marketing Rep";

	private long pk;
	private String name;
	private String modifiedBy;
	private Date modifiedDate;
	private ArrayList perms = new ArrayList();

	public UserRole() {
	}

	public UserRole(String n) {
		name = n;
		modifiedBy="";
		modifiedDate=new Date();
	}

	public final void setPK(long i) { pk = i; }
	public final long getPK() { return pk; }

	public final String getName() { return name; }
	public final void setName(String n) { name = n; }

	public final void addPermission(RolePermission p) { perms.add(p); }
	public final ArrayList getPermissions() { return perms; }

	public final String getModifiedBy() { return modifiedBy; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final void setModifiedBy(String by) { modifiedBy = by; }
	public final void setModifiedDate(Date dt) { modifiedDate = dt; }


	public final void print() {
		System.out.println("UserRole = "+getName() + " pk=" + pk);
		RolePermission perm;
		for (int i=0;i<perms.size();i++) {
			perm = (RolePermission)perms.get(i);
			perm.print();
		}
	}

	public final UserRole copy() {
		UserRole copy = new UserRole(new String(name));
		copy.pk = pk;

		for (int i=0;i<perms.size();i++) {
			copy.perms.add(perms.get(i));
		}

		copy.setModifiedBy(new String(modifiedBy));
		copy.setModifiedDate(new Date(modifiedDate.getTime()));

		return copy;
	}

	final public boolean isSalesRep() {
		if (name.equals(ROLE_SALES_REP))
			return true;
		return false;
	}

	final public boolean isSalesMgr() {
		if (name.equals(ROLE_SALES_MGR)) return true;
		return false;
	}

	final public boolean isSalesSupport() {
		if (name.equals(ROLE_SALES_SUPPORT)) return true;
		return false;
	}

	final public boolean isSystemAdmin() {
		if (name.equals(ROLE_SYSTEM_ADMIN)) return true;
		return false;
	}

	final public boolean isMarketingRep() {
		if (name.equals(ROLE_MKT_REP)) return true;
		return false;
	}
}
