package sellwin.gui;

import sellwin.domain.*;
import sellwin.utils.*;
import javax.swing.*;
import java.util.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class is run in a separate thread in the
 * Swing GUi to check for alarms associated with 
 * this user's set of activities across all 
 * of the user's opportunities and for alarms
 * set by other users where this user is a 
 * a member of the group of recipients.
 */
public class ActivityChecker extends Thread {
	private Whiteboard wb;
	private Runnable runnable;
	private static final int ACT_CHK_TIME = 1000 * 60 * 5; //5 minutes
	private ArrayList alarms=null;
	
	/**
	 * this method is called by Swing as it processes
	 * it's event queue which gets populated by the invokeLater()
	 * below
	 */
	public ActivityChecker()  {

		wb = MainWindow.getWhiteboard();

		runnable = new Runnable() {
			public void run() {
				Activity alarm;
				AlarmDialog ad;
				LogWrite.write("ActivityChecker sees "+ alarms.size() + " alarms");
				for (int i=0;i<alarms.size();i++) {
					alarm = (Activity)alarms.get(i);
					ad = new AlarmDialog(MainWindow.getMainParent(), false, alarm);
					ad.show();
				}
			}
		};
	}

	/**
	 * the main entry point for this Thread, an infinite loop that
	 * wakes up every so often (ACT_CHK_TIME), does some checking to
	 * see if we need to process some activities, and then queue a 
	 * request to Swing's internal event queue processing mechanism,
	 * then go back to waiting for the next wakeup.
	*/
	public void run() {
		try {
			while (true) {
				sleep(ACT_CHK_TIME);
				try {
					alarms = wb.getAlarms();
				} catch (AngError x) {
					ErrorHandler.show(MainWindow.getMainParent(), x);
				}
				SwingUtilities.invokeLater(runnable);
			}
		} catch (Exception e) {
			ErrorHandler.show(MainWindow.getMainParent(), e);
		}
	}

}
		
