package sellwin.gui;

import javax.swing.*;

import sellwin.domain.*;
import sellwin.utils.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * this class implements a pop up dialog to show a
 * user's alarms...after which, the user can elect
 * to forget the alarm or be reminded of the alarm
 * later on
 */
public class AlarmDialog extends javax.swing.JDialog implements GUIChars {

	private Activity act;
	private Whiteboard wb=null;

    /** 
	 * Creates new form AlarmDialog 
	 * @param parent the parent frame for this dialog 
	 * @param modal is this dialog to be modal or not
	 * @param act the Activity to display on this dialog
	 */
    public AlarmDialog(java.awt.Frame parent, boolean modal, Activity act) {
        super(parent, modal);
		this.act = act;
		wb = MainWindow.getWhiteboard();
        initComponents();
		setActivity(act);
		setColors();
		setFonts();
		setLang();
		setSize(300, 150);
    }

	/**
	 * set this dialog's Activity to display
	 * @param a the Activity to display
	 */
	private final void setActivity(Activity a) {
        activityLabel.setText(a.getSubject());
        startDateLabel.setText(Prefs.dateTimeFormat.format(a.getStartDate()));
        byLabel.setText(a.getModifiedBy());
	}

    /** 
	 * This method is called from within the constructor to
     * initialize the form.
     */
    private final void initComponents() {
        buttonPanel = new JPanel();
        remindButton = new JButton();
        forgetButton = new JButton();
        mainPanel = new JPanel();
        jLabel1 = new JLabel();
        jLabel2 = new JLabel();
        jLabel3 = new JLabel();
        activityLabel = new JLabel();
        startDateLabel = new JLabel();
        byLabel = new JLabel();
        
        setTitle("Alarm Details");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        remindButton.setText("Remind Later");
        remindButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                remindAction(evt);
            }
        });
        
        buttonPanel.add(remindButton);
        
        forgetButton.setText("Forget");
        forgetButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                forgetAction(evt);
            }
        });
        
        buttonPanel.add(forgetButton);
        
        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);
        
        mainPanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        mainPanel.setBorder(new javax.swing.border.EtchedBorder());
        jLabel1.setText("Activity");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.ipadx = 10;
        gridBagConstraints1.ipady = 10;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.EAST;
        mainPanel.add(jLabel1, gridBagConstraints1);
        
        jLabel2.setText("Alarm Date");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.ipadx = 10;
        gridBagConstraints1.ipady = 10;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.EAST;
        mainPanel.add(jLabel2, gridBagConstraints1);
        
        jLabel3.setText("By");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.ipadx = 10;
        gridBagConstraints1.ipady = 10;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.EAST;
        mainPanel.add(jLabel3, gridBagConstraints1);
        
        activityLabel.setText("activityLabel");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        mainPanel.add(activityLabel, gridBagConstraints1);
        
        startDateLabel.setText("startDateLabel");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        mainPanel.add(startDateLabel, gridBagConstraints1);
        
        byLabel.setText("byLabel");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        mainPanel.add(byLabel, gridBagConstraints1);
        
        getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);
        
        pack();
    }

	/**
	 * the action that gets called when the 'forget' button is
	 * pressed
	 * @param evt the ActionEvent that gets called
	 */
    private void forgetAction(java.awt.event.ActionEvent evt) {
        // Add your handling code here:
		act.setAlarmAck(true);
		try {
			wb.updateActivity(wb.getCurrentOpportunity().getPK(), act);
			hide();
		} catch (Exception e) {
			ErrorHandler.show(this, e);
		}
    }

	/**
	 * called when the 'remind' button is pressed
	 * @evt the ActionEvent that we receive by our friend "mr java"
	 */
    private void remindAction(java.awt.event.ActionEvent evt) {
        setVisible(false);
        dispose();
    }

    /** 
	 * Closes the dialog 
	 * @param evt the WindowEvent we get 
	 */
    private final void closeDialog(java.awt.event.WindowEvent evt) {
        setVisible(false);
        dispose();
    }


	/**
	 * set the screen's colors 
	 */
	public final void setColors() { 
		jLabel1.setForeground(MainWindow.LETTERS);
		jLabel2.setForeground(MainWindow.LETTERS);
		jLabel3.setForeground(MainWindow.LETTERS);
    	activityLabel.setForeground(MainWindow.LETTERS);
    	startDateLabel.setForeground(MainWindow.LETTERS);
    	byLabel.setForeground(MainWindow.LETTERS);
	}

	/**
	 * set the screen's fonts 
	 */
	public final void setFonts() { 
		jLabel1.setFont(MainWindow.LABEL_FONT);
		jLabel2.setFont(MainWindow.LABEL_FONT);
		jLabel3.setFont(MainWindow.LABEL_FONT);
		remindButton.setFont(MainWindow.LABEL_FONT);
		forgetButton.setFont(MainWindow.LABEL_FONT);
        activityLabel.setFont(MainWindow.FIELD_FONT);
        startDateLabel.setFont(MainWindow.FIELD_FONT);
        byLabel.setFont(MainWindow.FIELD_FONT);
	};

	/**
	 * set the dialog's language
	 */
	public final void setLang() { 
        setTitle(wb.getLang().getString("alarmInfo"));
        jLabel1.setText(wb.getLang().getString("activity"));
        jLabel2.setText(wb.getLang().getString("startDate"));
        jLabel3.setText(wb.getLang().getString("by"));
        remindButton.setText(wb.getLang().getString("remind"));
        forgetButton.setText(wb.getLang().getString("forget"));
	}

    private JPanel buttonPanel;
    private JButton remindButton;
    private JButton forgetButton;
    private JPanel mainPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel activityLabel;
    private JLabel startDateLabel;
    private JLabel byLabel;
	
}
