package sellwin.gui;

import sellwin.domain.*;
import sellwin.utils.*;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.util.*;
import java.text.*;
import javax.swing.event.*;
import java.awt.event.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the customer admin dialog 
 * screen.  Users can update a customer's information
 * using this dialog.  This screen pops up when a 
 * user selects the 'Customer Admin' menu option
 * from the MainWindow.
 */
public class CustAdminDialog extends javax.swing.JDialog 
	implements InventoryListener, GUIChars {

	private Whiteboard wb=null;
	private JDialog thisDialog=null;
	private Customer currentCustomer=new Customer();

	private ProductSelectionDialog addProductSelectionDialog=null;

    private JPanel mainPanel;
    private JScrollPane custScrollPane;
	private JPanel custPanel;
    private JScrollPane custListScrollPane;
    private JList custList;
    private JLabel custLabel;
    private JTextField custField;
    private JLabel annualSalesLabel;
    private JTextField annualSalesField;
    private JLabel industryLabel;
    private JTextField industryField;
    private JLabel channelLabel;
    private JTextField channelField;
    private JLabel inventoryLabel;
	private JTabbedPane tabbedPane = new JTabbedPane();
    private JScrollPane inventoryScrollPane;
	private JPanel inventoryPanel;
    private JTable inventoryTable;
    private AddressPanel contactAddressPanel;
    private AddressPanel shipAddressPanel;
    private AddressPanel billAddressPanel;
    private JPanel buttonPanel;
    private JButton applyButton;
    private JButton clearButton;
    private JButton closeButton;
    private JPopupMenu custPopup;
    private JPopupMenu invPopup;
	private JMenuItem addCustMenuItem;
	private JMenuItem deleteCustMenuItem;
	private JMenuItem addInvMenuItem;
	private JMenuItem deleteInvMenuItem;

	private ProductTableModel inventoryModel = null;
	private TreeMap customerNames=null;
	private DefaultListModel custListModel=null;
	
	private Customer screenCust = new Customer();

	private final NumberFormat format = NumberFormat.getInstance();

    /** 
	 * Creates new form CustAdminDialog
	 * @param parent the containing parent of this dialog
	 * @param modal true if this dialog is to be modal
	 */
    public CustAdminDialog(java.awt.Frame parent, boolean modal) {

        super(parent, modal);
		wb = MainWindow.getWhiteboard();


		thisDialog = this;

        initComponents();
		setFonts();
		setColors();

		inventoryScrollPane.addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger())
                    invPopup.show(inventoryTable, e.getX(), e.getY());
            }
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger())
                    invPopup.show(inventoryTable, e.getX(), e.getY());
            }
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger())
                    invPopup.show(inventoryTable, e.getX(), e.getY());
            }
        });

		inventoryTable.addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger())
                    invPopup.show(inventoryTable, e.getX(), e.getY());
            }
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger())
                    invPopup.show(inventoryTable, e.getX(), e.getY());
            }
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger())
                    invPopup.show(inventoryTable, e.getX(), e.getY());
            }
        });

		inventoryTable.getTableHeader().addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger())
                    invPopup.show(inventoryTable, e.getX(), e.getY());
            }
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger())
                    invPopup.show(inventoryTable, e.getX(), e.getY());
            }
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger())
                    invPopup.show(inventoryTable, e.getX(), e.getY());
            }
        });

		custList.addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger())
                    custPopup.show(custList, e.getX(), e.getY());
            }
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger())
                    custPopup.show(custList, e.getX(), e.getY());
            }
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger())
                    custPopup.show(custList, e.getX(), e.getY());
            }
        });

		deleteCustMenuItem.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String v = (String)(custList.getSelectedValue());
					int opt = JOptionPane.showConfirmDialog(thisDialog, wb.getLang().getString("deleteQuestion")+ " " +v + " ?");
					if (opt == JOptionPane.YES_OPTION) {
						try {	
							wb.deleteCustomer(v);
							customerNames.remove(v);
							updateCustList(null);
							JOptionPane.showMessageDialog(
                                thisDialog,
                                wb.getLang().getString("deleteNotify"),
                                wb.getLang().getString("info"),
                                JOptionPane.INFORMATION_MESSAGE);
						} catch (AngError x) {
							ErrorHandler.show(thisDialog, x);
						}
					}
				}
			}
		);

		addCustMenuItem.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					currentCustomer = new Customer();
					String v = JOptionPane.showInputDialog(wb.getLang().getString("enterCust"));
					if ((v == null) || (v.length() == 0)) return;

					try {	
						currentCustomer.setName(v);
						currentCustomer.setPK(wb.addCustomer(currentCustomer));
						wb.addCustName(currentCustomer.getName());
						clearFields();
						updateCustList(v);
						JOptionPane.showMessageDialog(
                                thisDialog,
                                wb.getLang().getString("custAddNotify"),
                                wb.getLang().getString("info"),
                                JOptionPane.INFORMATION_MESSAGE);
					} catch (AngError x) {
						ErrorHandler.show(thisDialog, x);
					}
				}
			}
		);

		closeButton.addActionListener( 
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					thisDialog.hide();
				}
			}
		);

		applyButton.addActionListener( 
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String cname = (String)(custList.getSelectedValue());
					Customer c = getCustomer();
					int opt = JOptionPane.showConfirmDialog(thisDialog, wb.getLang().getString("updateQuestion")+ " " +cname + " ?");
					if (opt == JOptionPane.YES_OPTION) {
						try {
							copyFields(currentCustomer, c);
							
							wb.updateCustomer(currentCustomer);

							JOptionPane.showMessageDialog(
                                thisDialog,
                                wb.getLang().getString("updateNotify"),
                                wb.getLang().getString("info"),
                                JOptionPane.INFORMATION_MESSAGE);
						} catch (AngError x) {
							ErrorHandler.show(thisDialog, x);
						}
					}
				}
			}
		);

		clearButton.addActionListener( 
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					clear();
				}
			}
		);

		custList.addMouseListener(
            new MouseAdapter() {
                public void mouseClicked(MouseEvent e) {
					if (e.getClickCount() == 1) {
						String value = (String)custList.getSelectedValue();
						if (value == null) return;
						try {
							currentCustomer = wb.getCustomer((String)(customerNames.get(value)));
							setCustomer(currentCustomer);
						} catch (AngError x) {
							ErrorHandler.show(thisDialog, x);
						}
					}
                }
            }
        );

		deleteInvMenuItem.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					int opt = JOptionPane.showConfirmDialog(thisDialog, wb.getLang().getString("deleteInvQuestion"));
					if (opt != JOptionPane.YES_OPTION) return;

					int i = inventoryTable.getSelectedRow();
					ArrayList inventory = currentCustomer.getInventory();
					inventory.remove(i);
        			inventoryTable.tableChanged(new TableModelEvent(inventoryModel));
				}
			}
		);
		addInvMenuItem.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (addProductSelectionDialog == null)
						addProductSelectionDialog = new ProductSelectionDialog((InventoryListener)thisDialog);
					addProductSelectionDialog.show();
				}
			}
		);


		updateCustList(null);
		setSecurity();
		setSize(500, 730);
		inventoryModel = new ProductTableModel(new ArrayList());
		inventoryTable.setModel(inventoryModel);
		setLang();
    }

	/**
	 * build and initialize this dialog's components 
	 */
    private final void initComponents() {
        mainPanel = new JPanel();
		custPanel = new JPanel();
        custList = new JList();
		custListScrollPane = new JScrollPane(custList);
		custListScrollPane.setMinimumSize(new Dimension(300, 160));
		custListScrollPane.setPreferredSize(new Dimension(300, 160));
		custListScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		custPanel.add(custListScrollPane);
        annualSalesLabel = new JLabel();
        custLabel = new JLabel();
        custField = new JTextField();
		custField.setEditable(false);
        annualSalesField = new JTextField();
        industryLabel = new JLabel();
        industryField = new JTextField();
        channelLabel = new JLabel();
        channelField = new JTextField();
        inventoryLabel = new JLabel();
        inventoryScrollPane = new JScrollPane();
		inventoryPanel = new JPanel();
        inventoryTable = new JTable();
        contactAddressPanel = new AddressPanel();
        shipAddressPanel = new AddressPanel();
        billAddressPanel = new AddressPanel();
        buttonPanel = new JPanel();
        applyButton = new JButton();
        clearButton = new JButton();
        closeButton = new JButton();
        custPopup = new JPopupMenu();
        addCustMenuItem = new JMenuItem();
        deleteCustMenuItem = new JMenuItem();
        invPopup = new JPopupMenu();
        addInvMenuItem = new JMenuItem();
        deleteInvMenuItem = new JMenuItem();

		addCustMenuItem.setText("Add"); 
		custPopup.add(addCustMenuItem);
		deleteCustMenuItem.setText("Delete"); 
		custPopup.add(deleteCustMenuItem);

		addInvMenuItem.setText("Add"); 
		invPopup.add(addInvMenuItem);
		deleteInvMenuItem.setText("Delete"); 
		invPopup.add(deleteInvMenuItem);

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        mainPanel.setLayout(new java.awt.GridBagLayout());

		JPanel detailPanel = new JPanel();
		detailPanel.setLayout(new GridBagLayout());

        java.awt.GridBagConstraints gridBagConstraints1;
        
        mainPanel.setBorder(new javax.swing.border.EtchedBorder());

        custList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.ipady = 5;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        mainPanel.add(custPanel, gridBagConstraints1);
      
        custLabel.setText("Customer");
        custLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        GridBagConstraints gbc = new java.awt.GridBagConstraints();
		gbc.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.ipadx = 5;
        gbc.anchor = java.awt.GridBagConstraints.EAST;
        detailPanel.add(custLabel, gbc);

        custField.setHorizontalAlignment(JTextField.LEFT);
		custField.setCaretPosition(0);
        custField.setMaximumSize(new Dimension(240, Prefs.FIELD_HEIGHT));
        custField.setPreferredSize(new Dimension(140, Prefs.FIELD_HEIGHT));
        custField.setMinimumSize(new Dimension(140, Prefs.FIELD_HEIGHT));
        gbc = new java.awt.GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gbc.anchor = java.awt.GridBagConstraints.WEST;
        detailPanel.add(custField, gbc);
       
        annualSalesLabel.setText("Annual Sales");
        annualSalesLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gbc = new java.awt.GridBagConstraints();
		gbc.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.ipadx = 5;
        gbc.anchor = java.awt.GridBagConstraints.EAST;
        detailPanel.add(annualSalesLabel, gbc);
        
        annualSalesField.setText("0");
        annualSalesField.setPreferredSize(new Dimension(140, Prefs.FIELD_HEIGHT));
        annualSalesField.setMinimumSize(new Dimension(140, Prefs.FIELD_HEIGHT));
        gbc = new java.awt.GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gbc.anchor = java.awt.GridBagConstraints.WEST;
        detailPanel.add(annualSalesField, gbc);

		annualSalesField.addFocusListener(
			new FocusListener() {
				public void focusGained(FocusEvent e) {}
				public void focusLost(FocusEvent e) {
					try {
						Number num = format.parse(annualSalesField.getText());
						double x = num.doubleValue();
						annualSalesField.setText(Prefs.wholeMoney.format(x));
					} catch (ParseException p) {
						Toolkit.getDefaultToolkit().beep();
						return;
					}
				}
			}
		);
       
        industryLabel.setText("Industry");
        industryLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gbc = new java.awt.GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
		gbc.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gbc.ipadx = 5;
        gbc.anchor = java.awt.GridBagConstraints.EAST;
        detailPanel.add(industryLabel, gbc);
        
        industryField.setText("industry");
        industryField.setPreferredSize(new Dimension(140, Prefs.FIELD_HEIGHT));
        industryField.setMinimumSize(new Dimension(140, Prefs.FIELD_HEIGHT));
        gbc = new java.awt.GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gbc.anchor = java.awt.GridBagConstraints.WEST;
        detailPanel.add(industryField, gbc);
       
        channelLabel.setText("Channel");
        channelLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gbc = new java.awt.GridBagConstraints();
		gbc.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.ipadx = 5;
        gbc.anchor = java.awt.GridBagConstraints.EAST;
        detailPanel.add(channelLabel, gbc);
        
        channelField.setText("channel");
        channelField.setPreferredSize(new Dimension(140, Prefs.FIELD_HEIGHT));
        channelField.setMinimumSize(new Dimension(140, Prefs.FIELD_HEIGHT));
        gbc = new java.awt.GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gbc.anchor = java.awt.GridBagConstraints.WEST;
        detailPanel.add(channelField, gbc);

        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.ipadx = 5;
        gridBagConstraints1.ipady = 5;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
		mainPanel.add(detailPanel, gridBagConstraints1);
        
        inventoryScrollPane.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		inventoryScrollPane.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        inventoryScrollPane.setViewportBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        inventoryScrollPane.setMinimumSize(new Dimension(300, 120));
        inventoryScrollPane.setPreferredSize(new Dimension(300, 120));
        inventoryTable.setMinimumSize(new Dimension(300, 120));
        inventoryTable.setPreferredSize(new Dimension(300, 120));
        inventoryScrollPane.setViewportView(inventoryTable);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.ipadx = 5;
        gridBagConstraints1.ipady = 5;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
		inventoryPanel.add(inventoryScrollPane);

		mainPanel.add(tabbedPane, gridBagConstraints1);
		tabbedPane.add(wb.getLang().getString("inventory"), inventoryPanel);
        
		tabbedPane.add(wb.getLang().getString("contact"), contactAddressPanel);
        
		tabbedPane.add(wb.getLang().getString("shipAddress"), shipAddressPanel);
        
		tabbedPane.add(wb.getLang().getString("billAddress"), billAddressPanel);
        
        getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);
        
        applyButton.setText("Apply");
        buttonPanel.add(applyButton);
        
        clearButton.setText("Clear");
        buttonPanel.add(clearButton);
        
        closeButton.setText("Cancel");
        buttonPanel.add(closeButton);
        
        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);
        
        pack();
    }

	/**
     * Closes the dialog 
	 * @param evt the WindowEvent we receive
	 */
    private final void closeDialog(java.awt.event.WindowEvent evt) {
        setVisible(false);
        dispose();
    }


	/**
	 * clear the dialog's screen contents 
	 */
	private final void clear() {
		shipAddressPanel.clear();
		contactAddressPanel.clear();
		billAddressPanel.clear();
		channelField.setText("");
		industryField.setText("");
		annualSalesField.setText("0");
	}

	/**
	 * set the current customer on the screen 
	 * @param c the Customer we want to display
	 */
	private final void setCustomer(Customer c) {
		custField.setText(c.getName());
		custField.setCaretPosition(0);
        annualSalesField.setText(Prefs.wholeMoney.format(c.getAnnualSales()));
        industryField.setText(c.getIndustry());
        channelField.setText(c.getChannel());
		if (c.getContact() == null)
			contactAddressPanel.clear();
		else
        	contactAddressPanel.setAddress(c.getContact());
		if (c.getShipAddress() == null)
			shipAddressPanel.clear();
		else
        	shipAddressPanel.setAddress(c.getShipAddress());
		if (c.getBillAddress() == null)
			billAddressPanel.clear();
		else
        	billAddressPanel.setAddress(c.getBillAddress());
		inventoryModel = new ProductTableModel(c.getInventory());
		inventoryTable.setModel(inventoryModel);
        inventoryTable.tableChanged(new TableModelEvent(inventoryModel));
	}

	/**
	 * copy the screen's fields from one customer object
	 * to another
	 * @param to the 'to' customer object
	 * @param from the 'from' customer object
	 */
	private final void copyFields(Customer to, Customer from) {
		to.setName(from.getName());
		to.setAnnualSales(from.getAnnualSales());
		to.setIndustry(from.getIndustry());
		to.setChannel(from.getChannel());
		long pk = to.getContact().getPK(); //save the orig pk
		to.setContact(from.getContact()); //overlay
		to.getContact().setPK(pk); //restore orig pk
		pk = to.getShipAddress().getPK(); //save the orig pk
		to.setShipAddress(from.getShipAddress()); //overlay
		to.getShipAddress().setPK(pk); //restore orig pk
		pk = to.getBillAddress().getPK(); //save the orig pk
		to.setBillAddress(from.getBillAddress()); //overlay
		to.getBillAddress().setPK(pk); //restore orig pk
	}

	/**
	 * get a Customer object from the screen's fields
	 * @return the Customer
	 */
	private final Customer getCustomer() {
		screenCust.setName(custField.getText());
		Number num = Prefs.wholeMoney.parse(annualSalesField.getText(), new ParsePosition(0));
        screenCust.setAnnualSales(num.intValue());
        screenCust.setIndustry(industryField.getText());
        screenCust.setChannel(channelField.getText());
		if (screenCust.getContact() == null) {
			screenCust.setContact(new Address());
			screenCust.setContact(new Address());
		}
        screenCust.setContact(contactAddressPanel.getAddress());
		if (screenCust.getShipAddress() == null) {
			screenCust.setShipAddress(new Address());
			screenCust.setBillAddress(new Address());
		}
			
        screenCust.setShipAddress(shipAddressPanel.getAddress());
        screenCust.setBillAddress(billAddressPanel.getAddress());
		screenCust.setInventory(currentCustomer.getInventory());
		return screenCust;
	}	

	/**
	 * set the screen's fonts
	 */
	public final void setFonts() {
		tabbedPane.setFont(MainWindow.LABEL_FONT);
  		addCustMenuItem.setFont(MainWindow.LABEL_FONT);
        deleteCustMenuItem.setFont(MainWindow.LABEL_FONT);
        addInvMenuItem.setFont(MainWindow.LABEL_FONT);
        deleteInvMenuItem.setFont(MainWindow.LABEL_FONT);
        custList.setFont(MainWindow.FIELD_FONT);
        annualSalesLabel.setFont(MainWindow.LABEL_FONT);
        annualSalesField.setFont(MainWindow.FIELD_FONT);
        industryLabel.setFont(MainWindow.LABEL_FONT);
        industryField.setFont(MainWindow.FIELD_FONT);
        channelLabel.setFont(MainWindow.LABEL_FONT);
        channelField.setFont(MainWindow.FIELD_FONT);
        custLabel.setFont(MainWindow.LABEL_FONT);
        inventoryLabel.setFont(MainWindow.LABEL_FONT);
        inventoryTable.setFont(MainWindow.FIELD_FONT);
        applyButton.setFont(MainWindow.LABEL_FONT);
        clearButton.setFont(MainWindow.LABEL_FONT);
        closeButton.setFont(MainWindow.LABEL_FONT);
	}

	/**
	 * set the screen's colors
	 */
	public final void setColors() {
        annualSalesLabel.setForeground(MainWindow.LETTERS);
        industryLabel.setForeground(MainWindow.LETTERS);
        channelLabel.setForeground(MainWindow.LETTERS);
        custLabel.setForeground(MainWindow.LETTERS);
        inventoryLabel.setForeground(MainWindow.LETTERS);
	}

	/**
	 * udpate the customer list 
	 */
	private final void updateCustList(String requestedKey) {
		try {
			customerNames = wb.getAllCustNames(true);
		} catch (AngError e) {
			ErrorHandler.show(thisDialog, e);
		}

		Object[] keys = customerNames.keySet().toArray();
		custList.setListData(keys);
		custList.updateUI();

		if (keys.length > 0) {
			if (requestedKey == null) {
				custList.setSelectedIndex(0);
				requestedKey = (String)keys[0];
			}
			else
				custList.setSelectedValue(requestedKey, true);

			try {
				currentCustomer = wb.getCustomer(requestedKey);
				setCustomer(currentCustomer);
			} catch (AngError e) {
				ErrorHandler.show(thisDialog, e);
			}
		}
	}

	/**
	 * add a quote line to the screen's list
	 * @param x the QuoteLine to add
	 */
	public final void addQuoteLine(QuoteLine x) {
		int lineCt = currentCustomer.getInventory().size();
		CustomerInventory ci = new CustomerInventory();
		ci.setCount(x.getQuantity());
		ci.setProduct(x.getProduct());
		ci.setCustomerPK(currentCustomer.getPK());
		try {
			wb.addCustomerInventory(ci);
			currentCustomer.addInventory(ci);
			inventoryModel = new ProductTableModel(currentCustomer.getInventory());
			inventoryTable.setModel(inventoryModel);
        	inventoryTable.tableChanged(new TableModelEvent(inventoryModel));
        	inventoryTable.setRowSelectionInterval(lineCt, lineCt);
			JOptionPane.showMessageDialog(
            	thisDialog,
                wb.getLang().getString("custInvAddNotify"),
                wb.getLang().getString("info"),
                JOptionPane.INFORMATION_MESSAGE);
		} catch (AngError e) {
			ErrorHandler.show(thisDialog, e);
		}
	}

	/**
	 * set the screen's fields to enabled or disabled
	 * depending upon the user's security profile
	 */
	private final void setSecurity() {
		try {
			if (wb.getLogin().basicAdminWritable()) {
    			applyButton.setEnabled(true);
    			custPopup.setEnabled(true);
    			invPopup.setEnabled(true);
				addCustMenuItem.setEnabled(true);
				deleteCustMenuItem.setEnabled(true);
				addInvMenuItem.setEnabled(true);
				deleteInvMenuItem.setEnabled(true); 
			} else {
    			applyButton.setEnabled(false);
    			custPopup.setEnabled(false);
    			invPopup.setEnabled(false);
				addCustMenuItem.setEnabled(false);
				deleteCustMenuItem.setEnabled(false);
				addInvMenuItem.setEnabled(false);
				deleteInvMenuItem.setEnabled(false);
			}
		} catch (AngError e) {
			ErrorHandler.show(thisDialog, e);
		}
	}

	/**
	 * set the screen's text fields to some language
	 */
	public final void setLang() {
		inventoryModel.setLang();
		setTitle(wb.getLang().getString("custAdmin"));
		custPanel.setBorder(
			new javax.swing.border.TitledBorder(
				null,
				wb.getLang().getString("customer"),
				TitledBorder.DEFAULT_JUSTIFICATION,
				TitledBorder.DEFAULT_POSITION,
				MainWindow.LABEL_FONT,
				MainWindow.LETTERS
			)
		);
        applyButton.setText(wb.getLang().getString("apply"));
        clearButton.setText(wb.getLang().getString("clear"));
        closeButton.setText(wb.getLang().getString("close"));
	
        custLabel.setText(wb.getLang().getString("customer"));
        channelLabel.setText(wb.getLang().getString("channel"));
        industryLabel.setText(wb.getLang().getString("industry"));
        annualSalesLabel.setText(wb.getLang().getString("annualSales"));
	}

	private void clearFields() {
    	custField.setText("");
    	annualSalesField.setText("");
    	industryField.setText("");
    	channelField.setText("");
	}
}
