package sellwin.gui;

import sellwin.domain.*;
import sellwin.utils.*;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.rmi.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the Customer panel a user
 * sees when they select the 'Customer' tab
 * from the main window GUI.
 */
public class CustPanel extends JPanel implements GUIChars {

	private final static int TABLE_WIDTH=400;
	private final static int TABLE_HEIGHT=150;

	private JPopupMenu popup = new JPopupMenu();

    private JPanel buttonPanel;
    private JMenuItem newMenuItem;
    private JMenuItem deleteMenuItem;
    private JButton refreshButton;
    private JMenuItem addProdMenuItem;
    private final javax.swing.JPanel mainPanel = new JPanel();
    private JLabel custLabel;
    private JTextField custField;
    private JLabel salesLabel;
    private JTextField salesField;
    private JLabel industryLabel;
    private JTextField industryField;
    private JLabel channelLabel;
    private JTextField channelField;
    private JLabel contactLabel;
    private JTextField contactField;
    private JLabel invLabel;
	private JPanel invPanel;
    private JScrollPane jScrollPane1;
    private final javax.swing.JTable products = new JTable();

	private Whiteboard wb;
	private JPanel parent = null;
	private ProductTableModel currentModel = null;
	private ProductSelectionDialog addProductSelectionDialog = null;

  	private final static int STRUT_LEN=3; 

	/**
	 * construct a CustPanel 
	 */
	public CustPanel() {
		super();
		parent = this;
		wb = MainWindow.getWhiteboard();
        setLayout(new BorderLayout());

        initComponents();
		setFonts();
		setColors();

		setEditable(false);

		refreshButton.addActionListener(
			new ActionListener() {
                public void actionPerformed(ActionEvent e) {
					try {
						ArrayList inv = wb.getCustomerInventory();
						System.out.println(inv.size() + " = inv cnt");
						Customer cust = wb.getCurrentOpportunity().getCustomer();
						cust.setInventory(inv);
						if (inv.size() > 0)  
							putCustomerOnScreen(cust);
					} catch (Exception x) {
						ErrorHandler.show(parent, x);
					}
                }
			});

		deleteMenuItem.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					try {
						String custName = custField.getText();
						clearScreen();
						wb.deleteCustomer(custName);
						custField.setText("");
					} catch (Exception x) {
						ErrorHandler.show(parent, x);
					}
				}
			});

   		addProdMenuItem.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    try {
						if (addProductSelectionDialog == null)
							addProductSelectionDialog = new ProductSelectionDialog((InventoryListener)parent);
						addProductSelectionDialog.show();
						addProductSelectionDialog.requestFocus();
                    } catch (Exception x) {
                        ErrorHandler.show(parent, x);
                    }
                }
            });

		setColor();
	
		createPopup();

		mainPanel.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if (e.isPopupTrigger())
					popup.show(products, e.getX(), e.getY());
			}
			public void mouseReleased(MouseEvent e) {
				if (e.isPopupTrigger())
					popup.show(products, e.getX(), e.getY());
			}
			public void mouseClicked(MouseEvent e) {
				if (e.isPopupTrigger())
					popup.show(products, e.getX(), e.getY());
			}
		});
		products.getTableHeader().addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if (e.isPopupTrigger())
					popup.show(products, e.getX(), e.getY());
			}
			public void mouseReleased(MouseEvent e) {
				if (e.isPopupTrigger())
					popup.show(products, e.getX(), e.getY());
			}
			public void mouseClicked(MouseEvent e) {
				if (e.isPopupTrigger())
					popup.show(products, e.getX(), e.getY());
			}
		});
		currentModel = new ProductTableModel(new ArrayList());
		products.setModel(currentModel);
		setLang();
	}

	/**
	 * construct the popup menu
	 */
	public final void createPopup() {
		popup.add(new JMenuItem("one"));
	}

	/**
	 * load the customer list into this panel 
	 */
	public final void loadCustomerList() 
		throws RemoteException, AngError {

		custField.setText(wb.getCurrentOpportunity().getCustomer().getName());
	}

	/**
	 * enable or disable the panel's fields 
	 * @param t true or false
	 */
	public final void setEnabled(boolean t) {
		custField.setEnabled(t);
		salesField.setEnabled(t);
		industryField.setEnabled(t);
		channelField.setEnabled(t);
		contactField.setEnabled(t);
		products.setEnabled(t);
	}

	/**
	 * get a Customer from the screen's fields
	 * @return the Customer from the screen's fields
	 */
	public final void getCustomerFromScreen() {
		Customer cust = wb.getCustomer();
		String custName = custField.getText();
		cust.setName(custName);
		cust.setAnnualSales(Integer.parseInt(salesField.getText()));
		cust.setIndustry(industryField.getText());
		cust.setChannel(channelField.getText());
	}

	/**
	 * clear the screen's fields
	 */
	public final void clearScreen() {
		salesField.setText("");
		channelField.setText("");
		contactField.setText("");
		industryField.setText("");
	}

	/**
	 * put a Customer onto the screen 
	 * @param c the Customer to display
	 */
	public final void putCustomerOnScreen(Customer c) {
		Utility.strSet(custField, c.getName());
		Utility.strSet(salesField, Prefs.wholeMoney.format(c.getAnnualSales()));
		Utility.strSet(channelField, c.getChannel());
		Utility.strSet(industryField, c.getIndustry());
		Utility.strSet(contactField, c.getContact().getFormattedName());
		currentModel = new ProductTableModel(c.getInventory());
		products.setModel(currentModel);
		products.tableChanged(new TableModelEvent(currentModel));
	}


	/**
	 * set the screen's label colors 
	 */
	public final void setColor() {
		custLabel.setForeground(MainWindow.LETTERS);
		salesLabel.setForeground(MainWindow.LETTERS);
		industryLabel.setForeground(MainWindow.LETTERS);
		channelLabel.setForeground(MainWindow.LETTERS);
		contactLabel.setForeground(MainWindow.LETTERS);
		invLabel.setForeground(MainWindow.LETTERS);
		products.setBackground(getBackground());
	}

	/**
	 * set the screen's fonts 
	 */
	public final void setFonts() {
		custLabel.setFont(MainWindow.LABEL_FONT);
		custField.setFont(MainWindow.FIELD_FONT);
		salesLabel.setFont(MainWindow.LABEL_FONT);
		salesField.setFont(MainWindow.FIELD_FONT);
		industryLabel.setFont(MainWindow.LABEL_FONT);
		industryField.setFont(MainWindow.FIELD_FONT);
		channelLabel.setFont(MainWindow.LABEL_FONT);
		channelField.setFont(MainWindow.FIELD_FONT);
		contactLabel.setFont(MainWindow.LABEL_FONT);
		invLabel.setFont(MainWindow.LABEL_FONT);
		contactField.setFont(MainWindow.FIELD_FONT);
		products.setFont(MainWindow.FIELD_FONT);
		newMenuItem.setFont(MainWindow.LABEL_FONT);
		deleteMenuItem.setFont(MainWindow.LABEL_FONT);
		refreshButton.setFont(MainWindow.LABEL_FONT);
		addProdMenuItem.setFont(MainWindow.LABEL_FONT);
	}


    /** This method is called from within the constructor to
     * initialize the form.
     */
    private final void initComponents() {
        buttonPanel = new JPanel();
        newMenuItem = new JMenuItem();
        deleteMenuItem = new JMenuItem();
        refreshButton = new JButton();
        addProdMenuItem = new JMenuItem();
        custLabel = new JLabel();
        custField = new JTextField();
        salesLabel = new JLabel();
        salesField = new JTextField();
        industryLabel = new JLabel();
        industryField = new JTextField();
        channelLabel = new JLabel();
        channelField = new JTextField();
        contactLabel = new JLabel();
		invPanel = new JPanel();
        invLabel = new JLabel();
        contactField = new JTextField();
        jScrollPane1 = new JScrollPane();
        
        setLayout(new java.awt.BorderLayout());
        
        newMenuItem.setText("New");
        
        deleteMenuItem.setText("Delete");
        
        refreshButton.setText("Update");
        buttonPanel.add(refreshButton);
        
        addProdMenuItem.setText("Add Product");
       
		//for the admin version, show this button panel
		//and add the popup menu 
        add(buttonPanel, java.awt.BorderLayout.SOUTH);
        
        mainPanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        mainPanel.setBorder(new javax.swing.border.EtchedBorder());
        custLabel.setText("Name");
        custLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        mainPanel.add(custLabel, gridBagConstraints1);
        
        custField.setText("custField");
        custField.setMinimumSize(new Dimension(120, Prefs.FIELD_HEIGHT));
        custField.setPreferredSize(new Dimension(120, Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        mainPanel.add(custField, gridBagConstraints1);
        
        salesLabel.setText("Annual Sales");
        salesLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        mainPanel.add(salesLabel, gridBagConstraints1);
        
        salesField.setText("");
        salesField.setMinimumSize(new Dimension(120, Prefs.FIELD_HEIGHT));
        salesField.setPreferredSize(new Dimension(120, Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        mainPanel.add(salesField, gridBagConstraints1);
        
        industryLabel.setText("Industry");
        industryLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        mainPanel.add(industryLabel, gridBagConstraints1);
        
        industryField.setText("");
        industryField.setMinimumSize(new Dimension(120, Prefs.FIELD_HEIGHT));
        industryField.setPreferredSize(new Dimension(120, Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        mainPanel.add(industryField, gridBagConstraints1);
        
        channelLabel.setText("Channel");
        channelLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        mainPanel.add(channelLabel, gridBagConstraints1);
        
        channelField.setText("");
        channelField.setMinimumSize(new Dimension(120, Prefs.FIELD_HEIGHT));
        channelField.setPreferredSize(new Dimension(120, Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        mainPanel.add(channelField, gridBagConstraints1);
        
        contactLabel.setText("Contact");
        contactLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        mainPanel.add(contactLabel, gridBagConstraints1);

        contactField.setText("");
        contactField.setMinimumSize(new Dimension(120, Prefs.FIELD_HEIGHT));
        contactField.setPreferredSize(new Dimension(120, Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        mainPanel.add(contactField, gridBagConstraints1);
      
        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        jScrollPane1.setPreferredSize(new Dimension(TABLE_WIDTH, TABLE_HEIGHT));
        jScrollPane1.setMinimumSize(new Dimension(TABLE_WIDTH, TABLE_HEIGHT));
        products.setModel(new javax.swing.table.DefaultTableModel(
        new Object [][] {
            {null, null, null, null},
            {null, null, null, null},
            {null, null, null, null},
            {null, null, null, null}
        },
        new String [] {
            "Title 1", "Title 2", "Title 3", "Title 4"
        }
        ) {
            Class[] types = new Class [] {
                java.lang.Object.class, java.lang.Object.class, java.lang.Object.class, java.lang.Object.class
            };
            
            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        products.setPreferredSize(new Dimension(TABLE_WIDTH, TABLE_HEIGHT));
        products.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_ALL_COLUMNS);
        products.setMinimumSize(new Dimension(TABLE_WIDTH, TABLE_HEIGHT));
        jScrollPane1.setViewportView(products);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.gridwidth = 5;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
		invPanel.add(jScrollPane1); 
        mainPanel.add(invPanel, gridBagConstraints1);
        
        add(mainPanel, java.awt.BorderLayout.CENTER);
        
    }

	/**
	 * set the screen's fields to editable or not
	 * @param b true means editable
	 */
	private final void setEditable(boolean b) {
    	custField.setEditable(b);
    	salesField.setEditable(b);
    	industryField.setEditable(b);
    	channelField.setEditable(b);
    	contactField.setEditable(b);
	}

	/**
	 * update the screen with the current opportunity 
	 */
	public final void refreshOpportunity() {
		Opportunity opp = wb.getCurrentOpportunity();
		Customer c = opp.getCustomer();
		putCustomerOnScreen(c);
	}

	/**
	 * clear the screen 
	 */
	public final void clearOpportunity() {
		Utility.strSet(custField, null);
		Utility.strSet(salesField, null);
		Utility.strSet(channelField, null);
		Utility.strSet(industryField, null);
		Utility.strSet(contactField, null);
		currentModel = new ProductTableModel(new ArrayList());
		products.setModel(currentModel);
	}

	/**
	 * set the screen's text to a language
	 */
	public final void setLang() {
		currentModel.setLang();
        newMenuItem.setText(wb.getLang().getString("new"));
        deleteMenuItem.setText(wb.getLang().getString("delete"));
        refreshButton.setText(wb.getLang().getString("refresh"));
        addProdMenuItem.setText(wb.getLang().getString("addProduct"));
        custLabel.setText(wb.getLang().getString("name"));
        salesLabel.setText(wb.getLang().getString("annualSales"));
        industryLabel.setText(wb.getLang().getString("industry"));
        channelLabel.setText(wb.getLang().getString("channel"));
        contactLabel.setText(wb.getLang().getString("contact"));
		invPanel.setBorder(
			new TitledBorder(
				null,
				wb.getLang().getString("currInv"),
				TitledBorder.DEFAULT_JUSTIFICATION,
				TitledBorder.DEFAULT_POSITION,
				MainWindow.LABEL_FONT,
				MainWindow.LETTERS
			)
		); 
	}

	public final void setColors() {
	}
}
