package sellwin.gui;

import sellwin.utils.*;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements a date renderer for the 
 * tables used in SellWIN that display a Java Date
 */
public class DateRenderer extends JLabel implements TableCellRenderer {

	private Date currentDate;

	/**
	 * construct a date renderer 
	 */
	public DateRenderer() {
		super();
		setBackground(MainWindow.LETTERS);
		setFont(MainWindow.FIELD_FONT);
	}

	/**
	 * part of the java interface spec 
	 */
	public final Component getTableCellRendererComponent(
		JTable table, Object date,
		boolean isSelected, boolean hasFocus,
		int row, int col) {

		currentDate = (Date)date;

		if (date == null)
			date = new Date();
		setText(Prefs.dateFormat.format((Date)date));
		return this;
	}


	/**
	 * get the date used by this renderer 
	 * @return the date being used
	 */
	public final Date getDate() {
		return currentDate;
	}

	/**
	 * set the label's text using the object (date) 
	 * @param value the object we are to render
	 */
	public final void setValue(Object value) {
		if (value == null)
			currentDate = new Date();
		else {
			currentDate = (Date)value;
		}


		setText(currentDate.toString());
	}
}
